/*
 * Decompiled with CFR 0.152.
 */
package icy.image.colormodel;

import icy.image.colormodel.IcyColorModel;
import icy.image.lut.LUT;
import icy.type.DataType;

public class UShortColorModel
extends IcyColorModel {
    public UShortColorModel(int numComponents, int[] bits) {
        super(numComponents, DataType.USHORT, bits);
    }

    @Override
    public int getRGB(Object pixel) {
        short[] pix = (short[])pixel;
        int[] scaledData = new int[this.numComponents];
        for (int comp = 0; comp < this.numComponents; ++comp) {
            scaledData[comp] = (int)this.colormapScalers[comp].scale(pix[comp] & 0xFFFF);
        }
        return this.getIcyColorSpace().toRGBUnnorm(scaledData);
    }

    @Override
    public int getRGB(Object pixel, LUT lut) {
        short[] pix = (short[])pixel;
        int[] scaledData = new int[this.numComponents];
        for (int comp = 0; comp < this.numComponents; ++comp) {
            scaledData[comp] = (int)lut.getLutChannel(comp).getScaler().scale(pix[comp] & 0xFFFF);
        }
        return lut.getColorSpace().toRGBUnnorm(scaledData);
    }

    @Override
    public int[] getComponents(Object pixel, int[] components, int offset) {
        int[] result;
        if (components == null) {
            result = new int[offset + this.numComponents];
        } else {
            if (components.length - offset < this.numComponents) {
                throw new IllegalArgumentException("Length of components array < number of components in model");
            }
            result = components;
        }
        short[] data = (short[])pixel;
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            result[offset + i] = data[i] & 0xFFFF;
        }
        return result;
    }

    @Override
    public Object getDataElements(int[] components, int offset, Object obj) {
        if (components.length - offset < this.numComponents) {
            throw new IllegalArgumentException("Component array too small (should be " + this.numComponents);
        }
        int len = components.length;
        short[] pixel = obj == null ? new short[this.numComponents] : (short[])obj;
        for (int i = 0; i < len; ++i) {
            pixel[i] = (short)components[offset + i];
        }
        return pixel;
    }

    @Override
    public Object getDataElements(float[] normComponents, int offset, Object obj) {
        short[] pixel = obj == null ? new short[this.numComponents] : (short[])obj;
        int c = 0;
        int nc = offset;
        while (c < this.numComponents) {
            pixel[c] = (short)this.normalScalers[c].unscale(normComponents[nc]);
            ++c;
            ++nc;
        }
        return pixel;
    }

    @Override
    public float[] getNormalizedComponents(Object pixel, float[] normComponents, int normOffset) {
        float[] result = normComponents == null ? new float[this.numComponents + normOffset] : normComponents;
        short[] data = (short[])pixel;
        int c = 0;
        int nc = normOffset;
        while (c < this.numComponents) {
            result[nc] = (float)this.normalScalers[c].scale(data[c] & 0xFFFF);
            ++c;
            ++nc;
        }
        return result;
    }
}

