/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi3d;

import icy.roi.ROI2D;
import icy.type.rectangle.Rectangle3D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi3d.ROI3DStackShape;

public class ROI3DStackEllipse
extends ROI3DStackShape {
    public ROI3DStackEllipse() {
        super(ROI2DEllipse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROI3DStackEllipse(Rectangle3D rect) {
        this();
        if (rect.isInfiniteZ()) {
            throw new IllegalArgumentException("Cannot set infinite Z dimension on the 3D Stack Ellipse ROI.");
        }
        Rectangle2D rect2d = rect.toRectangle2D();
        this.beginUpdate();
        try {
            for (int z = (int)Math.floor(rect.getMinZ()); z <= (int)rect.getMaxZ(); ++z) {
                this.setSlice(z, (ROI2D)new ROI2DEllipse(rect2d));
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROI3DStackEllipse(Rectangle2D rect, int zMin, int zMax) {
        this();
        if (zMax < zMin) {
            throw new IllegalArgumentException("ROI3DStackEllipse: cannot create the ROI (zMax < zMin).");
        }
        this.beginUpdate();
        try {
            for (int z = zMin; z <= zMax; ++z) {
                this.setSlice(z, (ROI2D)new ROI2DEllipse(rect));
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public ROI3DStackEllipse(Ellipse2D ellipse, int zMin, int zMax) {
        this(ellipse.getBounds2D(), zMin, zMax);
    }

    public String getDefaultName() {
        return "Ellipse2D stack";
    }
}

