/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence;

import icy.common.CollapsibleEvent;
import icy.sequence.Sequence;
import icy.util.StringUtil;

public class SequenceEvent
implements CollapsibleEvent {
    private final Sequence sequence;
    private final SequenceEventSourceType sourceType;
    private SequenceEventType type;
    private Object source;
    private int param;

    public SequenceEvent(Sequence sequence, SequenceEventSourceType sourceType) {
        this(sequence, sourceType, null, SequenceEventType.CHANGED, -1);
    }

    public SequenceEvent(Sequence sequence, SequenceEventSourceType sourceType, Object source) {
        this(sequence, sourceType, source, SequenceEventType.CHANGED, -1);
    }

    public SequenceEvent(Sequence sequence, SequenceEventSourceType sourceType, Object source, int param) {
        this(sequence, sourceType, source, SequenceEventType.CHANGED, param);
    }

    public SequenceEvent(Sequence sequence, SequenceEventSourceType sourceType, SequenceEventType type) {
        this(sequence, sourceType, null, type, -1);
    }

    public SequenceEvent(Sequence sequence, SequenceEventSourceType sourceType, Object source, SequenceEventType type) {
        this(sequence, sourceType, source, type, -1);
    }

    public SequenceEvent(Sequence sequence, SequenceEventSourceType sourceType, Object source, SequenceEventType type, int param) {
        this.sequence = sequence;
        this.sourceType = sourceType;
        this.source = source;
        this.type = type;
        this.param = param;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public SequenceEventSourceType getSourceType() {
        return this.sourceType;
    }

    public Object getSource() {
        return this.source;
    }

    public SequenceEventType getType() {
        return this.type;
    }

    public int getParam() {
        return this.param;
    }

    @Override
    public boolean collapse(CollapsibleEvent event) {
        if (this.equals(event)) {
            SequenceEvent e = (SequenceEvent)event;
            switch (this.sourceType) {
                case SEQUENCE_COLORMAP: 
                case SEQUENCE_COMPONENTBOUNDS: {
                    if (e.getParam() == this.param) break;
                    this.param = -1;
                    break;
                }
                case SEQUENCE_DATA: {
                    if (e.getType() != this.type) {
                        this.type = SequenceEventType.CHANGED;
                    }
                    if (e.getSource() == this.source) break;
                    this.source = null;
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int res = this.sequence.hashCode() ^ this.sourceType.hashCode();
        switch (this.sourceType) {
            case SEQUENCE_META: {
                if (this.source == null) break;
                res ^= this.source.hashCode();
                break;
            }
            case SEQUENCE_PAINTER: 
            case SEQUENCE_OVERLAY: 
            case SEQUENCE_ROI: {
                res ^= this.type.hashCode();
                if (this.source == null) break;
                res ^= this.source.hashCode();
                break;
            }
        }
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        SequenceEvent e;
        if (obj instanceof SequenceEvent && (e = (SequenceEvent)obj).getSequence() == this.sequence && e.getSourceType() == this.sourceType) {
            switch (this.sourceType) {
                case SEQUENCE_META: {
                    return StringUtil.equals((String)e.getSource(), (String)this.source);
                }
                case SEQUENCE_COLORMAP: 
                case SEQUENCE_COMPONENTBOUNDS: {
                    return true;
                }
                case SEQUENCE_DATA: {
                    return true;
                }
                case SEQUENCE_PAINTER: 
                case SEQUENCE_OVERLAY: 
                case SEQUENCE_ROI: {
                    return e.getType() == this.type && e.getSource() == this.source;
                }
                case SEQUENCE_TYPE: {
                    return true;
                }
            }
        }
        return super.equals(obj);
    }

    public static enum SequenceEventType {
        CHANGED,
        ADDED,
        REMOVED;

    }

    public static enum SequenceEventSourceType {
        SEQUENCE_TYPE,
        SEQUENCE_META,
        SEQUENCE_COLORMAP,
        SEQUENCE_COMPONENTBOUNDS,
        SEQUENCE_DATA,
        SEQUENCE_ROI,
        SEQUENCE_PAINTER,
        SEQUENCE_OVERLAY;

    }
}

