/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.morphology.watershed;

import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.sequence.VolumetricImage;
import icy.sequence.VolumetricImageCursor;
import icy.type.DataIteratorUtil;
import icy.type.DataType;
import icy.type.dimension.Dimension3D;
import icy.type.dimension.Dimension5D;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.util.Random;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import plugins.kernel.image.filtering.GaussianFiltering;
import plugins.kernel.image.filtering.LocalMaxFiltering;
import plugins.kernel.image.filtering.convolution.ConvolutionException;
import plugins.kernel.roi.morphology.ROIDistanceTransformCalculator;
import plugins.kernel.roi.morphology.watershed.FloodingStructure;
import plugins.kernel.roi.morphology.watershed.LabeledPixel;
import plugins.kernel.roi.morphology.watershed.Point3D;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class ROIWatershedCalculator
implements Callable<Void> {
    private Dimension3D pixelSize;
    private Dimension5D imageSize;
    private List<ROI> seedRois;
    private List<ROI> domainRois;
    private boolean newBasinsAllowed;
    private Sequence domainDistanceMap;
    private Sequence labelSequence;
    private Map<Integer, List<LabeledPixel>> labeledPixels;
    private List<ROI> labeledRois;

    private ROIWatershedCalculator() {
    }

    private void setImageSize(Dimension5D imageSize) {
        this.imageSize = imageSize;
    }

    private void setPixelSize(Dimension3D pixelSize) {
        this.pixelSize = pixelSize;
    }

    private void setDomainRois(List<ROI> domainRois) {
        this.domainRois = domainRois;
    }

    private void setSeedRois(List<ROI> seedRois) {
        this.seedRois = seedRois;
    }

    private void setNewBasinsAllowed(boolean newBasinsAllowed) {
        this.newBasinsAllowed = newBasinsAllowed;
    }

    @Override
    public Void call() throws Exception {
        this.labeledRois = null;
        this.computeDomainDistanceMap();
        this.prepareSeeds();
        this.computeWatershedOnFrames();
        return null;
    }

    private void computeDomainDistanceMap() throws InterruptedException {
        ROIDistanceTransformCalculator dt = new ROIDistanceTransformCalculator(this.imageSize, this.pixelSize, true);
        dt.addAll(this.domainRois);
        try {
            this.domainDistanceMap = dt.getDistanceMap();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error computing domain distance map: " + e.getMessage(), e);
        }
    }

    private void prepareSeeds() throws InterruptedException {
        if (this.seedRois.isEmpty() && !this.newBasinsAllowed) {
            this.seedRois.addAll(this.getDomainLocalMaximumROIs());
        }
        this.initializeLabelSequence();
        int seedLabel = 1;
        for (ROI roi : this.seedRois) {
            this.addSeedToLabelSequence(roi, seedLabel++);
        }
    }

    private List<? extends ROI> getDomainLocalMaximumROIs() throws IllegalArgumentException, ConvolutionException, InterruptedException {
        LocalMaxFiltering localMaxFiltering = LocalMaxFiltering.create(this.getSmoothedDomainDistanceMap(), 3);
        localMaxFiltering.computeFiltering();
        ArrayList<ROI2DPoint> localMaximaRois = new ArrayList<ROI2DPoint>();
        SequenceDataIterator localMaxIt = new SequenceDataIterator(localMaxFiltering.getFilteredSequence());
        while (!localMaxIt.done()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (localMaxIt.get() > 0.0) {
                localMaximaRois.add(new ROI2DPoint(new Point5D.Integer(localMaxIt.getPositionX(), localMaxIt.getPositionY(), localMaxIt.getPositionZ(), localMaxIt.getPositionT(), localMaxIt.getPositionC())));
            }
            localMaxIt.next();
        }
        return localMaximaRois;
    }

    private Sequence getSmoothedDomainDistanceMap() throws IllegalArgumentException, ConvolutionException, InterruptedException {
        GaussianFiltering smoothingFilter = GaussianFiltering.create(this.domainDistanceMap, new double[]{2.0, 2.0, 2.0});
        try {
            smoothingFilter.computeFiltering();
        }
        catch (ConvolutionException e) {
            System.err.println("z sigma 2 too large.. trying 1");
            try {
                smoothingFilter = GaussianFiltering.create(this.domainDistanceMap, new double[]{2.0, 2.0, 1.0});
                smoothingFilter.computeFiltering();
            }
            catch (ConvolutionException e1) {
                System.err.println("z sigma 1 too large.. using original distance map");
                return this.domainDistanceMap;
            }
        }
        return smoothingFilter.getFilteredSequence();
    }

    private void initializeLabelSequence() throws InterruptedException {
        this.labelSequence = new Sequence("labels");
        int l = 0;
        while ((double)l < this.imageSize.getSizeT()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            VolumetricImage volume = new VolumetricImage();
            int k = 0;
            while ((double)k < this.imageSize.getSizeZ()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                IcyBufferedImage plane = new IcyBufferedImage((int)this.imageSize.getSizeX(), (int)this.imageSize.getSizeY(), 1, DataType.INT);
                volume.setImage(k, plane);
                ++k;
            }
            this.labelSequence.addVolumetricImage(l, volume);
            ++l;
        }
    }

    private void addSeedToLabelSequence(ROI seedRoi, int label) {
        DataIteratorUtil.set(new SequenceDataIterator(this.labelSequence, seedRoi, true), label);
    }

    private void computeWatershedOnFrames() {
        this.labeledPixels = new HashMap<Integer, List<LabeledPixel>>(this.labelSequence.getSizeT());
        FloodingStructure.Builder floodingStructureBuilder = new FloodingStructure.Builder(this.domainDistanceMap, this.labelSequence);
        for (int frame = 0; frame < this.labelSequence.getSizeT(); ++frame) {
            floodingStructureBuilder.setFrame(frame);
            FloodingStructure frameFloodingStructure = floodingStructureBuilder.build();
            this.computeFrameFlooding(frameFloodingStructure, frame);
            this.updateLabelSequence(frame, frameFloodingStructure);
            this.labeledPixels.put(frame, frameFloodingStructure.getFloodingPixels());
        }
    }

    private void computeFrameFlooding(FloodingStructure frameFloodingStructure, int frame) {
        AtomicInteger labelGenerator = new AtomicInteger(this.seedRois.size());
        List heights = frameFloodingStructure.getHeights().stream().collect(Collectors.toList());
        Collections.reverse(heights);
        AtomicInteger heightPixelIndex = new AtomicInteger(0);
        AtomicInteger nextPixelIndex = new AtomicInteger(0);
        LinkedList<LabeledPixel> pendingPixels = new LinkedList<LabeledPixel>();
        Iterator iterator = heights.iterator();
        while (iterator.hasNext()) {
            double height = (Double)iterator.next();
            List<LabeledPixel> pixelsAtHeight = this.findPixelsAtHeight(frameFloodingStructure.getFloodingPixels(), height, heightPixelIndex);
            pendingPixels.addAll(pixelsAtHeight);
            this.extendBasins(pendingPixels);
            this.finishCurrentHeight(frame, frameFloodingStructure.getFloodingPixels(), height, nextPixelIndex, labelGenerator);
        }
    }

    private List<LabeledPixel> findPixelsAtHeight(List<LabeledPixel> floodingPixels, double height, AtomicInteger startingPixelIndex) {
        LinkedList<LabeledPixel> candidatePixelsAtHeight = new LinkedList<LabeledPixel>();
        block0: for (int pixelIndex = startingPixelIndex.get(); pixelIndex < floodingPixels.size(); ++pixelIndex) {
            LabeledPixel pixel = floodingPixels.get(pixelIndex);
            if (pixel.getHeight() < height) {
                startingPixelIndex.set(pixelIndex);
                break;
            }
            if (!pixel.isLabeled()) {
                pixel.setToBeLabeled();
            }
            for (LabeledPixel neighborPixel : pixel.getNeighbors()) {
                if (!neighborPixel.isLabeled()) continue;
                pixel.setLevel(1);
                candidatePixelsAtHeight.add(pixel);
                continue block0;
            }
        }
        return candidatePixelsAtHeight;
    }

    private void extendBasins(Queue<LabeledPixel> pendingPixels) {
        LabeledPixel flagPixel = new LabeledPixel(new Point3D(0, 0, 0), -1.0);
        pendingPixels.add(flagPixel);
        int currentLevel = 1;
        while (true) {
            LabeledPixel currentPixel;
            if ((currentPixel = pendingPixels.poll()) == flagPixel) {
                if (pendingPixels.isEmpty()) break;
                pendingPixels.add(flagPixel);
                ++currentLevel;
                currentPixel = pendingPixels.poll();
            }
            boolean shouldExtend = false;
            int neighborLabel = 0;
            boolean isBasinBorder = false;
            LabeledPixel bestNeighbor = null;
            double bestDistance = Double.NaN;
            for (LabeledPixel neighborPixel : currentPixel.getNeighbors()) {
                if (neighborPixel.getLevel() <= currentLevel && neighborPixel.isLabeled()) {
                    if (currentPixel.isToBeLabeled()) {
                        shouldExtend = true;
                    }
                    if (neighborLabel == 0) {
                        neighborLabel = neighborPixel.getLabel();
                    } else if (neighborLabel != neighborPixel.getLabel()) {
                        isBasinBorder = true;
                    }
                    double distance = neighborPixel.getHeight() - currentPixel.getHeight();
                    if (bestNeighbor == null) {
                        bestNeighbor = neighborPixel;
                        bestDistance = distance;
                        continue;
                    }
                    if (!(distance > bestDistance)) continue;
                    bestNeighbor = neighborPixel;
                    bestDistance = distance;
                    continue;
                }
                if (!neighborPixel.isToBeLabeled() || neighborPixel.getLevel() != 0) continue;
                neighborPixel.setLevel(currentLevel + 1);
                pendingPixels.add(neighborPixel);
            }
            if (!shouldExtend && !isBasinBorder) continue;
            currentPixel.setLabel(bestNeighbor.getLabel());
            if (this.newBasinsAllowed) continue;
            this.floodBasin(currentPixel, bestNeighbor.getLabel());
        }
    }

    private void finishCurrentHeight(int frame, List<LabeledPixel> floodingPixels, double height, AtomicInteger nextPixelIndex, AtomicInteger labelGenerator) {
        VolumetricImageCursor labelCursor = new VolumetricImageCursor(this.labelSequence, frame);
        for (int pixelIndex = nextPixelIndex.get(); pixelIndex < floodingPixels.size(); ++pixelIndex) {
            LabeledPixel pixel = floodingPixels.get(pixelIndex);
            if (pixel.getHeight() < height) {
                nextPixelIndex.set(pixelIndex);
                break;
            }
            pixel.setLevel(0);
            if (!pixel.isToBeLabeled()) continue;
            if (this.newBasinsAllowed) {
                this.floodBasin(pixel, labelGenerator.incrementAndGet());
                continue;
            }
            int pixelLabel = (int)labelCursor.get(pixel.getPosition().x, pixel.getPosition().y, pixel.getPosition().z, 0);
            if (pixelLabel <= 0) continue;
            this.floodBasin(pixel, pixelLabel);
        }
    }

    private void floodBasin(LabeledPixel startPixel, int label) {
        startPixel.setLabel(label);
        LinkedList<LabeledPixel> pendingBasinPixels = new LinkedList<LabeledPixel>();
        pendingBasinPixels.add(startPixel);
        while (!pendingBasinPixels.isEmpty()) {
            LabeledPixel currentPixel = (LabeledPixel)pendingBasinPixels.poll();
            for (LabeledPixel neighborPixel : currentPixel.getNeighbors()) {
                if (!neighborPixel.isToBeLabeled() && (!neighborPixel.isNoLabel() || !(neighborPixel.getHeight() >= currentPixel.getHeight()))) continue;
                neighborPixel.setLabel(label);
                neighborPixel.setLevel(startPixel.getLevel());
                pendingBasinPixels.add(neighborPixel);
            }
        }
    }

    private void updateLabelSequence(int frame, FloodingStructure frameFloodingStructure) {
        VolumetricImageCursor labelCursor = new VolumetricImageCursor(this.labelSequence, frame);
        for (LabeledPixel labeledPixel : frameFloodingStructure.getFloodingPixels()) {
            labelCursor.set(labeledPixel.getPosition().x, labeledPixel.getPosition().y, labeledPixel.getPosition().z, 0, labeledPixel.getLabel());
        }
        labelCursor.commitChanges();
    }

    public Sequence getLabelSequence() {
        return this.labelSequence;
    }

    public List<ROI> getSeeds() {
        return this.seedRois;
    }

    public List<ROI> getLabelRois() {
        if (this.labeledRois == null) {
            this.labeledRois = new ArrayList<ROI>();
            for (int frame = 0; frame < this.labelSequence.getSizeT(); ++frame) {
                this.labeledRois.addAll(this.getFrameLabelRois(frame));
            }
        }
        return this.labeledRois;
    }

    private List<ROI> getFrameLabelRois(int frame) {
        LinkedList<ROI> frameRois = new LinkedList<ROI>();
        if (this.labelSequence.getSizeZ() == 1) {
            HashMap<Integer, ROI2DArea> rois = new HashMap<Integer, ROI2DArea>();
            for (LabeledPixel pixel : this.labeledPixels.get(frame)) {
                ROI2DArea labelRoi = (ROI2DArea)rois.get(pixel.getLabel());
                if (labelRoi == null) {
                    labelRoi = new ROI2DArea();
                    labelRoi.setName("" + pixel.getLabel());
                    int r = Random.nextInt(256);
                    int g = Random.nextInt(256);
                    int b = (765 - r - g) % 256;
                    labelRoi.setColor(new Color(r, g, b));
                    rois.put(pixel.getLabel(), labelRoi);
                }
                labelRoi.addPoint(pixel.getPosition().x, pixel.getPosition().y);
            }
            frameRois.addAll(rois.values());
        } else {
            HashMap<Integer, ROI3DArea> rois = new HashMap<Integer, ROI3DArea>();
            for (LabeledPixel pixel : this.labeledPixels.get(frame)) {
                ROI3DArea labelRoi = (ROI3DArea)rois.get(pixel.getLabel());
                if (labelRoi == null) {
                    labelRoi = new ROI3DArea(new Point3D.Integer(pixel.getPosition().x, pixel.getPosition().y, pixel.getPosition().z));
                    labelRoi.setName("" + pixel.getLabel());
                    int r = Random.nextInt(256);
                    int g = Random.nextInt(256);
                    int b = (765 - r - g) % 256;
                    labelRoi.setColor(new Color(r, g, b));
                    rois.put(pixel.getLabel(), labelRoi);
                }
                labelRoi.addPoint(pixel.getPosition().x, pixel.getPosition().y, pixel.getPosition().z);
            }
            frameRois.addAll(rois.values());
        }
        return frameRois;
    }

    public static class Builder {
        private Dimension5D imageSize;
        private Dimension3D pixelSize;
        private List<ROI> rois;
        private List<ROI> seeds;
        private boolean newBasinsAllowed;

        public Builder(Dimension5D imageSize, Dimension3D pixelSize) {
            Objects.requireNonNull(imageSize);
            Objects.requireNonNull(pixelSize);
            this.imageSize = imageSize;
            this.pixelSize = pixelSize;
            this.rois = new ArrayList<ROI>();
            this.seeds = new ArrayList<ROI>();
            this.newBasinsAllowed = true;
        }

        public <T extends ROI> Builder addObject(T roi) {
            Objects.requireNonNull(roi);
            this.rois.add(roi);
            return this;
        }

        public <T extends ROI> Builder addObjects(Collection<T> rois) {
            Objects.requireNonNull(rois);
            this.rois.addAll(rois);
            return this;
        }

        public <T extends ROI> Builder addSeed(T roi) {
            Objects.requireNonNull(roi);
            this.seeds.add(roi);
            return this;
        }

        public <T extends ROI> Builder addSeeds(Collection<T> rois) {
            Objects.requireNonNull(rois);
            this.seeds.addAll(rois);
            return this;
        }

        public Builder setNewBasinsAllowed(boolean allow) {
            this.newBasinsAllowed = allow;
            return this;
        }

        public ROIWatershedCalculator build() {
            ROIWatershedCalculator calculator = new ROIWatershedCalculator();
            calculator.setImageSize(this.imageSize);
            calculator.setPixelSize(this.pixelSize);
            calculator.setDomainRois(this.rois);
            calculator.setSeedRois(this.seeds);
            calculator.setNewBasinsAllowed(this.newBasinsAllowed);
            return calculator;
        }
    }
}

