/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;

public class CrawlableDatasetFile
implements CrawlableDataset {
    private static Logger log = LoggerFactory.getLogger(CrawlableDatasetFile.class);
    private final File file;
    private final Object configObj;

    public CrawlableDatasetFile(String path, Object configObj) {
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        this.file = new File(path);
        if (configObj != null) {
            log.warn("CrawlableDatasetFile(): config object not null, it will be ignored <" + configObj.toString() + ">.");
            this.configObj = configObj;
        } else {
            this.configObj = null;
        }
    }

    private CrawlableDatasetFile(CrawlableDatasetFile parent, String childPath) {
        this.file = new File(parent.getFile(), childPath);
        this.configObj = null;
    }

    public CrawlableDatasetFile(File file2) {
        this.file = file2;
        this.configObj = null;
    }

    private String normalizePath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Object getConfigObject() {
        return this.configObj;
    }

    @Override
    public String getPath() {
        return this.normalizePath(this.file.getPath());
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean exists() {
        return this.file.exists() && this.file.canRead();
    }

    @Override
    public boolean isCollection() {
        return this.file.isDirectory();
    }

    @Override
    public CrawlableDataset getDescendant(String relativePath) {
        if (relativePath.startsWith("/")) {
            throw new IllegalArgumentException("Path must be relative <" + relativePath + ">.");
        }
        return new CrawlableDatasetFile(this, relativePath);
    }

    @Override
    public List<CrawlableDataset> listDatasets() throws IOException {
        if (!this.exists()) {
            String tmpMsg = "This dataset <" + this.getPath() + "> does not exist.";
            log.error("listDatasets(): " + tmpMsg);
            throw new IllegalStateException(tmpMsg);
        }
        if (!this.isCollection()) {
            String tmpMsg = "This dataset <" + this.getPath() + "> is not a collection dataset.";
            log.error("listDatasets(): " + tmpMsg);
            throw new IllegalStateException(tmpMsg);
        }
        ArrayList<CrawlableDataset> list = new ArrayList<CrawlableDataset>();
        File[] files = this.file.listFiles();
        if (files == null) {
            log.error("listDatasets(): the underlying file [" + this.file.getPath() + "] exists, is a directory, and canRead()==true but listFiles() returns null. This may be a problem Java has on Windows XP (Java 7 should fix).");
            return Collections.emptyList();
        }
        for (File allFile : files) {
            CrawlableDatasetFile crDs = new CrawlableDatasetFile(this, allFile.getName());
            if (!crDs.exists()) continue;
            list.add(crDs);
        }
        return list;
    }

    @Override
    public List<CrawlableDataset> listDatasets(CrawlableDatasetFilter filter) throws IOException {
        List<CrawlableDataset> list = this.listDatasets();
        if (filter == null) {
            return list;
        }
        ArrayList<CrawlableDataset> retList = new ArrayList<CrawlableDataset>();
        for (CrawlableDataset curDs : list) {
            if (!filter.accept(curDs)) continue;
            retList.add(curDs);
        }
        return retList;
    }

    @Override
    public CrawlableDataset getParentDataset() {
        File parentFile = this.file.getParentFile();
        if (parentFile == null) {
            return null;
        }
        return new CrawlableDatasetFile(parentFile);
    }

    @Override
    public long length() {
        if (this.isCollection()) {
            return 0L;
        }
        return this.file.length();
    }

    @Override
    public Date lastModified() {
        long lastModDate = this.file.lastModified();
        if (lastModDate == 0L) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTimeInMillis(lastModDate);
        return cal.getTime();
    }

    public String toString() {
        return this.getPath();
    }
}

