/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPIterator;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.impl.XMPMetaImpl;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.xmp.XmpDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class XmpDirectory
extends Directory {
    public static final int TAG_XMP_VALUE_COUNT = 65535;
    @NotNull
    protected static final HashMap<Integer, String> _tagNameMap = new HashMap();
    @Nullable
    private XMPMeta _xmpMeta;

    public XmpDirectory() {
        this.setDescriptor(new XmpDescriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "XMP";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    @NotNull
    public Map<String, String> getXmpProperties() {
        HashMap<String, String> propertyValueByPath = new HashMap<String, String>();
        if (this._xmpMeta != null) {
            try {
                XMPIterator i = this._xmpMeta.iterator();
                while (i.hasNext()) {
                    XMPPropertyInfo prop = (XMPPropertyInfo)i.next();
                    String path = prop.getPath();
                    String value = prop.getValue();
                    if (path == null || value == null) continue;
                    propertyValueByPath.put(path, value);
                }
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return Collections.unmodifiableMap(propertyValueByPath);
    }

    public void setXMPMeta(@NotNull XMPMeta xmpMeta) {
        this._xmpMeta = xmpMeta;
        try {
            int valueCount = 0;
            XMPIterator i = this._xmpMeta.iterator();
            while (i.hasNext()) {
                XMPPropertyInfo prop = (XMPPropertyInfo)i.next();
                if (prop.getPath() == null) continue;
                ++valueCount;
            }
            this.setInt(65535, valueCount);
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
    }

    @NotNull
    public XMPMeta getXMPMeta() {
        if (this._xmpMeta == null) {
            this._xmpMeta = new XMPMetaImpl();
        }
        return this._xmpMeta;
    }

    static {
        _tagNameMap.put(65535, "XMP Value Count");
    }
}

