/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;

public final class DebugTools {
    static final String[][] TOOL_CLASSES = new String[][]{{"loci.common.", "LogbackTools"}, {"loci.common.", "Log4jTools"}};

    private DebugTools() {
    }

    public static String getStackTrace(Throwable t) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream((OutputStream)out, false, "UTF-8"));
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static synchronized boolean isEnabled() {
        for (String[] toolClass : TOOL_CLASSES) {
            try {
                Class<?> k = Class.forName(toolClass[0] + toolClass[1]);
                Method m3 = k.getMethod("isEnabled", new Class[0]);
                return (Boolean)m3.invoke(null, new Object[0]);
            }
            catch (LinkageError | ReflectiveOperationException throwable) {
            }
        }
        return false;
    }

    public static synchronized void setRootLevel(String level) {
        for (String[] toolClass : TOOL_CLASSES) {
            try {
                Class<?> k = Class.forName(toolClass[0] + toolClass[1]);
                Method m3 = k.getMethod("setRootLevel", String.class);
                m3.invoke(null, level);
                return;
            }
            catch (LinkageError | ReflectiveOperationException throwable) {
            }
        }
    }

    public static synchronized boolean enableLogging() {
        if (DebugTools.isEnabled()) {
            return false;
        }
        for (String[] toolClass : TOOL_CLASSES) {
            try {
                Class<?> k = Class.forName(toolClass[0] + toolClass[1]);
                Method m3 = k.getMethod("enableLogging", new Class[0]);
                m3.invoke(null, new Object[0]);
                return true;
            }
            catch (LinkageError | ReflectiveOperationException throwable) {
            }
        }
        return false;
    }

    public static synchronized boolean enableLogging(String level) {
        boolean status = DebugTools.enableLogging();
        if (status) {
            DebugTools.setRootLevel(level);
        }
        return status;
    }

    public static synchronized boolean enableIJLogging(boolean debug) {
        ReflectedUniverse r = new ReflectedUniverse();
        try {
            r.exec("import loci.common.LogbackTools");
            r.exec("import loci.plugins.util.IJStatusEchoer");
            r.exec("appender = new IJStatusEchoer()");
            r.setVar("debug", debug);
            r.exec("LogbackTools.enableIJLogging(debug, appender)");
        }
        catch (ReflectException exc) {
            return false;
        }
        return true;
    }

    public static String getFieldName(Class<?> c, int value) {
        Field[] fields = c.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Modifier.isStatic(fields[i].getModifiers())) continue;
            fields[i].setAccessible(true);
            try {
                if (fields[i].getInt(null) != value) continue;
                return fields[i].getName();
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return "" + value;
    }
}

