/*
 * Decompiled with CFR 0.152.
 */
package icy.painter;

import icy.painter.Anchor2D;
import icy.sequence.Sequence;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.geom.Point2D;
import org.w3c.dom.Node;

public class PathAnchor2D
extends Anchor2D {
    private static final String ID_POS_CEXT_X = "pos_ext1_x";
    private static final String ID_POS_CEXT_Y = "pos_ext1_y";
    private static final String ID_POS_QEXT_X = "pos_ext2_x";
    private static final String ID_POS_QEXT_Y = "pos_ext2_y";
    private static final String ID_TYPE = "type";
    private final Point2D.Double posCExt;
    private final Point2D.Double posQExt;
    private int type;

    public PathAnchor2D(double x1, double y1, double x2, double y2, double x3, double y3, int ray, Color color, Color selectedColor, int type) {
        super(x3, y3, ray, color, selectedColor);
        this.posCExt = new Point2D.Double(x1, y1);
        this.posQExt = new Point2D.Double(x2, y2);
        this.type = type;
    }

    public PathAnchor2D(double x1, double y1, double x2, double y2, double x3, double y3, int ray, Color color, Color selectedColor) {
        this(x1, y1, x2, y2, x3, y3, ray, color, selectedColor, -1);
    }

    @Deprecated
    public PathAnchor2D(Sequence sequence, double x1, double y1, double x2, double y2, double x3, double y3, int ray, Color color, Color selectedColor) {
        this(x1, y1, x2, y2, x3, y3, ray, color, selectedColor, -1);
        if (sequence != null) {
            sequence.addOverlay(this);
        }
    }

    public PathAnchor2D(double x1, double y1, double x2, double y2, double x3, double y3, Color color, Color selectedColor) {
        this(x1, y1, x2, y2, x3, y3, 6, color, selectedColor, 3);
    }

    public PathAnchor2D(double x1, double y1, double x2, double y2, double x3, double y3) {
        this(x1, y1, x2, y2, x3, y3, 6, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR, 3);
    }

    public PathAnchor2D(double x1, double y1, double x2, double y2, Color color, Color selectedColor) {
        this(0.0, 0.0, x1, y1, x2, y2, 6, color, selectedColor, 2);
    }

    public PathAnchor2D(double x1, double y1, double x2, double y2) {
        this(0.0, 0.0, x1, y1, x2, y2, 6, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR, 2);
    }

    public PathAnchor2D(double x1, double y1, Color color, Color selectedColor, int type) {
        this(0.0, 0.0, 0.0, 0.0, x1, y1, 6, color, selectedColor, type);
    }

    public PathAnchor2D(double x1, double y1, Color color, Color selectedColor) {
        this(0.0, 0.0, 0.0, 0.0, x1, y1, 6, color, selectedColor, 1);
    }

    @Deprecated
    public PathAnchor2D(double x1, double y1, int ray, Color color, Color selectedColor) {
        this(0.0, 0.0, 0.0, 0.0, x1, y1, ray, color, selectedColor, 0);
    }

    public PathAnchor2D(double x1, double y1, int type) {
        this(0.0, 0.0, 0.0, 0.0, x1, y1, 6, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR, type);
    }

    public PathAnchor2D(double x1, double y1) {
        this(0.0, 0.0, 0.0, 0.0, x1, y1, 6, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR, 0);
    }

    public PathAnchor2D() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR, 0);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int value) {
        if (this.type != value) {
            this.type = value;
            this.painterChanged();
        }
    }

    @Override
    public boolean isVisible() {
        switch (this.getType()) {
            case 4: {
                return false;
            }
        }
        return super.isVisible();
    }

    public Point2D.Double getPosQExt() {
        return this.posQExt;
    }

    public Point2D.Double getPosCExt() {
        return this.posCExt;
    }

    public void setPosQExt(Point2D p) {
        this.setPosQExt(p.getX(), p.getY());
    }

    public void setPosQExt(double x, double y) {
        if (this.posQExt.x != x || this.posQExt.y != y) {
            this.posQExt.x = x;
            this.posQExt.y = y;
            this.positionChanged();
            this.painterChanged();
        }
    }

    public void setPosCExt(Point2D p) {
        this.setPosCExt(p.getX(), p.getY());
    }

    public void setPosCExt(double x, double y) {
        if (this.posCExt.x != x || this.posCExt.y != y) {
            this.posCExt.x = x;
            this.posCExt.y = y;
            this.positionChanged();
            this.painterChanged();
        }
    }

    public double getPosQExtX() {
        return this.posQExt.x;
    }

    public void setPosQExtX(double x) {
        this.setPosQExt(x, this.posQExt.y);
    }

    public double getPosQExtY() {
        return this.posQExt.y;
    }

    public void setPosQExtY(double y) {
        this.setPosQExt(this.posQExt.x, y);
    }

    public double getPosCExtX() {
        return this.posCExt.x;
    }

    public void setPosCExtX(double x) {
        this.setPosCExt(x, this.posCExt.y);
    }

    public double getPosCExtY() {
        return this.posCExt.y;
    }

    public void setPosCExtY(double y) {
        this.setPosCExt(this.posCExt.x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translate(double dx, double dy) {
        this.beginUpdate();
        try {
            super.translate(dx, dy);
            this.setPosCExt(this.posCExt.x + dx, this.posCExt.y + dy);
            this.setPosQExt(this.posQExt.x + dx, this.posQExt.y + dy);
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean loadPositionFromXML(Node node) {
        if (node == null) {
            return false;
        }
        this.beginUpdate();
        try {
            super.loadPositionFromXML(node);
            this.setPosCExtX(XMLUtil.getElementDoubleValue(node, ID_POS_CEXT_X, 0.0));
            this.setPosCExtY(XMLUtil.getElementDoubleValue(node, ID_POS_CEXT_Y, 0.0));
            this.setPosQExtX(XMLUtil.getElementDoubleValue(node, ID_POS_QEXT_X, 0.0));
            this.setPosQExtY(XMLUtil.getElementDoubleValue(node, ID_POS_QEXT_Y, 0.0));
            this.setType(XMLUtil.getElementIntValue(node, ID_TYPE, -1));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        this.beginUpdate();
        try {
            super.loadFromXML(node);
            this.setPosCExtX(XMLUtil.getElementDoubleValue(node, ID_POS_CEXT_X, 0.0));
            this.setPosCExtY(XMLUtil.getElementDoubleValue(node, ID_POS_CEXT_Y, 0.0));
            this.setPosQExtX(XMLUtil.getElementDoubleValue(node, ID_POS_QEXT_X, 0.0));
            this.setPosQExtY(XMLUtil.getElementDoubleValue(node, ID_POS_QEXT_Y, 0.0));
            this.setType(XMLUtil.getElementIntValue(node, ID_TYPE, -1));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean savePositionToXML(Node node) {
        if (node == null) {
            return false;
        }
        super.savePositionToXML(node);
        XMLUtil.setElementDoubleValue(node, ID_POS_CEXT_X, this.getPosCExtX());
        XMLUtil.setElementDoubleValue(node, ID_POS_CEXT_Y, this.getPosCExtY());
        XMLUtil.setElementDoubleValue(node, ID_POS_QEXT_X, this.getPosQExtX());
        XMLUtil.setElementDoubleValue(node, ID_POS_QEXT_Y, this.getPosQExtY());
        XMLUtil.setElementIntValue(node, ID_TYPE, this.getType());
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        super.saveToXML(node);
        XMLUtil.setElementDoubleValue(node, ID_POS_CEXT_X, this.getPosCExtX());
        XMLUtil.setElementDoubleValue(node, ID_POS_CEXT_Y, this.getPosCExtY());
        XMLUtil.setElementDoubleValue(node, ID_POS_QEXT_X, this.getPosQExtX());
        XMLUtil.setElementDoubleValue(node, ID_POS_QEXT_Y, this.getPosQExtY());
        XMLUtil.setElementIntValue(node, ID_TYPE, this.getType());
        return true;
    }
}

