package plugins.spop.rotation3D;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import icy.util.OMEUtil;

import java.awt.image.renderable.ParameterBlock;

import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;

public class SequenceRotation3D
{
    
    Sequence in;
    Sequence out;
    int angleXY, angleXZ, angleYZ;
    boolean crop;
    float centerX, centerY, centerZ;
    int dimX, dimY, dimZ, dimT, dimC;
    
    public SequenceRotation3D(Sequence seq_in, int angleXY, int angleXZ, int angleYZ, boolean crop)
    {
        this.in = seq_in;
        this.out = seq_in;
        
        this.angleXY = angleXY;
        this.angleXZ = angleXZ;
        this.angleYZ = angleYZ;
        
        this.crop = crop;
        this.centerX = seq_in.getSizeX() / 2f;
        this.centerY = seq_in.getSizeY() / 2f;
        this.centerZ = seq_in.getSizeZ() / 2f;
        this.dimX = seq_in.getSizeX();
        this.dimY = seq_in.getSizeY();
        this.dimZ = seq_in.getSizeZ();
        this.dimT = seq_in.getSizeT();
        this.dimC = seq_in.getSizeC();
        
        if (angleXY != 0) out = execute(in, angleXY);
        if (angleXZ != 0) out = StackRotation.FrontToTop(execute(StackRotation.FrontToTop(out), angleXZ));
        if (angleYZ != 0) out = StackRotation.FrontToRight(execute(StackRotation.FrontToRight(out), angleYZ));
        
        if (crop) crop();
        System.gc();
        
    }
    
    private static Sequence execute(Sequence seq_in, int angle)
    {
        Sequence out_execute = new Sequence(OMEUtil.createOMEXMLMetadata(seq_in.getOMEXMLMetadata()));
        Interpolation inter = new InterpolationBilinear();
        float cenX, cenY;
        
        cenX = seq_in.getSizeX() / 2f;
        cenY = seq_in.getSizeY() / 2f;
        
        IcyBufferedImage img;
        PlanarImage imgOut;
        for (int t = 0; t < seq_in.getSizeT(); t++)
            for (int z = 0; z < seq_in.getSizeZ(); z++)
            {
                ParameterBlock pb = new ParameterBlock();
                img = seq_in.getImage(t, z);
                pb.addSource(img);
                pb.add(cenX);
                pb.add(cenY);
                pb.add((float) Math.toRadians(angle));
                pb.add(inter);
                
                imgOut = JAI.create("rotate", pb);
                img = IcyBufferedImage.createFrom(imgOut.getAsBufferedImage());
                out_execute.setImage(t, z, img);
            }
        System.gc();
        return out_execute;
        
    }
    
    private void crop()
    {
        //dimensions after rotation
        int dim_x_out = out.getSizeX();
        int dim_y_out = out.getSizeY();
        int dim_z_out = out.getSizeZ();
        //dimensions for an extended stack
        int dim_x_extend = dimX, dim_y_extend = dimY, dim_z_extend = dimZ;
        
        if (dimX < dim_x_out) dim_x_extend = dim_x_out;
        
        if (dimY < dim_y_out) dim_y_extend = dim_y_out;
        
        if (dimZ < dim_z_out) dim_z_extend = dim_z_out;
        
        float extend_centerX = dim_x_extend / 2f;
        float extend_centerY = dim_y_extend / 2f;
        float extend_centerZ = dim_z_extend / 2f;
        
        int dif_x = (int) (extend_centerX - dim_x_out / 2f);
        int dif_y = (int) (extend_centerY - dim_y_out / 2f);
        int dif_z = (int) (extend_centerZ - dim_z_out / 2f);
        
        double tab[][] = new double[dimC][dim_x_out * dim_y_out];
        double tab_extend[][] = new double[dimC][dim_x_extend * dim_y_extend];
        Sequence seq_extend = new Sequence();
        //write the extended stack
        //fill with the out sequence
        //fill the rest with 0 values
        for (int t = 0; t < dimT; t++)
            for (int z = 0; z < dim_z_extend; z++)
            {
                IcyBufferedImage Icy = new IcyBufferedImage(dim_x_extend, dim_y_extend, dimC, out.getDataType());
                for (int c = 0; c < dimC; c++)
                {
                    
                    for (int xy_extend = 0; xy_extend < dim_x_extend * dim_y_extend; xy_extend++)
                        tab_extend[c][xy_extend] = 0;
                    if (z - dif_z >= 0)
                    {
                        tab[c] = Array1DUtil.arrayToDoubleArray(out.getDataXY(t, z - dif_z, c), false);
                        for (int y = 0; y < dim_y_out; y++)
                            for (int x = 0; x < dim_x_out; x++)
                            {
                                tab_extend[c][(y + dif_y) * dim_x_extend + (x + dif_x)] = tab[c][y * dim_x_out + x];
                            }
                    }
                    
                    Array1DUtil.doubleArrayToSafeArray(tab_extend[c], Icy.getDataXY(c), Icy.isSignedDataType());
                    
                }
                seq_extend.setImage(t, z, Icy);
            }
        
        //crop the extended stack in order to fit the IN dimensions
        
        dif_x = (int) (extend_centerX - centerX);
        dif_y = (int) (extend_centerY - centerY);
        dif_z = (int) (extend_centerZ - centerZ);
        
        //write the OUT sequence; it hqs the same dimensions like IN sequence
        out = seq_extend.getSubSequence(dif_x, dif_y, dif_z, 0, dimX, dimY, dimZ, dimT);
        
        System.gc();
        
    }
    
    public Sequence getRotatedSequence()
    {
        return out;
    }
    
}