/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.renderer;

import icy.gui.component.renderer.CustomComboBoxRenderer;
import icy.gui.lut.ColormapIcon;
import icy.image.colormap.IcyColorMap;
import icy.util.ReflectionUtil;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;

public class ColormapComboBoxRenderer
extends CustomComboBoxRenderer {
    private static final long serialVersionUID = 8439070623266035911L;

    @Deprecated
    public ColormapComboBoxRenderer(JComboBox combo, int w, int h) {
        this(combo);
    }

    public ColormapComboBoxRenderer(JComboBox combo) {
        super(combo);
    }

    @Override
    protected void updateItem(JList list, Object value) {
        if (value instanceof IcyColorMap) {
            int btnWidth;
            IcyColorMap colormap = (IcyColorMap)value;
            JComboBox comboBox = this.getComboBox();
            Dimension dim = comboBox.getSize();
            try {
                JButton popBtn = (JButton)ReflectionUtil.getFieldObject(comboBox.getUI(), "arrowButton", true);
                btnWidth = popBtn.getWidth();
                if (btnWidth <= 0) {
                    btnWidth = popBtn.getPreferredSize().width;
                }
                if (btnWidth <= 0) {
                    btnWidth = 20;
                }
            }
            catch (Exception e) {
                btnWidth = 20;
            }
            Insets insets = this.getInsets();
            dim.width -= btnWidth + insets.left + insets.right;
            dim.height -= insets.top + insets.bottom + 2;
            this.setIcon(new ColormapIcon(colormap, dim.width, dim.height));
            this.setText("");
            this.setToolTipText("Set " + colormap.getName() + " colormap");
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
        } else {
            super.updateItem(list, value);
        }
    }
}

