/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.io.FileInfo;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

class FitsDecoder {
    private String directory;
    private String fileName;
    private DataInputStream f;
    private StringBuffer info = new StringBuffer(512);
    double bscale;
    double bzero;

    public FitsDecoder(String directory, String fileName) {
        this.directory = directory;
        this.fileName = fileName;
    }

    FileInfo getInfo() throws IOException {
        int count;
        FileInfo fi;
        block21: {
            fi = new FileInfo();
            fi.fileFormat = 4;
            fi.fileName = this.fileName;
            fi.directory = this.directory;
            fi.width = 0;
            fi.height = 0;
            fi.offset = 0;
            InputStream is = new FileInputStream(this.directory + this.fileName);
            if (this.fileName.toLowerCase().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            this.f = new DataInputStream(is);
            String line = this.getString(80);
            this.info.append(line + "\n");
            if (!line.startsWith("SIMPLE")) {
                this.f.close();
                return null;
            }
            count = 1;
            do {
                String value;
                String key;
                ++count;
                line = this.getString(80);
                this.info.append(line + "\n");
                int index = line.indexOf("=");
                int commentIndex = line.indexOf("/", index);
                if (commentIndex < 0) {
                    commentIndex = line.length();
                }
                if (index >= 0) {
                    key = line.substring(0, index).trim();
                    value = line.substring(index + 1, commentIndex).trim();
                } else {
                    key = line.trim();
                    value = "";
                }
                if (key.equals("END")) break block21;
                if (key.equals("BITPIX")) {
                    int bitsPerPixel = Integer.parseInt(value);
                    if (bitsPerPixel == 8) {
                        fi.fileType = 0;
                        continue;
                    }
                    if (bitsPerPixel == 16) {
                        fi.fileType = 1;
                        continue;
                    }
                    if (bitsPerPixel == 32) {
                        fi.fileType = 3;
                        continue;
                    }
                    if (bitsPerPixel == -32) {
                        fi.fileType = 4;
                        continue;
                    }
                    if (bitsPerPixel == -64) {
                        fi.fileType = 16;
                        continue;
                    }
                    IJ.error("BITPIX must be 8, 16, 32, -32 (float) or -64 (double).");
                    this.f.close();
                    return null;
                }
                if (key.equals("NAXIS1")) {
                    fi.width = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("NAXIS2")) {
                    fi.height = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("NAXIS3")) {
                    fi.nImages = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("BSCALE")) {
                    this.bscale = this.parseDouble(value);
                    continue;
                }
                if (key.equals("BZERO")) {
                    this.bzero = this.parseDouble(value);
                    continue;
                }
                if (key.equals("CDELT1")) {
                    fi.pixelWidth = this.parseDouble(value);
                    continue;
                }
                if (key.equals("CDELT2")) {
                    fi.pixelHeight = this.parseDouble(value);
                    continue;
                }
                if (key.equals("CDELT3")) {
                    fi.pixelDepth = this.parseDouble(value);
                    continue;
                }
                if (!key.equals("CTYPE1")) continue;
                fi.unit = value;
            } while (count <= 360 || fi.width != 0);
            this.f.close();
            return null;
        }
        if (fi.pixelWidth == 1.0 && fi.pixelDepth == 1.0) {
            fi.unit = "pixel";
        }
        this.f.close();
        fi.offset = 2880 + 2880 * ((count * 80 - 1) / 2880);
        return fi;
    }

    String getString(int length) throws IOException {
        byte[] b = new byte[length];
        this.f.readFully(b);
        if (IJ.debugMode) {
            IJ.log(new String(b));
        }
        return new String(b);
    }

    int getInteger(String s) {
        s = s.substring(10, 30);
        s = s.trim();
        return Integer.parseInt(s);
    }

    double parseDouble(String s) throws NumberFormatException {
        Double d = new Double(s);
        return d;
    }

    String getHeaderInfo() {
        return new String(this.info);
    }
}

