/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.display;

import icy.canvas.Canvas2D;
import icy.canvas.IcyCanvas;
import icy.gui.util.GuiUtil;
import icy.painter.Painter;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.kernel.canvas.VtkCanvas;
import vtk.vtkActor;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkRenderer;
import vtk.vtkSphereSource;

public class BasicDetectionPainter
implements Painter {
    boolean projectDetection = false;
    boolean displayDetectionMark = true;
    boolean displayDetectionIndex = false;
    int fontLabelSize = 14;
    Color color = Color.red;
    HashMap<ROI, ArrayList<DetectionSpot>> detectionsHashMap;
    boolean displayROINumber = false;
    boolean displayDetectionNumberOverROI = false;
    final int FONT_SIZE = 16;
    private boolean initialized3D;

    public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        if (canvas instanceof Canvas2D) {
            int currentT = canvas.getT();
            int currentZ = canvas.getZ();
            if (this.displayDetectionMark) {
                g.setFont(new Font("Arial", 1, this.fontLabelSize));
                g.setColor(this.color);
                Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, 0.0, 0.0);
                for (ROI roi : this.detectionsHashMap.keySet()) {
                    ArrayList<DetectionSpot> detectionArrayList = this.detectionsHashMap.get(roi);
                    for (DetectionSpot detectionSpot : detectionArrayList) {
                        if (currentT != detectionSpot.getT() || !this.projectDetection && currentZ != (int)detectionSpot.getMassCenter().z) continue;
                        double x = detectionSpot.getMassCenter().x;
                        double y = detectionSpot.getMassCenter().y;
                        ((RectangularShape)ellipse).setFrame(x - 3.0, y - 3.0, 7.0, 7.0);
                        g.draw(ellipse);
                        if (!this.displayDetectionIndex) continue;
                        g.drawString("" + detectionArrayList.indexOf(detectionSpot), (int)x, (int)y);
                    }
                }
            }
            for (ROI roi : sequence.getROIs()) {
                ArrayList<DetectionSpot> detectionArrayList;
                if (roi.getName().startsWith("spot")) continue;
                ArrayList<DisplayTxt> displayTxtList = new ArrayList<DisplayTxt>();
                int fontSize = (int)ROI2D.canvasToImageLogDeltaX((IcyCanvas)canvas, (int)16);
                if (fontSize < 1) {
                    fontSize = 1;
                }
                Font font = new Font("Arial", 1, fontSize);
                g.setFont(font);
                Rectangle2D oneLetterBound = GuiUtil.getStringBounds((Graphics)g, (Font)font, (String)"X");
                float offsetY = 0.0f;
                g.setColor(roi.getColor());
                if (this.displayROINumber) {
                    String label = " ROI " + roi.getName() + " ";
                    Rectangle2D labelBounds = GuiUtil.getStringBounds((Graphics)g, (Font)font, (String)label);
                    displayTxtList.add(new DisplayTxt(label, new Rectangle2D.Double((float)(roi.getBounds5D().getCenterX() - labelBounds.getWidth() / 2.0), (float)(roi.getBounds5D().getCenterY() + labelBounds.getHeight()), labelBounds.getWidth(), labelBounds.getHeight())));
                    offsetY = (float)((double)offsetY + oneLetterBound.getHeight());
                }
                if (this.displayDetectionNumberOverROI && (detectionArrayList = this.detectionsHashMap.get(roi)) != null) {
                    int nbDetection = detectionArrayList.size();
                    String detectionLabel = " nb detection: " + nbDetection + " ";
                    Rectangle2D detectionLabelBounds = GuiUtil.getStringBounds((Graphics)g, (Font)font, (String)detectionLabel);
                    displayTxtList.add(new DisplayTxt(detectionLabel, new Rectangle2D.Double((float)(roi.getBounds5D().getCenterX() - detectionLabelBounds.getWidth() / 2.0), roi.getBounds5D().getCenterY() + (double)offsetY + detectionLabelBounds.getHeight(), detectionLabelBounds.getWidth(), detectionLabelBounds.getHeight())));
                    offsetY = (float)((double)offsetY + oneLetterBound.getHeight());
                }
                if (roi.getColor().getRed() != 0 || roi.getColor().getGreen() != 0 || roi.getColor().getBlue() == 0) {
                    // empty if block
                }
                Rectangle2D blackBox = null;
                for (DisplayTxt dt : displayTxtList) {
                    if (blackBox == null) {
                        blackBox = new Rectangle2D.Double(dt.bounds.getX(), dt.bounds.getY(), dt.bounds.getWidth(), dt.bounds.getHeight());
                        continue;
                    }
                    blackBox = blackBox.createUnion(dt.bounds);
                }
                if (blackBox != null) {
                    g.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    Color oldColor = g.getColor();
                    float intensity = (float)roi.getColor().getRed() / 255.0f + (float)roi.getColor().getGreen() / 255.0f + (float)roi.getColor().getBlue() / 255.0f;
                    intensity /= 3.0f;
                    intensity = 1.0f - intensity;
                    g.setColor(new Color(intensity, intensity, intensity));
                    g.translate(0.0, -oneLetterBound.getHeight() * 0.8);
                    g.fill(blackBox);
                    g.translate(0.0, oneLetterBound.getHeight() * 0.8);
                    g.setComposite(AlphaComposite.getInstance(3, 1.0f));
                    g.setColor(oldColor);
                }
                g.setColor(roi.getColor());
                for (DisplayTxt dt : displayTxtList) {
                    g.drawString(dt.string, (float)dt.bounds.getX(), (float)dt.bounds.getY());
                }
            }
        }
        if (canvas instanceof VtkCanvas) {
            VtkCanvas canvas3d = (VtkCanvas)canvas;
            if (!this.initialized3D) {
                this.init3D(canvas3d.getRenderer());
                this.initialized3D = true;
            }
        }
    }

    private void init3D(vtkRenderer renderer) {
        for (ROI roi : this.detectionsHashMap.keySet()) {
            ArrayList<DetectionSpot> detectionArrayList = this.detectionsHashMap.get(roi);
            for (DetectionSpot detectionSpot : detectionArrayList) {
                double x = detectionSpot.getMassCenter().x;
                double y = detectionSpot.getMassCenter().y;
                double z = detectionSpot.getMassCenter().z;
                double[] center = new double[]{x, y, z};
                vtkSphereSource sphere = new vtkSphereSource();
                sphere.SetCenter(center);
                sphere.SetRadius(1.0);
                sphere.SetThetaResolution(5);
                sphere.SetPhiResolution(5);
                vtkPolyDataMapper map = new vtkPolyDataMapper();
                map.SetInputData(sphere.GetOutput());
                vtkActor aSphere = new vtkActor();
                aSphere.SetMapper((vtkMapper)map);
                aSphere.GetProperty().SetColor(0.0, 1.0, 0.0);
                renderer.AddActor((vtkProp)aSphere);
            }
        }
    }

    class DisplayTxt {
        String string;
        Rectangle2D bounds;

        public DisplayTxt(String string, Rectangle2D bounds) {
            this.string = string;
            this.bounds = bounds;
        }
    }
}

