/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class vtkReferenceInformation {
    private int numberOfObjectsToFree;
    private int numberOfObjectsStillReferenced;
    private HashMap<String, AtomicInteger> classesKept;
    private HashMap<String, AtomicInteger> classesRemoved;
    private boolean keepTrackOfClassNames;

    public vtkReferenceInformation(int n, int n2, int n3) {
        this.numberOfObjectsToFree = n;
        this.numberOfObjectsStillReferenced = n2;
        this.keepTrackOfClassNames = false;
    }

    public vtkReferenceInformation(boolean bl) {
        this.numberOfObjectsToFree = 0;
        this.numberOfObjectsStillReferenced = 0;
        this.keepTrackOfClassNames = bl;
    }

    public int getTotalNumberOfObjects() {
        return this.numberOfObjectsStillReferenced + this.numberOfObjectsToFree;
    }

    public int getNumberOfObjectsToFree() {
        return this.numberOfObjectsToFree;
    }

    public int getTotalNumberOfObjectsStillReferenced() {
        return this.numberOfObjectsStillReferenced;
    }

    public void setNumberOfObjectsStillReferenced(int n) {
        this.numberOfObjectsStillReferenced = n;
    }

    public void setNumberOfObjectsToFree(int n) {
        this.numberOfObjectsToFree = n;
    }

    public void addFreeObject(String string) {
        ++this.numberOfObjectsToFree;
        if (this.keepTrackOfClassNames) {
            AtomicInteger atomicInteger;
            if (this.classesRemoved == null && string != null) {
                this.classesRemoved = new HashMap();
            }
            if ((atomicInteger = this.classesRemoved.get(string)) == null) {
                this.classesRemoved.put(string, new AtomicInteger(1));
            } else {
                atomicInteger.incrementAndGet();
            }
        }
    }

    public void addKeptObject(String string) {
        ++this.numberOfObjectsStillReferenced;
        if (this.keepTrackOfClassNames && string != null) {
            AtomicInteger atomicInteger;
            if (this.classesKept == null) {
                this.classesKept = new HashMap();
            }
            if ((atomicInteger = this.classesKept.get(string)) == null) {
                this.classesKept.put(string, new AtomicInteger(1));
            } else {
                atomicInteger.incrementAndGet();
            }
        }
    }

    public String listKeptReferenceToString() {
        if (this.classesKept == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("List of classes kept in Java layer:\n");
        for (Map.Entry<String, AtomicInteger> entry : this.classesKept.entrySet()) {
            stringBuilder.append(" - ").append(entry.getKey()).append(": ").append(entry.getValue().toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    public String listRemovedReferenceToString() {
        if (this.classesRemoved == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("List of classes removed in Java layer:\n");
        for (Map.Entry<String, AtomicInteger> entry : this.classesRemoved.entrySet()) {
            stringBuilder.append(" - ").append(entry.getKey()).append(": ").append(entry.getValue().toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("VTK Gabage Collection: free(");
        stringBuilder.append(this.numberOfObjectsToFree);
        stringBuilder.append(") - keep(");
        stringBuilder.append(this.numberOfObjectsStillReferenced);
        stringBuilder.append(") - total(");
        stringBuilder.append(this.getTotalNumberOfObjects());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

