/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.lang;

import icy.system.IcyHandledException;
import java.util.ArrayList;
import java.util.List;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.Link;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.blocks.tools.ReLoop;
import plugins.adufour.blocks.util.BlocksException;
import plugins.adufour.blocks.util.LoopException;
import plugins.adufour.blocks.util.ScopeException;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarInteger;

public class Loop
extends WorkFlow {
    private final ArrayList<Var<?>> loopVariables = new ArrayList();
    private VarInteger iterationCounter;
    public final VarBoolean stopOnFirstError = new VarBoolean("Stop on first error", false);

    public Loop() {
        super(false);
        this.declareLoopVariables(this.loopVariables);
        this.loopVariables.add((Var<?>)this.iterationCounter);
    }

    @Override
    public BlockDescriptor getBlock(int blockID) {
        if (blockID == -1) {
            return this.getBlockDescriptor();
        }
        return super.getBlock(blockID);
    }

    @Override
    public BlockDescriptor getInputOwner(Var<?> var) {
        return this.loopVariables.contains(var) ? this.getBlockDescriptor() : super.getInputOwner(var);
    }

    @Override
    public BlockDescriptor getOutputOwner(Var<?> var) {
        return this.loopVariables.contains(var) ? this.getBlockDescriptor() : super.getOutputOwner(var);
    }

    @Override
    public String getInputVarID(Var<?> variable) {
        for (Var<?> innerVar : this.loopVariables) {
            if (variable != innerVar) continue;
            return this.getBlockDescriptor().inputVars.getID(variable);
        }
        return super.getInputVarID(variable);
    }

    @Override
    public String getOutputVarID(Var<?> variable) {
        for (Var<?> innerVar : this.loopVariables) {
            if (variable != innerVar) continue;
            return this.getBlockDescriptor().outputVars.getID(variable);
        }
        return super.getOutputVarID(variable);
    }

    public VarInteger getIterationCounter() {
        return this.iterationCounter;
    }

    @Deprecated
    protected void addLoopVariable(Var<?> loopVar) {
        this.loopVariables.add(loopVar);
    }

    public boolean isLoopVariable(Var<?> var) {
        return this.loopVariables.contains(var);
    }

    public List<Var<?>> getLoopVariables() {
        return this.loopVariables;
    }

    @Override
    public void run() {
        this.iterationCounter.setValue((Object)0);
        this.initializeLoop();
        ArrayList<IcyHandledException> exceptions = new ArrayList<IcyHandledException>();
        while (!Thread.currentThread().isInterrupted() && !this.isStopConditionReached()) {
            for (BlockDescriptor block : this) {
                if (block.getStatus() != BlockDescriptor.BlockStatus.READY) continue;
                block.setStatus(BlockDescriptor.BlockStatus.DIRTY);
            }
            this.beforeIteration();
            try {
                super.run();
            }
            catch (IcyHandledException e) {
                exceptions.add(e);
                if (((Boolean)this.stopOnFirstError.getValue()).booleanValue()) break;
            }
            this.iterationCounter.setValue((Object)(this.iterationCounter.getValue() + 1));
            this.afterIteration();
        }
        if (exceptions.size() > 0) {
            String message = "The following errors occurred during the loop:\n\n";
            for (Exception exception : exceptions) {
                message = message + " - " + exception.getMessage() + "\n";
            }
            throw new BlocksException(message, true);
        }
    }

    public void initializeLoop() {
    }

    public void beforeIteration() {
    }

    public void afterIteration() {
        Thread.yield();
    }

    public boolean isStopConditionReached() {
        return false;
    }

    @Override
    protected <T> void checkScope(Link<T> link) throws ScopeException {
        block2: {
            try {
                super.checkScope(link);
            }
            catch (ScopeException e) {
                if (this.loopVariables.contains(link.srcVar)) break block2;
                throw e;
            }
        }
    }

    @Override
    protected <T> void checkLoop(Link<T> link) throws LoopException {
        try {
            super.checkLoop(link);
        }
        catch (LoopException e) {
            if (link.dstBlock.getBlock() instanceof ReLoop) {
                ReLoop reLoop = (ReLoop)link.dstBlock.getBlock();
                if (link.dstVar == reLoop.reloopValue) {
                    return;
                }
            }
            throw e;
        }
    }

    @Override
    public void declareOutput(VarList outputMap) {
        super.declareOutput(outputMap);
        this.iterationCounter = new VarInteger("iteration", 0);
        this.iterationCounter.setEnabled(false);
        outputMap.add("iteration", (Var<?>)this.iterationCounter);
    }

    public void declareLoopVariables(List<Var<?>> loopVars) {
    }
}

