/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.base.mapping.DifferentiableMapping;
import mitiv.cost.DifferentiableCostFunction;
import mitiv.cost.GaussianLikelihood;
import mitiv.cost.WeightedData;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;

public class DifferentiableGaussianLikelihood
extends GaussianLikelihood
implements DifferentiableCostFunction {
    protected Vector work2 = null;

    public DifferentiableGaussianLikelihood(WeightedData weightedData, DifferentiableMapping directModel) {
        super(weightedData, directModel);
    }

    @Override
    public double computeCostAndGradient(double alpha, Vector x, Vector gx, boolean clr) {
        this.dataSpace.check(x);
        this.dataSpace.check(gx);
        if (alpha == 0.0) {
            if (clr) {
                gx.zero();
            }
            return 0.0;
        }
        this.computeResiduals(x);
        double sum = 0.0;
        if (this.ignoreWeights) {
            sum = this.work1.norm2();
        } else if (this.isSinglePrecision()) {
            float[] r = ((FloatShapedVector)this.work1).getData();
            float[] w = ((FloatShapedVector)this.getWeights()).getData();
            for (int i = 0; i < r.length; ++i) {
                float ri = r[i];
                float wr = w[i] * ri;
                sum += (double)(wr * ri);
                r[i] = wr;
            }
        } else {
            double[] r = ((DoubleShapedVector)this.work1).getData();
            double[] w = ((DoubleShapedVector)this.getWeights()).getData();
            for (int i = 0; i < r.length; ++i) {
                double ri = r[i];
                double wr = w[i] * ri;
                sum += wr * ri;
                r[i] = wr;
            }
        }
        if (clr) {
            ((DifferentiableMapping)this.directModel).applyJacobian(gx, x, this.work1);
            gx.scale(alpha);
        } else {
            if (this.work2 == null) {
                this.work2 = this.variableSpace.create();
            }
            ((DifferentiableMapping)this.directModel).applyJacobian(this.work2, x, this.work1);
            gx.add(alpha, this.work2);
        }
        return alpha / 2.0 * sum;
    }
}

