/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.lafwidget.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.pushingpixels.lafwidget.ant.AugmentException;
import org.pushingpixels.lafwidget.ant.LafMainClassAugmenter;
import org.pushingpixels.lafwidget.ant.UiDelegateType;

public class AugmentMainTask
extends Task {
    private boolean m_verbose;
    private Path m_classpath;
    private List<FileSet> m_fileSet;
    private String m_mainLafClassName;
    private List<UiDelegateType> m_delegatesToCreate;

    public void init() throws BuildException {
        super.init();
        this.m_fileSet = new ArrayList<FileSet>();
        this.m_delegatesToCreate = new ArrayList<UiDelegateType>();
    }

    private String[] getPaths() {
        String[] pathArray = null;
        if (this.m_classpath != null) {
            pathArray = this.m_classpath.list();
        } else {
            pathArray = new String[this.m_fileSet.size()];
            for (int i = 0; i < this.m_fileSet.size(); ++i) {
                FileSet fileSet = this.m_fileSet.get(i);
                File directory = fileSet.getDir(this.getProject());
                pathArray[i] = directory.getAbsolutePath();
            }
        }
        return pathArray;
    }

    public void execute() throws BuildException {
        try {
            for (UiDelegateType dtc : this.m_delegatesToCreate) {
                if (!this.m_verbose) continue;
                System.out.println("Will create forwarding delegate for : " + dtc.getName());
            }
            String[] pathArr = this.getPaths();
            LafMainClassAugmenter augmenter = new LafMainClassAugmenter();
            if (this.m_verbose) {
                augmenter.setVerbose(this.m_verbose);
            }
            for (int i = 0; i < pathArr.length; ++i) {
                String[] delegates = new String[this.m_delegatesToCreate.size()];
                int count = 0;
                for (UiDelegateType dtc : this.m_delegatesToCreate) {
                    delegates[count++] = dtc.getName();
                }
                augmenter.setDelegatesToAdd(delegates);
                augmenter.process(pathArr[0], new File(pathArr[0]), this.m_mainLafClassName);
            }
        }
        catch (AugmentException ae) {
            throw new BuildException((Throwable)ae);
        }
    }

    public void addClassPathSet(FileSet fSet) {
        this.m_fileSet.add(fSet);
    }

    public void addDelegate(UiDelegateType delegate) {
        this.m_delegatesToCreate.add(delegate);
    }

    public Path getClasspath() {
        return this.m_classpath;
    }

    public void setClasspath(Path classpath) {
        if (this.m_classpath == null) {
            this.m_classpath = classpath;
        } else {
            this.m_classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.m_classpath == null) {
            this.m_classpath = new Path(this.getProject());
        }
        return this.m_classpath;
    }

    public void setMainlafclassname(String string) {
        this.m_mainLafClassName = string;
    }

    public void setVerbose(boolean bool) {
        this.m_verbose = bool;
    }
}

