/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.ByteArray;
import mitiv.array.ByteScalar;
import mitiv.array.Double1D;
import mitiv.array.DoubleArray;
import mitiv.array.FloatArray;
import mitiv.array.FloatScalar;
import mitiv.array.IntArray;
import mitiv.array.IntScalar;
import mitiv.array.LongArray;
import mitiv.array.LongScalar;
import mitiv.array.Scalar;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.array.ShortScalar;
import mitiv.array.impl.FlatDouble1D;
import mitiv.array.impl.StriddenDouble1D;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public class DoubleScalar
extends Scalar
implements DoubleArray {
    final double[] data;
    final int offset;
    final boolean flat;

    public DoubleScalar() {
        this.data = new double[1];
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public DoubleScalar create() {
        return new DoubleScalar();
    }

    public DoubleScalar(double[] arr, int idx) {
        this.data = arr;
        this.offset = idx;
        this.flat = idx == 0 && arr.length == 1;
        this.checkSanity();
    }

    public static DoubleScalar wrap(double[] arr, int idx) {
        return new DoubleScalar(arr, idx);
    }

    public DoubleScalar(double value) {
        this.data = new double[]{value};
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public final void checkSanity() {
        if (this.offset < 0 || this.offset >= this.data.length) {
            throw new IndexOutOfBoundsException("Scalar offset is out of bounds");
        }
    }

    @Override
    public final int getType() {
        return 5;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    final int index() {
        return this.offset;
    }

    public final double get() {
        return this.data[this.offset];
    }

    public final void set(double value) {
        this.data[this.offset] = value;
    }

    @Override
    public final void fill(double value) {
        this.data[this.offset] = value;
    }

    @Override
    public final void fill(DoubleGenerator generator) {
        this.data[this.offset] = generator.nextDouble();
    }

    @Override
    public final void increment(double value) {
        int n = this.offset;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public final void decrement(double value) {
        int n = this.offset;
        this.data[n] = this.data[n] - value;
    }

    @Override
    public final void scale(double value) {
        int n = this.offset;
        this.data[n] = this.data[n] * value;
    }

    @Override
    public final void map(DoubleFunction function) {
        this.data[this.offset] = function.apply(this.data[this.offset]);
    }

    @Override
    public final void scan(DoubleScanner scanner) {
        scanner.initialize(this.data[this.offset]);
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public final double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public final double[] flatten(boolean forceCopy) {
        if (!forceCopy && this.flat) {
            return this.data;
        }
        return new double[]{this.data[this.offset]};
    }

    @Override
    public final double[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public double min() {
        return this.data[this.offset];
    }

    @Override
    public double max() {
        return this.data[this.offset];
    }

    @Override
    public double[] getMinAndMax() {
        double[] result = new double[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(double[] mm) {
        double value;
        mm[0] = value = this.data[this.offset];
        mm[1] = value;
    }

    @Override
    public double sum() {
        return this.data[this.offset];
    }

    @Override
    public double average() {
        return this.data[this.offset];
    }

    @Override
    public final ByteArray toByte() {
        return new ByteScalar((byte)this.data[this.offset]);
    }

    @Override
    public final ShortArray toShort() {
        return new ShortScalar((short)this.data[this.offset]);
    }

    @Override
    public final IntArray toInt() {
        return new IntScalar((int)this.data[this.offset]);
    }

    @Override
    public final LongArray toLong() {
        return new LongScalar((long)this.data[this.offset]);
    }

    @Override
    public final FloatArray toFloat() {
        return new FloatScalar((float)this.data[this.offset]);
    }

    @Override
    public final DoubleArray toDouble() {
        return this;
    }

    @Override
    public final Double1D as1D() {
        if (this.offset == 0) {
            return new FlatDouble1D(this.data, 1);
        }
        return new StriddenDouble1D(this.data, this.offset, 0, 1);
    }

    @Override
    public final void assign(ShapedArray src) {
        if (!shape.equals(src.getShape())) {
            throw new NonConformableArrayException();
        }
        switch (src.getType()) {
            case 0: {
                this.data[this.offset] = ((ByteScalar)src).get();
                break;
            }
            case 1: {
                this.data[this.offset] = ((ShortScalar)src).get();
                break;
            }
            case 2: {
                this.data[this.offset] = ((IntScalar)src).get();
                break;
            }
            case 3: {
                this.data[this.offset] = ((LongScalar)src).get();
                break;
            }
            case 4: {
                this.data[this.offset] = ((FloatScalar)src).get();
                break;
            }
            case 5: {
                this.data[this.offset] = ((DoubleScalar)src).get();
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
    }

    @Override
    public final void assign(ShapedVector src) {
        if (!shape.equals(src.getShape())) {
            throw new NonConformableArrayException();
        }
        this.data[this.offset] = src.get(0);
    }

    @Override
    public final DoubleScalar copy() {
        return new DoubleScalar(this.data[this.offset]);
    }
}

