/*
 * Decompiled with CFR 0.152.
 */
package icy.image;

import icy.common.CollapsibleEvent;
import icy.image.IcyBufferedImage;

public class IcyBufferedImageEvent
implements CollapsibleEvent {
    private final IcyBufferedImage image;
    private final IcyBufferedImageEventType type;
    private int param;

    public IcyBufferedImageEvent(IcyBufferedImage image, IcyBufferedImageEventType type) {
        this(image, type, -1);
    }

    public IcyBufferedImageEvent(IcyBufferedImage image, IcyBufferedImageEventType type, int param) {
        this.image = image;
        this.type = type;
        this.param = param;
    }

    public IcyBufferedImage getImage() {
        return this.image;
    }

    public IcyBufferedImageEventType getType() {
        return this.type;
    }

    public int getParam() {
        return this.param;
    }

    @Override
    public boolean collapse(CollapsibleEvent event) {
        if (this.equals(event)) {
            IcyBufferedImageEvent e = (IcyBufferedImageEvent)event;
            if (e.getParam() != this.param) {
                this.param = -1;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.image.hashCode() ^ this.type.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IcyBufferedImageEvent) {
            IcyBufferedImageEvent e = (IcyBufferedImageEvent)obj;
            return this.image == e.getImage() && this.type == e.getType();
        }
        return super.equals(obj);
    }

    public static enum IcyBufferedImageEventType {
        DATA_CHANGED,
        BOUNDS_CHANGED,
        COLORMAP_CHANGED;

    }
}

