/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Counters {
    List<Counter> counters = new ArrayList<Counter>();
    Map<String, Counter> map = new HashMap<String, Counter>();

    public Counter add(String name) {
        CounterImpl c = new CounterImpl(name);
        this.counters.add(c);
        this.map.put(name, c);
        return c;
    }

    public void show(Formatter f) {
        for (Counter c : this.counters) {
            c.show(f);
        }
    }

    public Counter get(String name) {
        return this.map.get(name);
    }

    public void count(String name, Comparable value) {
        CounterImpl counter = (CounterImpl)this.map.get(name);
        counter.count(value);
    }

    public void addTo(Counters sub) {
        for (Counter subC : sub.counters) {
            Counter all = this.map.get(subC.getName());
            all.addTo(subC);
        }
    }

    public Counters makeSubCounters() {
        Counters result = new Counters();
        for (Counter c : this.counters) {
            result.add(c.getName());
        }
        return result;
    }

    private static class CounterImpl
    implements Counter {
        protected String name;
        protected boolean showRange;
        private Comparable first;
        private Comparable last;
        private Map<Comparable, Integer> set = new HashMap<Comparable, Integer>();
        private String range;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Counter setShowRange(boolean showRange) {
            this.showRange = showRange;
            return this;
        }

        public CounterImpl(String name) {
            this.name = name;
        }

        public void count(Comparable value) {
            Integer count = this.set.get(value);
            if (count == null) {
                this.set.put(value, 1);
            } else {
                this.set.put(value, count + 1);
            }
        }

        @Override
        public void addTo(Counter sub) {
            CounterImpl subs = (CounterImpl)sub;
            for (Map.Entry<Comparable, Integer> entry : subs.set.entrySet()) {
                Integer count = this.set.get(entry.getKey());
                if (count == null) {
                    count = 0;
                }
                this.set.put(entry.getKey(), count + entry.getValue());
            }
        }

        @Override
        public void show(Formatter f) {
            ArrayList<Comparable> list = new ArrayList<Comparable>(this.set.keySet());
            f.format("%n%s (%d)%n", this.name, list.size());
            Collections.sort(list);
            if (this.showRange) {
                int n = list.size();
                if (n == 0) {
                    f.format("none%n", new Object[0]);
                } else {
                    f.format("   %10s - %10s: count = %d%n", list.get(0), list.get(n - 1), this.getUnique());
                }
            } else {
                Object prev = null;
                for (Comparable key : list) {
                    int count = this.set.get(key);
                    boolean isHashDup = prev != null && key.hashCode() == prev.hashCode();
                    boolean isNameDup = prev != null && key.toString().equals(prev.toString());
                    f.format("  %s %10s: count = %d%n", isHashDup != isNameDup ? "*" : " ", key, count);
                    prev = key;
                }
            }
        }

        @Override
        public String showRange() {
            if (this.range == null) {
                ArrayList<Comparable> list = new ArrayList<Comparable>(this.set.keySet());
                Collections.sort(list);
                int n = list.size();
                if (n == 0) {
                    return "none";
                }
                Formatter f = new Formatter();
                this.first = (Comparable)list.get(0);
                this.last = (Comparable)list.get(n - 1);
                f.format("%10s - %10s", this.first, this.last);
                this.range = f.toString();
            }
            return this.range;
        }

        @Override
        public int getUnique() {
            return this.set.size();
        }

        @Override
        public Comparable getFirst() {
            return this.first;
        }

        @Override
        public Comparable getLast() {
            return this.last;
        }

        @Override
        public int getTotal() {
            int total = 0;
            for (Map.Entry<Comparable, Integer> entry : this.set.entrySet()) {
                total += entry.getValue().intValue();
            }
            return total;
        }
    }

    public static interface Counter {
        public void show(Formatter var1);

        public String showRange();

        public String getName();

        public void addTo(Counter var1);

        public int getUnique();

        public Comparable getFirst();

        public Comparable getLast();

        public int getTotal();

        public Counter setShowRange(boolean var1);
    }
}

