/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.expressions;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import plugins.ylemontag.mathoperations.Expression;
import plugins.ylemontag.mathoperations.expressions.CompositionOperator;
import plugins.ylemontag.mathoperations.expressions.ExpressionComposition;
import plugins.ylemontag.mathoperations.expressions.ExpressionConstant;
import plugins.ylemontag.mathoperations.expressions.ExpressionFunction;
import plugins.ylemontag.mathoperations.expressions.ExpressionOpposite;
import plugins.ylemontag.mathoperations.expressions.ExpressionVariable;
import plugins.ylemontag.mathoperations.expressions.Token;

public class Parser {
    public static Expression parse(String in) {
        LinkedList<Token> tokens = Token.parse(in);
        return Parser.interpretAsExpression(tokens);
    }

    private static Expression interpretAsExpression(List<?> in) {
        in = Parser.reduceParenthesis(in);
        in = Parser.identifyTerminalExpressions(in);
        in = Parser.reduceOperators(in, CompositionOperator.POWER);
        in = Parser.reduceOperators(in, CompositionOperator.MULTIPLY, CompositionOperator.DIVIDE);
        in = Parser.reduceUnaryMinus(in);
        if ((in = Parser.reduceOperators(in, CompositionOperator.ADD, CompositionOperator.SUBTRACT)).size() != 1) {
            throw new Expression.ParsingException("Badly formatted algebraic expression.");
        }
        Expression retVal = (Expression)in.get(0);
        if (retVal == null) {
            throw new Expression.ParsingException("Badly formatted algebraic expression.");
        }
        return retVal;
    }

    private static List<Object> reduceParenthesis(List<?> in) {
        int state = 0;
        LinkedList<Expression> arguments = new LinkedList<Expression>();
        LinkedList expression = new LinkedList();
        int level = 0;
        String function = "";
        LinkedList<Object> retVal = new LinkedList<Object>();
        ListIterator<?> it = in.listIterator();
        while (it.hasNext()) {
            Object current = it.next();
            Token.Type currentType = Parser.extractTokenType(current);
            if (state == 0) {
                if (currentType == Token.Type.OPEN_P) {
                    Object previous = retVal.peekLast();
                    Token.Type previousType = Parser.extractTokenType(previous);
                    if (previousType == Token.Type.ID) {
                        retVal.pollLast();
                        function = (String)((Token)previous).getValue();
                        state = 2;
                        continue;
                    }
                    state = 1;
                    continue;
                }
                retVal.add(current);
                continue;
            }
            if (currentType == Token.Type.OPEN_P) {
                ++level;
                expression.add(current);
                continue;
            }
            if (currentType == Token.Type.CLOSE_P) {
                if (level > 0) {
                    --level;
                    expression.add(current);
                    continue;
                }
                if (state == 1) {
                    retVal.add(Parser.interpretAsExpression(expression));
                    expression.clear();
                } else {
                    arguments.add(Parser.interpretAsExpression(expression));
                    expression.clear();
                    retVal.add(new ExpressionFunction(function, arguments));
                    arguments.clear();
                }
                state = 0;
                continue;
            }
            if (currentType == Token.Type.COMMA && state == 2 && level == 0) {
                arguments.add(Parser.interpretAsExpression(expression));
                expression.clear();
                continue;
            }
            expression.add(current);
        }
        if (state != 0) {
            throw new Expression.ParsingException("Badly placed parenthesis.");
        }
        return retVal;
    }

    private static List<Object> reduceOperators(List<?> in, CompositionOperator ... operators) {
        HashMap<Token.Type, CompositionOperator> targets = new HashMap<Token.Type, CompositionOperator>();
        for (CompositionOperator o : operators) {
            targets.put(o.getToken(), o);
        }
        LinkedList<Object> retVal = new LinkedList<Object>();
        ListIterator<?> it = in.listIterator();
        while (it.hasNext()) {
            CompositionOperator operator;
            Object current = it.next();
            Token.Type currentType = Parser.extractTokenType(current);
            CompositionOperator compositionOperator = operator = currentType == null ? null : (CompositionOperator)((Object)targets.get((Object)currentType));
            if (operator != null) {
                if (retVal.isEmpty()) {
                    throw new Expression.ParsingException("No expression on the left of operator " + (Object)((Object)currentType) + ".");
                }
                if (!it.hasNext()) {
                    throw new Expression.ParsingException("No expression on the right of operator " + (Object)((Object)currentType) + ".");
                }
                Object lhs = retVal.pollLast();
                Object rhs = it.next();
                if (!(lhs instanceof Expression)) {
                    throw new Expression.ParsingException("No expression on the left of operator " + (Object)((Object)currentType) + ".");
                }
                if (!(rhs instanceof Expression)) {
                    throw new Expression.ParsingException("No expression on the right of operator " + (Object)((Object)currentType) + ".");
                }
                retVal.add(new ExpressionComposition(operator, (Expression)lhs, (Expression)rhs));
                continue;
            }
            retVal.add(current);
        }
        return retVal;
    }

    private static List<Object> reduceUnaryMinus(List<?> in) {
        LinkedList<Object> retVal = new LinkedList<Object>();
        ListIterator<?> it = in.listIterator();
        if (!it.hasNext()) {
            return retVal;
        }
        Object first = it.next();
        if (Parser.extractTokenType(first) == Token.Type.MINUS) {
            if (!it.hasNext()) {
                throw new Expression.ParsingException("No expression on the right of operator - (unary).");
            }
            Object second = it.next();
            if (!(second instanceof Expression)) {
                throw new Expression.ParsingException("No expression on the right of operator - (unary).");
            }
            retVal.add(new ExpressionOpposite((Expression)second));
        } else {
            retVal.add(first);
        }
        while (it.hasNext()) {
            Object current = it.next();
            retVal.add(current);
        }
        return retVal;
    }

    private static List<Object> identifyTerminalExpressions(List<?> in) {
        LinkedList<Object> retVal = new LinkedList<Object>();
        ListIterator<?> it = in.listIterator();
        while (it.hasNext()) {
            Object current = it.next();
            Token.Type currentType = Parser.extractTokenType(current);
            if (currentType == Token.Type.LITTERAL) {
                double value = (Double)((Token)current).getValue();
                retVal.add(new ExpressionConstant(value));
                continue;
            }
            if (currentType == Token.Type.ID) {
                String variableName = (String)((Token)current).getValue();
                retVal.add(new ExpressionVariable(variableName));
                continue;
            }
            retVal.add(current);
        }
        return retVal;
    }

    private static Token.Type extractTokenType(Object obj) {
        if (obj == null || !(obj instanceof Token)) {
            return null;
        }
        return ((Token)obj).getType();
    }
}

