package plugins.spop.rotation3D;

import icy.sequence.Sequence;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;

public class StackRotationByAngle extends EzPlug implements Block
{
    
    EzVarSequence input1 = new EzVarSequence("Input");
    
    EzVarInteger angle_maxXY = new EzVarInteger("Angle XY", 5, 0, 359, 1);
    EzVarInteger angle_maxXZ = new EzVarInteger("Angle XZ", 0, 0, 359, 1);
    EzVarInteger angle_maxYZ = new EzVarInteger("Angle YZ", 0, 0, 359, 1);
    EzVarBoolean crop = new EzVarBoolean("crop data", false);
    
    EzVarSequence output = new EzVarSequence("Output");
    
    @Override
    public void clean()
    {
        
    }
    
    @Override
    protected void execute()
    {
        SequenceRotation3D rot = new SequenceRotation3D(input1.getValue(true), angle_maxXY.getValue(), angle_maxXZ.getValue(), angle_maxYZ.getValue(), crop.getValue());
        Sequence out = rot.getRotatedSequence();
        out.setName("Angle rotation");
        if (getUI() != null) addSequence(out);
        output.setValue(out);
        
    }
    
    @Override
    public void initialize()
    {
        // TODO Auto-generated method stub
        addEzComponent(input1);
        
        EzGroup groupFileSize = new EzGroup("Angle", angle_maxXY, angle_maxXZ, angle_maxYZ, crop);
        addEzComponent(groupFileSize);
        
    }
    
    @Override
    public void declareInput(VarList inputMap)
    {
        // TODO Auto-generated method stub
        inputMap.add(input1.getVariable());
        
        inputMap.add(angle_maxXY.getVariable());
        inputMap.add(angle_maxXZ.getVariable());
        inputMap.add(angle_maxYZ.getVariable());
        inputMap.add(crop.getVariable());
        
    }
    
    @Override
    public void declareOutput(VarList outputMap)
    {
        // TODO Auto-generated method stub
        outputMap.add(output.getVariable());
    }
    
}
