/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.lang.reflect.Field;
import pl.edu.icm.jlargearrays.BitLargeArray;
import pl.edu.icm.jlargearrays.ByteLargeArray;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.IntLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LongLargeArray;
import pl.edu.icm.jlargearrays.ShortLargeArray;
import pl.edu.icm.jlargearrays.StringLargeArray;
import sun.misc.Unsafe;

public class Utilities {
    public static final Unsafe UNSAFE;

    private Utilities() {
    }

    public static void arraycopy(LargeArray largeArray, long l, LargeArray largeArray2, long l2, long l3) {
        if (largeArray.getType() != largeArray2.getType()) {
            throw new IllegalArgumentException("The type of source array is different than the type of destimation array.");
        }
        switch (largeArray.getType()) {
            case BIT: {
                Utilities.arraycopy((BitLargeArray)largeArray, l, (BitLargeArray)largeArray2, l2, l3);
                break;
            }
            case BYTE: {
                Utilities.arraycopy((ByteLargeArray)largeArray, l, (ByteLargeArray)largeArray2, l2, l3);
                break;
            }
            case SHORT: {
                Utilities.arraycopy((ShortLargeArray)largeArray, l, (ShortLargeArray)largeArray2, l2, l3);
                break;
            }
            case INT: {
                Utilities.arraycopy((IntLargeArray)largeArray, l, (IntLargeArray)largeArray2, l2, l3);
                break;
            }
            case LONG: {
                Utilities.arraycopy((LongLargeArray)largeArray, l, (LongLargeArray)largeArray2, l2, l3);
                break;
            }
            case FLOAT: {
                Utilities.arraycopy((FloatLargeArray)largeArray, l, (FloatLargeArray)largeArray2, l2, l3);
                break;
            }
            case DOUBLE: {
                Utilities.arraycopy((DoubleLargeArray)largeArray, l, (DoubleLargeArray)largeArray2, l2, l3);
                break;
            }
            case STRING: {
                Utilities.arraycopy((StringLargeArray)largeArray, l, (StringLargeArray)largeArray2, l2, l3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid array type.");
            }
        }
    }

    public static void arraycopy(final BitLargeArray bitLargeArray, final long l, final BitLargeArray bitLargeArray2, final long l2, long l3) {
        if (l < 0L || l >= bitLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (l2 < 0L || l2 >= bitLargeArray2.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n = Runtime.getRuntime().availableProcessors();
        if (n < 2 || l3 < 100000L) {
            long l4 = l;
            long l5 = l2;
            while (l4 < l + l3) {
                bitLargeArray2.setByte(l5, bitLargeArray.getByte(l4));
                ++l4;
                ++l5;
            }
        } else {
            long l6;
            long l7;
            int n2;
            long l8 = l3 / (long)n;
            Thread[] threadArray = new Thread[n];
            for (n2 = 0; n2 < n; ++n2) {
                l7 = (long)n2 * l8;
                l6 = n2 == n - 1 ? l3 : l7 + l8;
                threadArray[n2] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l7; i < l6; ++i) {
                            bitLargeArray2.setByte(l2 + i, bitLargeArray.getByte(l + i));
                        }
                    }
                });
                threadArray[n2].start();
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    threadArray[n2].join();
                    threadArray[n2] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                l7 = l;
                l6 = l2;
                while (l7 < l + l3) {
                    bitLargeArray2.setByte(l6, bitLargeArray.getByte(l7));
                    ++l7;
                    ++l6;
                }
            }
        }
    }

    public static void arraycopy(final boolean[] blArray, final int n, final BitLargeArray bitLargeArray, final long l, long l2) {
        if (n < 0 || n >= blArray.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (l < 0L || l >= bitLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n2 = n;
        int n3 = Runtime.getRuntime().availableProcessors();
        if (n3 < 2 || l2 < 100000L) {
            for (long i = l; i < l + l2; ++i) {
                bitLargeArray.setBoolean(i, blArray[n2++]);
            }
        } else {
            long l3;
            int n4;
            long l4 = l2 / (long)n3;
            Thread[] threadArray = new Thread[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                l3 = (long)n4 * l4;
                final long l5 = n4 == n3 - 1 ? l2 : l3 + l4;
                threadArray[n4] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l5; ++i) {
                            bitLargeArray.setBoolean(l + i, blArray[n + (int)i]);
                        }
                    }
                });
                threadArray[n4].start();
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    threadArray[n4].join();
                    threadArray[n4] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                for (l3 = l; l3 < l + l2; ++l3) {
                    bitLargeArray.setBoolean(l3, blArray[n2++]);
                }
            }
        }
    }

    public static void arraycopy(final ByteLargeArray byteLargeArray, final long l, final ByteLargeArray byteLargeArray2, final long l2, long l3) {
        if (l < 0L || l >= byteLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (l2 < 0L || l2 >= byteLargeArray2.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n = Runtime.getRuntime().availableProcessors();
        if (n < 2 || l3 < 100000L) {
            long l4 = l;
            long l5 = l2;
            while (l4 < l + l3) {
                byteLargeArray2.setByte(l5, byteLargeArray.getByte(l4));
                ++l4;
                ++l5;
            }
        } else {
            long l6;
            long l7;
            int n2;
            long l8 = l3 / (long)n;
            Thread[] threadArray = new Thread[n];
            for (n2 = 0; n2 < n; ++n2) {
                l7 = (long)n2 * l8;
                l6 = n2 == n - 1 ? l3 : l7 + l8;
                threadArray[n2] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l7; i < l6; ++i) {
                            byteLargeArray2.setByte(l2 + i, byteLargeArray.getByte(l + i));
                        }
                    }
                });
                threadArray[n2].start();
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    threadArray[n2].join();
                    threadArray[n2] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                l7 = l;
                l6 = l2;
                while (l7 < l + l3) {
                    byteLargeArray2.setByte(l6, byteLargeArray.getByte(l7));
                    ++l7;
                    ++l6;
                }
            }
        }
    }

    public static void arraycopy(final byte[] byArray, final int n, final ByteLargeArray byteLargeArray, final long l, long l2) {
        if (n < 0 || n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (l < 0L || l >= byteLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n2 = n;
        int n3 = Runtime.getRuntime().availableProcessors();
        if (n3 < 2 || l2 < 100000L) {
            for (long i = l; i < l + l2; ++i) {
                byteLargeArray.setByte(i, byArray[n2++]);
            }
        } else {
            long l3;
            int n4;
            long l4 = l2 / (long)n3;
            Thread[] threadArray = new Thread[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                l3 = (long)n4 * l4;
                final long l5 = n4 == n3 - 1 ? l2 : l3 + l4;
                threadArray[n4] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l5; ++i) {
                            byteLargeArray.setByte(l + i, byArray[n + (int)i]);
                        }
                    }
                });
                threadArray[n4].start();
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    threadArray[n4].join();
                    threadArray[n4] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                for (l3 = l; l3 < l + l2; ++l3) {
                    byteLargeArray.setByte(l3, byArray[n2++]);
                }
            }
        }
    }

    public static void arraycopy(final ShortLargeArray shortLargeArray, final long l, final ShortLargeArray shortLargeArray2, final long l2, long l3) {
        if (l < 0L || l >= shortLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (l2 < 0L || l2 >= shortLargeArray2.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n = Runtime.getRuntime().availableProcessors();
        if (n < 2 || l3 < 100000L) {
            long l4 = l;
            long l5 = l2;
            while (l4 < l + l3) {
                shortLargeArray2.setShort(l5, shortLargeArray.getShort(l4));
                ++l4;
                ++l5;
            }
        } else {
            long l6;
            long l7;
            int n2;
            long l8 = l3 / (long)n;
            Thread[] threadArray = new Thread[n];
            for (n2 = 0; n2 < n; ++n2) {
                l7 = (long)n2 * l8;
                l6 = n2 == n - 1 ? l3 : l7 + l8;
                threadArray[n2] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l7; i < l6; ++i) {
                            shortLargeArray2.setShort(l2 + i, shortLargeArray.getShort(l + i));
                        }
                    }
                });
                threadArray[n2].start();
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    threadArray[n2].join();
                    threadArray[n2] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                l7 = l;
                l6 = l2;
                while (l7 < l + l3) {
                    shortLargeArray2.setShort(l6, shortLargeArray.getShort(l7));
                    ++l7;
                    ++l6;
                }
            }
        }
    }

    public static void arraycopy(final short[] sArray, final int n, final ShortLargeArray shortLargeArray, final long l, long l2) {
        if (n < 0 || n >= sArray.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (l < 0L || l >= shortLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n2 = n;
        int n3 = Runtime.getRuntime().availableProcessors();
        if (n3 < 2 || l2 < 100000L) {
            for (long i = l; i < l + l2; ++i) {
                shortLargeArray.setShort(i, sArray[n2++]);
            }
        } else {
            long l3;
            int n4;
            long l4 = l2 / (long)n3;
            Thread[] threadArray = new Thread[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                l3 = (long)n4 * l4;
                final long l5 = n4 == n3 - 1 ? l2 : l3 + l4;
                threadArray[n4] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l5; ++i) {
                            shortLargeArray.setShort(l + i, sArray[n + (int)i]);
                        }
                    }
                });
                threadArray[n4].start();
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    threadArray[n4].join();
                    threadArray[n4] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                for (l3 = l; l3 < l + l2; ++l3) {
                    shortLargeArray.setShort(l3, sArray[n2++]);
                }
            }
        }
    }

    public static void arraycopy(final IntLargeArray intLargeArray, final long l, final IntLargeArray intLargeArray2, final long l2, long l3) {
        if (l < 0L || l >= intLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (l2 < 0L || l2 >= intLargeArray2.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n = Runtime.getRuntime().availableProcessors();
        if (n < 2 || l3 < 100000L) {
            long l4 = l;
            long l5 = l2;
            while (l4 < l + l3) {
                intLargeArray2.setInt(l5, intLargeArray.getInt(l4));
                ++l4;
                ++l5;
            }
        } else {
            long l6;
            long l7;
            int n2;
            long l8 = l3 / (long)n;
            Thread[] threadArray = new Thread[n];
            for (n2 = 0; n2 < n; ++n2) {
                l7 = (long)n2 * l8;
                l6 = n2 == n - 1 ? l3 : l7 + l8;
                threadArray[n2] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l7; i < l6; ++i) {
                            intLargeArray2.setInt(l2 + i, intLargeArray.getInt(l + i));
                        }
                    }
                });
                threadArray[n2].start();
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    threadArray[n2].join();
                    threadArray[n2] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                l7 = l;
                l6 = l2;
                while (l7 < l + l3) {
                    intLargeArray2.setInt(l6, intLargeArray.getInt(l7));
                    ++l7;
                    ++l6;
                }
            }
        }
    }

    public static void arraycopy(final int[] nArray, final int n, final IntLargeArray intLargeArray, final long l, long l2) {
        if (n < 0 || n >= nArray.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (l < 0L || l >= intLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n2 = n;
        int n3 = Runtime.getRuntime().availableProcessors();
        if (n3 < 2 || l2 < 100000L) {
            for (long i = l; i < l + l2; ++i) {
                intLargeArray.setInt(i, nArray[n2++]);
            }
        } else {
            long l3;
            int n4;
            long l4 = l2 / (long)n3;
            Thread[] threadArray = new Thread[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                l3 = (long)n4 * l4;
                final long l5 = n4 == n3 - 1 ? l2 : l3 + l4;
                threadArray[n4] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l5; ++i) {
                            intLargeArray.setInt(l + i, nArray[n + (int)i]);
                        }
                    }
                });
                threadArray[n4].start();
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    threadArray[n4].join();
                    threadArray[n4] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                for (l3 = l; l3 < l + l2; ++l3) {
                    intLargeArray.setInt(l3, nArray[n2++]);
                }
            }
        }
    }

    public static void arraycopy(final LongLargeArray longLargeArray, final long l, final LongLargeArray longLargeArray2, final long l2, long l3) {
        if (l < 0L || l >= longLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (l2 < 0L || l2 >= longLargeArray2.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n = Runtime.getRuntime().availableProcessors();
        if (n < 2 || l3 < 100000L) {
            long l4 = l;
            long l5 = l2;
            while (l4 < l + l3) {
                longLargeArray2.setLong(l5, longLargeArray.getLong(l4));
                ++l4;
                ++l5;
            }
        } else {
            long l6;
            long l7;
            int n2;
            long l8 = l3 / (long)n;
            Thread[] threadArray = new Thread[n];
            for (n2 = 0; n2 < n; ++n2) {
                l7 = (long)n2 * l8;
                l6 = n2 == n - 1 ? l3 : l7 + l8;
                threadArray[n2] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l7; i < l6; ++i) {
                            longLargeArray2.setLong(l2 + i, longLargeArray.getLong(l + i));
                        }
                    }
                });
                threadArray[n2].start();
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    threadArray[n2].join();
                    threadArray[n2] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                l7 = l;
                l6 = l2;
                while (l7 < l + l3) {
                    longLargeArray2.setLong(l6, longLargeArray.getLong(l7));
                    ++l7;
                    ++l6;
                }
            }
        }
    }

    public static void arraycopy(final long[] lArray, final int n, final LongLargeArray longLargeArray, final long l, long l2) {
        if (n < 0 || n >= lArray.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (l < 0L || l >= longLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n2 = n;
        int n3 = Runtime.getRuntime().availableProcessors();
        if (n3 < 2 || l2 < 100000L) {
            for (long i = l; i < l + l2; ++i) {
                longLargeArray.setLong(i, lArray[n2++]);
            }
        } else {
            long l3;
            int n4;
            long l4 = l2 / (long)n3;
            Thread[] threadArray = new Thread[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                l3 = (long)n4 * l4;
                final long l5 = n4 == n3 - 1 ? l2 : l3 + l4;
                threadArray[n4] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l5; ++i) {
                            longLargeArray.setLong(l + i, lArray[n + (int)i]);
                        }
                    }
                });
                threadArray[n4].start();
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    threadArray[n4].join();
                    threadArray[n4] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                for (l3 = l; l3 < l + l2; ++l3) {
                    longLargeArray.setLong(l3, lArray[n2++]);
                }
            }
        }
    }

    public static void arraycopy(final FloatLargeArray floatLargeArray, final long l, final FloatLargeArray floatLargeArray2, final long l2, long l3) {
        if (l < 0L || l >= floatLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (l2 < 0L || l2 >= floatLargeArray2.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n = Runtime.getRuntime().availableProcessors();
        if (n < 2 || l3 < 100000L) {
            long l4 = l;
            long l5 = l2;
            while (l4 < l + l3) {
                floatLargeArray2.setFloat(l5, floatLargeArray.getFloat(l4));
                ++l4;
                ++l5;
            }
        } else {
            long l6;
            long l7;
            int n2;
            long l8 = l3 / (long)n;
            Thread[] threadArray = new Thread[n];
            for (n2 = 0; n2 < n; ++n2) {
                l7 = (long)n2 * l8;
                l6 = n2 == n - 1 ? l3 : l7 + l8;
                threadArray[n2] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l7; i < l6; ++i) {
                            floatLargeArray2.setFloat(l2 + i, floatLargeArray.getFloat(l + i));
                        }
                    }
                });
                threadArray[n2].start();
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    threadArray[n2].join();
                    threadArray[n2] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                l7 = l;
                l6 = l2;
                while (l7 < l + l3) {
                    floatLargeArray2.setFloat(l6, floatLargeArray.getFloat(l7));
                    ++l7;
                    ++l6;
                }
            }
        }
    }

    public static void arraycopy(final float[] fArray, final int n, final FloatLargeArray floatLargeArray, final long l, long l2) {
        if (n < 0 || n >= fArray.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (l < 0L || l >= floatLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n2 = n;
        int n3 = Runtime.getRuntime().availableProcessors();
        if (n3 < 2 || l2 < 100000L) {
            for (long i = l; i < l + l2; ++i) {
                floatLargeArray.setFloat(i, fArray[n2++]);
            }
        } else {
            long l3;
            int n4;
            long l4 = l2 / (long)n3;
            Thread[] threadArray = new Thread[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                l3 = (long)n4 * l4;
                final long l5 = n4 == n3 - 1 ? l2 : l3 + l4;
                threadArray[n4] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l5; ++i) {
                            floatLargeArray.setFloat(l + i, fArray[n + (int)i]);
                        }
                    }
                });
                threadArray[n4].start();
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    threadArray[n4].join();
                    threadArray[n4] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                for (l3 = l; l3 < l + l2; ++l3) {
                    floatLargeArray.setFloat(l3, fArray[n2++]);
                }
            }
        }
    }

    public static void arraycopy(final DoubleLargeArray doubleLargeArray, final long l, final DoubleLargeArray doubleLargeArray2, final long l2, long l3) {
        if (l < 0L || l >= doubleLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (l2 < 0L || l2 >= doubleLargeArray2.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n = Runtime.getRuntime().availableProcessors();
        if (n < 2 || l3 < 100000L) {
            long l4 = l;
            long l5 = l2;
            while (l4 < l + l3) {
                doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l4));
                ++l4;
                ++l5;
            }
        } else {
            long l6;
            long l7;
            int n2;
            long l8 = l3 / (long)n;
            Thread[] threadArray = new Thread[n];
            for (n2 = 0; n2 < n; ++n2) {
                l7 = (long)n2 * l8;
                l6 = n2 == n - 1 ? l3 : l7 + l8;
                threadArray[n2] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l7; i < l6; ++i) {
                            doubleLargeArray2.setDouble(l2 + i, doubleLargeArray.getDouble(l + i));
                        }
                    }
                });
                threadArray[n2].start();
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    threadArray[n2].join();
                    threadArray[n2] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                l7 = l;
                l6 = l2;
                while (l7 < l + l3) {
                    doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l7));
                    ++l7;
                    ++l6;
                }
            }
        }
    }

    public static void arraycopy(final double[] dArray, final int n, final DoubleLargeArray doubleLargeArray, final long l, long l2) {
        if (n < 0 || n >= dArray.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (l < 0L || l >= doubleLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n2 = n;
        int n3 = Runtime.getRuntime().availableProcessors();
        if (n3 < 2 || l2 < 100000L) {
            for (long i = l; i < l + l2; ++i) {
                doubleLargeArray.setDouble(i, dArray[n2++]);
            }
        } else {
            long l3;
            int n4;
            long l4 = l2 / (long)n3;
            Thread[] threadArray = new Thread[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                l3 = (long)n4 * l4;
                final long l5 = n4 == n3 - 1 ? l2 : l3 + l4;
                threadArray[n4] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l5; ++i) {
                            doubleLargeArray.setDouble(l + i, dArray[n + (int)i]);
                        }
                    }
                });
                threadArray[n4].start();
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    threadArray[n4].join();
                    threadArray[n4] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                for (l3 = l; l3 < l + l2; ++l3) {
                    doubleLargeArray.setDouble(l3, dArray[n2++]);
                }
            }
        }
    }

    public static void arraycopy(final StringLargeArray stringLargeArray, final long l, final StringLargeArray stringLargeArray2, final long l2, long l3) {
        if (l < 0L || l >= stringLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (l2 < 0L || l2 >= stringLargeArray2.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n = Runtime.getRuntime().availableProcessors();
        if (n < 2 || l3 < 100000L) {
            long l4 = l;
            long l5 = l2;
            while (l4 < l + l3) {
                stringLargeArray2.set(l5, stringLargeArray.get(l4));
                ++l4;
                ++l5;
            }
        } else {
            long l6;
            long l7;
            int n2;
            long l8 = l3 / (long)n;
            Thread[] threadArray = new Thread[n];
            for (n2 = 0; n2 < n; ++n2) {
                l7 = (long)n2 * l8;
                l6 = n2 == n - 1 ? l3 : l7 + l8;
                threadArray[n2] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l7; i < l6; ++i) {
                            stringLargeArray2.set(l2 + i, stringLargeArray.get(l + i));
                        }
                    }
                });
                threadArray[n2].start();
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    threadArray[n2].join();
                    threadArray[n2] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                l7 = l;
                l6 = l2;
                while (l7 < l + l3) {
                    stringLargeArray2.set(l6, stringLargeArray.get(l7));
                    ++l7;
                    ++l6;
                }
            }
        }
    }

    public static void arraycopy(final String[] stringArray, final int n, final StringLargeArray stringLargeArray, final long l, long l2) {
        if (n < 0 || n >= stringArray.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (l < 0L || l >= stringLargeArray.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int n2 = n;
        int n3 = Runtime.getRuntime().availableProcessors();
        if (n3 < 2 || l2 < 100000L) {
            for (long i = l; i < l + l2; ++i) {
                stringLargeArray.set(i, stringArray[n2++]);
            }
        } else {
            long l3;
            int n4;
            long l4 = l2 / (long)n3;
            Thread[] threadArray = new Thread[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                l3 = (long)n4 * l4;
                final long l5 = n4 == n3 - 1 ? l2 : l3 + l4;
                threadArray[n4] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l5; ++i) {
                            stringLargeArray.set(l + i, stringArray[n + (int)i]);
                        }
                    }
                });
                threadArray[n4].start();
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    threadArray[n4].join();
                    threadArray[n4] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                for (l3 = l; l3 < l + l2; ++l3) {
                    stringLargeArray.set(l3, stringArray[n2++]);
                }
            }
        }
    }

    public static LargeArray create(LargeArrayType largeArrayType, long l) {
        return Utilities.create(largeArrayType, l, true);
    }

    public static LargeArray create(LargeArrayType largeArrayType, long l, boolean bl) {
        switch (largeArrayType) {
            case BIT: {
                return new BitLargeArray(l, bl);
            }
            case BYTE: {
                return new ByteLargeArray(l, bl);
            }
            case SHORT: {
                return new ShortLargeArray(l, bl);
            }
            case INT: {
                return new IntLargeArray(l, bl);
            }
            case LONG: {
                return new LongLargeArray(l, bl);
            }
            case FLOAT: {
                return new FloatLargeArray(l, bl);
            }
            case DOUBLE: {
                return new DoubleLargeArray(l, bl);
            }
            case STRING: {
                return new StringLargeArray(l, 100, bl);
            }
        }
        throw new IllegalArgumentException("Invalid array type.");
    }

    public static LargeArray convert(final LargeArray largeArray, final LargeArrayType largeArrayType) {
        LargeArray largeArray2;
        block34: {
            long l;
            int n;
            int n2;
            long l2;
            block33: {
                if (largeArray.getType() == largeArrayType) {
                    return largeArray;
                }
                l2 = largeArray.length;
                largeArray2 = Utilities.create(largeArrayType, l2, false);
                n2 = Runtime.getRuntime().availableProcessors();
                if (n2 >= 2 && l2 >= 100000L) break block33;
                switch (largeArrayType) {
                    case BIT: 
                    case BYTE: {
                        for (long i = 0L; i < l2; ++i) {
                            largeArray2.setByte(i, largeArray.getByte(i));
                        }
                        break block34;
                    }
                    case SHORT: {
                        for (long i = 0L; i < l2; ++i) {
                            largeArray2.setShort(i, largeArray.getShort(i));
                        }
                        break block34;
                    }
                    case INT: {
                        for (long i = 0L; i < l2; ++i) {
                            largeArray2.setInt(i, largeArray.getInt(i));
                        }
                        break block34;
                    }
                    case LONG: {
                        for (long i = 0L; i < l2; ++i) {
                            largeArray2.setLong(i, largeArray.getLong(i));
                        }
                        break block34;
                    }
                    case FLOAT: {
                        for (long i = 0L; i < l2; ++i) {
                            largeArray2.setFloat(i, largeArray.getFloat(i));
                        }
                        break block34;
                    }
                    case DOUBLE: {
                        for (long i = 0L; i < l2; ++i) {
                            largeArray2.setDouble(i, largeArray.getDouble(i));
                        }
                        break block34;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array type.");
                    }
                }
            }
            long l3 = l2 / (long)n2;
            Thread[] threadArray = new Thread[n2];
            for (n = 0; n < n2; ++n) {
                l = (long)n * l3;
                final long l4 = n == n2 - 1 ? l2 : l + l3;
                threadArray[n] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        switch (largeArrayType) {
                            case BYTE: {
                                for (long i = l; i < l4; ++i) {
                                    largeArray2.setByte(i, largeArray.getByte(i));
                                }
                                break;
                            }
                            case SHORT: {
                                for (long i = l; i < l4; ++i) {
                                    largeArray2.setShort(i, largeArray.getShort(i));
                                }
                                break;
                            }
                            case INT: {
                                for (long i = l; i < l4; ++i) {
                                    largeArray2.setInt(i, largeArray.getInt(i));
                                }
                                break;
                            }
                            case LONG: {
                                for (long i = l; i < l4; ++i) {
                                    largeArray2.setLong(i, largeArray.getLong(i));
                                }
                                break;
                            }
                            case FLOAT: {
                                for (long i = l; i < l4; ++i) {
                                    largeArray2.setFloat(i, largeArray.getFloat(i));
                                }
                                break;
                            }
                            case DOUBLE: {
                                for (long i = l; i < l4; ++i) {
                                    largeArray2.setDouble(i, largeArray.getDouble(i));
                                }
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid array type.");
                            }
                        }
                    }
                });
                threadArray[n].start();
            }
            try {
                for (n = 0; n < n2; ++n) {
                    threadArray[n].join();
                    threadArray[n] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                switch (largeArrayType) {
                    case BIT: 
                    case BYTE: {
                        for (l = 0L; l < l2; ++l) {
                            largeArray2.setByte(l, largeArray.getByte(l));
                        }
                        break;
                    }
                    case SHORT: {
                        for (l = 0L; l < l2; ++l) {
                            largeArray2.setShort(l, largeArray.getShort(l));
                        }
                        break;
                    }
                    case INT: {
                        for (l = 0L; l < l2; ++l) {
                            largeArray2.setInt(l, largeArray.getInt(l));
                        }
                        break;
                    }
                    case LONG: {
                        for (l = 0L; l < l2; ++l) {
                            largeArray2.setLong(l, largeArray.getLong(l));
                        }
                        break;
                    }
                    case FLOAT: {
                        for (l = 0L; l < l2; ++l) {
                            largeArray2.setFloat(l, largeArray.getFloat(l));
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (l = 0L; l < l2; ++l) {
                            largeArray2.setDouble(l, largeArray.getDouble(l));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array type.");
                    }
                }
            }
        }
        return largeArray2;
    }

    static {
        Object object = null;
        Exception exception = null;
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field field = clazz.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            object = field.get(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = illegalArgumentException;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            exception = noSuchFieldException;
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        UNSAFE = (Unsafe)object;
        if (UNSAFE == null) {
            throw new Error("Could not obtain access to sun.misc.Unsafe", exception);
        }
    }
}

