/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi3d;

import icy.canvas.IcyCanvas;
import icy.painter.Anchor3D;
import icy.painter.RectAnchor3D;
import icy.type.geom.BoxShape3D;
import icy.type.point.Point3D;
import icy.type.rectangle.Rectangle3D;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DRectShape;
import plugins.kernel.roi.roi2d.ROI2DShape;
import plugins.kernel.roi.roi3d.ROI3DZShape;

public abstract class ROI3DBoxShape
extends ROI3DZShape {
    public static final String ID_TOPLEFT = "top_left";
    public static final String ID_BOTTOMRIGHT = "bottom_right";
    protected final ROI3DBoxAnchor3D topLeft;
    protected final ROI3DBoxAnchor3D topRight;
    protected final ROI3DBoxAnchor3D bottomLeft;
    protected final ROI3DBoxAnchor3D bottomRight;
    protected boolean internalPositionSet;

    public ROI3DBoxShape(BoxShape3D shape) {
        super(shape);
        Rectangle3D bounds = shape.getBounds();
        this.topLeft = (ROI3DBoxAnchor3D)this.createAnchor((Point3D)new Point3D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getCenterZ()));
        this.topRight = (ROI3DBoxAnchor3D)this.createAnchor((Point3D)new Point3D.Double(bounds.getMaxX(), bounds.getMinY(), bounds.getCenterZ()));
        this.bottomLeft = (ROI3DBoxAnchor3D)this.createAnchor((Point3D)new Point3D.Double(bounds.getMinX(), bounds.getMaxY(), bounds.getCenterZ()));
        this.bottomRight = (ROI3DBoxAnchor3D)this.createAnchor((Point3D)new Point3D.Double(bounds.getMaxX(), bounds.getMaxY(), bounds.getCenterZ()));
        this.bottomRight.setSelected(true);
        this.internalPositionSet = false;
        this.addPoint(this.topLeft);
        this.addPoint(this.topRight);
        this.addPoint(this.bottomRight);
        this.addPoint(this.bottomLeft);
    }

    @Override
    protected Anchor3D createAnchor(Point3D pos) {
        return new ROI3DBoxAnchor3D(pos, this.getColor(), this.getFocusedColor());
    }

    protected BoxShape3D getBoxShape() {
        return (BoxShape3D)this.shape;
    }

    @Override
    public boolean canSetBounds() {
        return true;
    }

    @Override
    public void setBounds3D(Rectangle3D bounds) {
        this.beginUpdate();
        try {
            this.topLeft.setPosition(bounds.getMinX(), bounds.getMinY(), bounds.getCenterZ());
            this.bottomRight.setPosition(bounds.getMaxX(), bounds.getMaxY(), bounds.getCenterZ());
            this.closeZ.setPosition(bounds.getCenterX(), bounds.getCenterY(), bounds.getMinZ());
            this.farZ.setPosition(bounds.getCenterX(), bounds.getCenterY(), bounds.getMaxZ());
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean canAddPoint() {
        return false;
    }

    @Override
    public boolean canRemovePoint() {
        return false;
    }

    @Override
    protected boolean removePoint(IcyCanvas canvas, Anchor3D pt) {
        return false;
    }

    @Override
    public void controlPointPositionChanged(Anchor3D source) {
        if (this.internalPositionSet) {
            return;
        }
        this.internalPositionSet = true;
        this.beginUpdate();
        try {
            if (source == this.topLeft) {
                this.bottomLeft.setX(this.topLeft.getX());
                this.bottomLeft.setZ(this.topLeft.getZ());
                this.topRight.setY(this.topLeft.getY());
                this.topRight.setZ(this.topLeft.getZ());
            } else if (source == this.topRight) {
                this.bottomRight.setX(this.topRight.getX());
                this.bottomRight.setZ(this.topRight.getZ());
                this.topLeft.setY(this.topRight.getY());
                this.topLeft.setZ(this.topRight.getZ());
            } else if (source == this.bottomLeft) {
                this.topLeft.setX(this.bottomLeft.getX());
                this.topLeft.setZ(this.bottomLeft.getZ());
                this.bottomRight.setY(this.bottomLeft.getY());
                this.bottomRight.setZ(this.bottomLeft.getZ());
            } else if (source == this.bottomRight) {
                this.topRight.setX(this.bottomRight.getX());
                this.topRight.setZ(this.bottomRight.getZ());
                this.bottomLeft.setY(this.bottomRight.getY());
                this.bottomLeft.setZ(this.bottomRight.getZ());
            }
        }
        finally {
            this.endUpdate();
            this.internalPositionSet = false;
        }
        super.controlPointPositionChanged(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translate(double dx, double dy, double dz) {
        this.beginUpdate();
        try {
            this.topLeft.translate(dx, dy, dz);
            this.bottomRight.translate(dx, dy, dz);
            super.translate(dx, dy, dz);
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                boolean bl = false;
                return bl;
            }
            this.topLeft.loadPositionFromXML(XMLUtil.getElement(node, ID_TOPLEFT));
            this.bottomRight.loadPositionFromXML(XMLUtil.getElement(node, ID_BOTTOMRIGHT));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        this.topLeft.savePositionToXML(XMLUtil.setElement(node, ID_TOPLEFT));
        this.bottomRight.savePositionToXML(XMLUtil.setElement(node, ID_BOTTOMRIGHT));
        return true;
    }

    @Override
    protected void updateShape2DROI() {
        ROI2DShape r = this.getShape2DROI();
        if (r instanceof ROI2DRectShape) {
            ROI2DRectShape roi = (ROI2DRectShape)r;
            roi.setBounds2D(this.getBounds3D().toRectangle2D());
        }
    }

    @Override
    protected void updateFromShape2DROI() {
        if (this.topLeft == null || this.bottomRight == null) {
            return;
        }
        ROI2DShape r = this.getShape2DROI();
        if (r instanceof ROI2DRectShape) {
            Rectangle2D rect = ((ROI2DRectShape)r).getBounds2D();
            this.beginUpdate();
            try {
                this.topLeft.setPosition(rect.getMinX(), rect.getMinY(), this.topLeft.getZ());
                this.bottomRight.setPosition(rect.getMaxX(), rect.getMaxY(), this.bottomRight.getZ());
            }
            finally {
                this.endUpdate();
            }
        }
    }

    @Override
    protected void updateShapeInternal() {
        if (this.topLeft == null || this.bottomRight == null) {
            return;
        }
        Point3D pt1 = this.topLeft.getPosition();
        Point3D pt2 = this.bottomRight.getPosition();
        pt1.setZ(this.closeZ.getZ());
        pt2.setZ(this.farZ.getZ());
        this.getBoxShape().setFrameFromDiagonal(pt1, pt2);
        this.boundsInvalid = true;
        Rectangle3D bounds = this.getBounds3D();
        this.closeZ.setX(bounds.getCenterX());
        this.closeZ.setY(bounds.getCenterY());
        this.farZ.setX(bounds.getCenterX());
        this.farZ.setY(bounds.getCenterY());
        this.topLeft.setZ(bounds.getCenterZ());
        this.bottomRight.setZ(bounds.getCenterZ());
    }

    protected class ROI3DBoxAnchor3D
    extends RectAnchor3D {
        public ROI3DBoxAnchor3D(Point3D position, Color color, Color selectedColor) {
            super(position, color, selectedColor);
            this.setFixedZ(true);
        }

        @Override
        protected Anchor3D getOppositePoint() {
            if (this == ROI3DBoxShape.this.topLeft) {
                return ROI3DBoxShape.this.bottomRight;
            }
            if (this == ROI3DBoxShape.this.topRight) {
                return ROI3DBoxShape.this.bottomLeft;
            }
            if (this == ROI3DBoxShape.this.bottomLeft) {
                return ROI3DBoxShape.this.topRight;
            }
            return ROI3DBoxShape.this.topLeft;
        }
    }
}

