/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.main;

import icy.common.listener.AcceptListener;
import icy.common.listener.weak.WeakListener;
import icy.gui.frame.IcyFrame;
import icy.gui.inspector.InspectorPanel;
import icy.gui.inspector.LayersPanel;
import icy.gui.inspector.RoisPanel;
import icy.gui.main.ActiveSequenceListener;
import icy.gui.main.ActiveViewerListener;
import icy.gui.main.FocusedSequenceListener;
import icy.gui.main.FocusedViewerListener;
import icy.gui.main.GlobalOverlayListener;
import icy.gui.main.GlobalPluginListener;
import icy.gui.main.GlobalROIListener;
import icy.gui.main.GlobalSequenceListener;
import icy.gui.main.GlobalViewerListener;
import icy.gui.main.IcyDesktopPane;
import icy.gui.main.MainEvent;
import icy.gui.main.MainFrame;
import icy.gui.main.MainInterface;
import icy.gui.main.MainListener;
import icy.gui.main.TaskFrameManager;
import icy.gui.menu.ApplicationMenu;
import icy.gui.menu.ROITask;
import icy.gui.menu.ToolRibbonTask;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerAdapter;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.image.IcyBufferedImage;
import icy.image.lut.LUT;
import icy.imagej.ImageJWrapper;
import icy.main.Icy;
import icy.painter.Overlay;
import icy.painter.OverlayWrapper;
import icy.painter.Painter;
import icy.plugin.abstract_.Plugin;
import icy.preferences.GeneralPreferences;
import icy.preferences.IcyPreferences;
import icy.preferences.XMLPreferences;
import icy.roi.ROI;
import icy.search.SearchEngine;
import icy.sequence.Sequence;
import icy.sequence.SequenceAdapter;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.swimmingPool.SwimmingPool;
import icy.system.thread.ThreadUtil;
import icy.undo.IcyUndoManager;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.event.EventListenerList;

public class MainInterfaceGui
implements MainInterface {
    private final EventListenerList listeners = new EventListenerList();
    private final List<MainListener> mainListeners = new ArrayList<MainListener>();
    private final List<GlobalViewerListener> globalViewerListeners = new ArrayList<GlobalViewerListener>();
    private final List<GlobalSequenceListener> globalSequenceListeners = new ArrayList<GlobalSequenceListener>();
    private final List<GlobalROIListener> globalROIListeners = new ArrayList<GlobalROIListener>();
    private final List<GlobalOverlayListener> globalOverlayListeners = new ArrayList<GlobalOverlayListener>();
    private final ViewerListener activeViewerListener;
    private final SequenceListener sequenceListener;
    private final List<Viewer> viewers = new ArrayList<Viewer>();
    private final List<Sequence> sequences = new ArrayList<Sequence>();
    private final List<WeakReference<Plugin>> activePlugins = new ArrayList<WeakReference<Plugin>>();
    private final SwimmingPool swimmingPool = new SwimmingPool();
    private final TaskFrameManager taskFrameManager = new TaskFrameManager();
    MainFrame mainFrame = null;
    Viewer previousActiveViewer = null;
    Viewer activeViewer = null;
    Sequence activeSequence = null;

    public MainInterfaceGui() {
        this.activeViewerListener = new ViewerAdapter(){

            @Override
            public void viewerChanged(ViewerEvent event) {
                MainInterfaceGui.this.activeViewerChanged(event);
            }
        };
        this.sequenceListener = new SequenceAdapter(){

            @Override
            public void sequenceChanged(SequenceEvent event) {
                MainInterfaceGui.this.sequenceChanged(event);
            }
        };
    }

    @Override
    public void init() {
        this.mainFrame = new MainFrame();
        this.mainFrame.init();
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Icy.exit(false);
            }
        });
        this.taskFrameManager.init();
    }

    @Override
    public boolean isHeadLess() {
        return false;
    }

    @Override
    public void addSequence(Sequence sequence) {
        if (sequence != null) {
            final Sequence seq = sequence;
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new Viewer(seq);
                }
            });
        }
    }

    @Override
    public ArrayList<JFrame> getExternalFrames() {
        Window[] windows;
        ArrayList<JFrame> result = new ArrayList<JFrame>();
        for (Window w : windows = Window.getWindows()) {
            if (!(w instanceof JFrame)) continue;
            result.add((JFrame)w);
        }
        return result;
    }

    @Override
    public ArrayList<JInternalFrame> getInternalFrames() {
        if (this.mainFrame == null) {
            return new ArrayList<JInternalFrame>();
        }
        return this.mainFrame.getInternalFrames();
    }

    @Override
    public XMLPreferences getPreferences() {
        return IcyPreferences.applicationRoot();
    }

    @Override
    public InspectorPanel getInspector() {
        if (this.mainFrame == null) {
            return null;
        }
        return this.mainFrame.getInspector();
    }

    @Override
    public RoisPanel getRoisPanel() {
        if (this.mainFrame == null) {
            return null;
        }
        InspectorPanel inspector = this.mainFrame.getInspector();
        if (inspector == null) {
            return null;
        }
        return inspector.getRoisPanel();
    }

    @Override
    public LayersPanel getLayersPanel() {
        if (this.mainFrame == null) {
            return null;
        }
        InspectorPanel inspector = this.mainFrame.getInspector();
        if (inspector == null) {
            return null;
        }
        return inspector.getLayersPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Plugin> getActivePlugins() {
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        List<WeakReference<Plugin>> list = this.activePlugins;
        synchronized (list) {
            for (WeakReference<Plugin> ref : this.activePlugins) {
                Plugin plugin = (Plugin)ref.get();
                if (plugin == null) continue;
                result.add(plugin);
            }
        }
        return result;
    }

    @Override
    public LUT getActiveLUT() {
        if (this.activeViewer != null) {
            return this.activeViewer.getLut();
        }
        return null;
    }

    @Override
    public Viewer getActiveViewer() {
        return this.activeViewer;
    }

    @Override
    public Sequence getActiveSequence() {
        return this.activeSequence;
    }

    @Override
    public IcyBufferedImage getActiveImage() {
        if (this.activeViewer != null) {
            return this.activeViewer.getCurrentImage();
        }
        return null;
    }

    @Override
    @Deprecated
    public Viewer getFocusedViewer() {
        return this.getActiveViewer();
    }

    @Override
    @Deprecated
    public Sequence getFocusedSequence() {
        return this.getActiveSequence();
    }

    @Override
    @Deprecated
    public IcyBufferedImage getFocusedImage() {
        return this.getActiveImage();
    }

    @Override
    public IcyUndoManager getUndoManager() {
        if (this.activeSequence != null) {
            return this.activeSequence.getUndoManager();
        }
        return null;
    }

    @Override
    public boolean undo() {
        if (this.activeSequence != null) {
            return this.activeSequence.undo();
        }
        return false;
    }

    @Override
    public boolean redo() {
        if (this.activeSequence != null) {
            return this.activeSequence.redo();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Viewer> getViewers() {
        List<Viewer> list = this.viewers;
        synchronized (list) {
            return new ArrayList<Viewer>(this.viewers);
        }
    }

    @Override
    public synchronized void setActiveViewer(Viewer viewer) {
        if (this.activeViewer == viewer) {
            return;
        }
        if (this.activeViewer != null) {
            this.activeViewer.removeListener(this.activeViewerListener);
            try {
                this.activeViewer.getInternalFrame().setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.previousActiveViewer = this.activeViewer;
        this.activeViewer = viewer;
        if (this.activeViewer != null) {
            this.activeViewer.addListener(this.activeViewerListener);
        }
        this.viewerActivationChanged(this.previousActiveViewer, this.activeViewer);
    }

    @Override
    @Deprecated
    public synchronized void setFocusedViewer(Viewer viewer) {
        this.setActiveViewer(viewer);
    }

    @Override
    public synchronized void addToDesktopPane(JInternalFrame internalFrame) {
        this.getDesktopPane().add((Component)internalFrame, JLayeredPane.DEFAULT_LAYER);
    }

    @Override
    public IcyDesktopPane getDesktopPane() {
        if (this.mainFrame == null) {
            return null;
        }
        return this.mainFrame.getDesktopPane();
    }

    @Override
    public ApplicationMenu getApplicationMenu() {
        if (this.mainFrame == null) {
            return null;
        }
        return this.mainFrame.getApplicationMenu();
    }

    @Override
    public TaskFrameManager getTaskWindowManager() {
        return this.taskFrameManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WeakReference<Plugin> getPluginReference(Plugin plugin) {
        List<WeakReference<Plugin>> list = this.activePlugins;
        synchronized (list) {
            for (WeakReference<Plugin> ref : this.activePlugins) {
                if (ref.get() != plugin) continue;
                return ref;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public void registerExternalFrame(JFrame frame) {
    }

    @Override
    @Deprecated
    public void unRegisterExternalFrame(JFrame frame) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerPlugin(Plugin plugin) {
        List<WeakReference<Plugin>> list = this.activePlugins;
        synchronized (list) {
            this.activePlugins.add(new WeakReference<Plugin>(plugin));
        }
        this.pluginStarted(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unRegisterPlugin(Plugin plugin) {
        WeakReference<Plugin> ref = this.getPluginReference(plugin);
        List<WeakReference<Plugin>> list = this.activePlugins;
        synchronized (list) {
            if (ref != null) {
                this.activePlugins.remove(ref);
            }
        }
        this.pluginEnded(plugin);
    }

    @Override
    public synchronized void registerViewer(Viewer viewer) {
        if (viewer == null) {
            return;
        }
        this.viewerOpened(viewer);
    }

    @Override
    public synchronized void unRegisterViewer(Viewer viewer) {
        if (viewer == null) {
            return;
        }
        this.viewerClosed(viewer);
        if (this.viewers.isEmpty()) {
            this.setActiveViewer(null);
        } else {
            IcyFrame frame = IcyFrame.findIcyFrame(this.getDesktopPane().getSelectedFrame());
            if (frame instanceof Viewer) {
                ((Viewer)frame).requestFocus();
            } else if (this.activeViewer == viewer) {
                if (this.previousActiveViewer != null) {
                    this.setActiveViewer(this.previousActiveViewer);
                    this.previousActiveViewer = null;
                } else {
                    this.setActiveViewer(this.viewers.get(this.viewers.size() - 1));
                }
            }
        }
    }

    @Override
    @Deprecated
    public MainFrame getFrame() {
        return this.getMainFrame();
    }

    @Override
    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    @Override
    public SearchEngine getSearchEngine() {
        return this.mainFrame.getSearchBar().getSearchEngine();
    }

    @Override
    public void closeSequence(Sequence sequence) {
        for (Viewer v : this.getViewers()) {
            if (v.getSequence() != sequence) continue;
            v.close();
        }
    }

    @Override
    @Deprecated
    public void closeViewersOfSequence(Sequence sequence) {
        this.closeSequence(sequence);
    }

    @Override
    public synchronized void closeAllViewers() {
        for (Viewer viewer : this.getViewers()) {
            viewer.close();
        }
    }

    @Override
    public Viewer getFirstViewerContaining(ROI roi) {
        return this.getFirstViewer(this.getFirstSequenceContaining(roi));
    }

    @Override
    @Deprecated
    public Viewer getFirstViewerContaining(Painter painter) {
        return this.getFirstViewer(this.getFirstSequenceContaining(painter));
    }

    @Override
    public Viewer getFirstViewerContaining(Overlay overlay) {
        return this.getFirstViewer(this.getFirstSequenceContaining(overlay));
    }

    @Override
    public Viewer getFirstViewer(Sequence sequence) {
        if (sequence != null) {
            for (Viewer viewer : this.getViewers()) {
                if (viewer.getSequence() != sequence) continue;
                return viewer;
            }
        }
        return null;
    }

    @Override
    public ArrayList<Viewer> getViewers(Sequence sequence) {
        ArrayList<Viewer> result = new ArrayList<Viewer>();
        for (Viewer v : this.getViewers()) {
            if (v.getSequence() != sequence) continue;
            result.add(v);
        }
        return result;
    }

    @Override
    public boolean isUniqueViewer(Viewer viewer) {
        ArrayList<Viewer> viewers = this.getViewers(viewer.getSequence());
        return viewers.size() == 1 && viewers.get(0) == viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Sequence> getSequences() {
        List<Sequence> list = this.sequences;
        synchronized (list) {
            return new ArrayList<Sequence>(this.sequences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Sequence> getSequences(String name) {
        ArrayList<Sequence> result = new ArrayList<Sequence>();
        List<Viewer> list = this.viewers;
        synchronized (list) {
            for (Viewer viewer : this.viewers) {
                Sequence sequence = viewer.getSequence();
                if (result.contains(sequence) || !StringUtil.equals(name, sequence.getName())) continue;
                result.add(sequence);
            }
        }
        return result;
    }

    @Override
    public boolean isOpened(Sequence sequence) {
        return this.getSequences().contains(sequence);
    }

    @Override
    @Deprecated
    public Sequence getFirstSequencesContaining(ROI roi) {
        return this.getFirstSequenceContaining(roi);
    }

    @Override
    public Sequence getFirstSequenceContaining(ROI roi) {
        for (Sequence seq : this.getSequences()) {
            if (!seq.contains(roi)) continue;
            return seq;
        }
        return null;
    }

    @Override
    @Deprecated
    public Sequence getFirstSequencesContaining(Painter painter) {
        return this.getFirstSequenceContaining(painter);
    }

    @Override
    @Deprecated
    public Sequence getFirstSequenceContaining(Painter painter) {
        for (Sequence seq : this.getSequences()) {
            if (!seq.contains(painter)) continue;
            return seq;
        }
        return null;
    }

    @Override
    public Sequence getFirstSequenceContaining(Overlay overlay) {
        for (Sequence seq : this.getSequences()) {
            if (!seq.contains(overlay)) continue;
            return seq;
        }
        return null;
    }

    @Override
    public ArrayList<Sequence> getSequencesContaining(ROI roi) {
        ArrayList<Sequence> result = this.getSequences();
        for (int i = result.size() - 1; i >= 0; --i) {
            if (result.get(i).contains(roi)) continue;
            result.remove(i);
        }
        return result;
    }

    @Override
    @Deprecated
    public ArrayList<Sequence> getSequencesContaining(Painter painter) {
        ArrayList<Sequence> result = this.getSequences();
        for (int i = result.size() - 1; i >= 0; --i) {
            if (result.get(i).contains(painter)) continue;
            result.remove(i);
        }
        return result;
    }

    @Override
    public List<Sequence> getSequencesContaining(Overlay overlay) {
        ArrayList<Sequence> result = this.getSequences();
        for (int i = result.size() - 1; i >= 0; --i) {
            if (result.get(i).contains(overlay)) continue;
            result.remove(i);
        }
        return result;
    }

    @Override
    public ArrayList<ROI> getROIs() {
        HashSet<ROI> result = new HashSet<ROI>();
        for (Sequence seq : this.getSequences()) {
            for (ROI roi : seq.getROISet()) {
                result.add(roi);
            }
        }
        return new ArrayList<ROI>(result);
    }

    @Override
    @Deprecated
    public ROI getROI(Painter painter) {
        if (painter instanceof Overlay) {
            return this.getROI((Overlay)painter);
        }
        return null;
    }

    @Override
    public ROI getROI(Overlay overlay) {
        ArrayList<ROI> rois = this.getROIs();
        for (ROI roi : rois) {
            if (roi.getOverlay() != overlay) continue;
            return roi;
        }
        return null;
    }

    @Override
    @Deprecated
    public ArrayList<Painter> getPainters() {
        HashSet<Painter> result = new HashSet<Painter>();
        for (Sequence seq : this.getSequences()) {
            result.addAll(seq.getPainterSet());
        }
        return new ArrayList<Painter>();
    }

    @Override
    public List<Overlay> getOverlays() {
        HashSet<Overlay> result = new HashSet<Overlay>();
        for (Sequence seq : this.getSequences()) {
            result.addAll(seq.getOverlaySet());
        }
        return new ArrayList<Overlay>();
    }

    @Override
    public SwimmingPool getSwimmingPool() {
        return this.swimmingPool;
    }

    @Override
    public ImageJWrapper getImageJ() {
        if (this.mainFrame == null) {
            return null;
        }
        return this.mainFrame.getMainRibbon().getImageJ();
    }

    @Override
    public String getSelectedTool() {
        if (this.mainFrame == null) {
            return null;
        }
        return this.getROIRibbonTask().getSelected();
    }

    @Override
    public void setSelectedTool(String command) {
        if (this.mainFrame != null) {
            this.getROIRibbonTask().setSelected(command);
        }
    }

    @Override
    public ROITask getROIRibbonTask() {
        if (this.mainFrame == null) {
            return null;
        }
        return this.mainFrame.getMainRibbon().getROIRibbonTask();
    }

    @Override
    @Deprecated
    public ToolRibbonTask getToolRibbon() {
        if (this.mainFrame == null) {
            return null;
        }
        return this.mainFrame.getMainRibbon().getToolRibbon();
    }

    @Override
    public boolean isAlwaysOnTop() {
        if (this.mainFrame == null) {
            return false;
        }
        return this.mainFrame.isAlwaysOnTop();
    }

    @Override
    public void setAlwaysOnTop(boolean value) {
        if (this.mainFrame != null) {
            this.mainFrame.setAlwaysOnTop(value);
        }
    }

    @Override
    public boolean isDetachedMode() {
        if (this.mainFrame == null) {
            return false;
        }
        return this.mainFrame.isDetachedMode();
    }

    @Override
    public void setDetachedMode(boolean value) {
        if (this.mainFrame != null) {
            this.mainFrame.setDetachedMode(value);
        }
    }

    @Override
    @Deprecated
    public synchronized void addListener(MainListener listener) {
        if (listener != null) {
            this.mainListeners.add(listener);
        }
    }

    @Override
    @Deprecated
    public synchronized void removeListener(MainListener listener) {
        this.mainListeners.remove(listener);
    }

    @Override
    public synchronized void addGlobalViewerListener(GlobalViewerListener listener) {
        if (listener != null) {
            this.globalViewerListeners.add(listener);
        }
    }

    @Override
    public synchronized void removeGlobalViewerListener(GlobalViewerListener listener) {
        this.globalViewerListeners.remove(listener);
    }

    @Override
    public synchronized void addGlobalSequenceListener(GlobalSequenceListener listener) {
        if (listener != null) {
            this.globalSequenceListeners.add(listener);
        }
    }

    @Override
    public synchronized void removeGlobalSequenceListener(GlobalSequenceListener listener) {
        this.globalSequenceListeners.remove(listener);
    }

    @Override
    public synchronized void addGlobalROIListener(GlobalROIListener listener) {
        if (listener != null) {
            this.globalROIListeners.add(listener);
        }
    }

    @Override
    public synchronized void removeGlobalROIListener(GlobalROIListener listener) {
        this.globalROIListeners.remove(listener);
    }

    @Override
    public synchronized void addGlobalOverlayListener(GlobalOverlayListener listener) {
        if (listener != null) {
            this.globalOverlayListeners.add(listener);
        }
    }

    @Override
    public synchronized void removeGlobalOverlayListener(GlobalOverlayListener listener) {
        this.globalOverlayListeners.remove(listener);
    }

    @Override
    public synchronized void addGlobalPluginListener(GlobalPluginListener listener) {
        if (listener != null) {
            this.listeners.add(GlobalPluginListener.class, listener);
        }
    }

    @Override
    public synchronized void removeGlobalPluginListener(GlobalPluginListener listener) {
        this.listeners.remove(GlobalPluginListener.class, listener);
    }

    @Override
    public synchronized void addCanExitListener(AcceptListener listener) {
        if (listener != null) {
            this.listeners.add(WeakAcceptListener.class, new WeakAcceptListener(listener));
        }
    }

    @Override
    public synchronized void removeCanExitListener(AcceptListener listener) {
        for (WeakAcceptListener l : (WeakAcceptListener[])this.listeners.getListeners(WeakAcceptListener.class)) {
            if (listener != l.getListener()) continue;
            this.internalRemoveCanExitListener(l);
        }
    }

    public synchronized void internalRemoveCanExitListener(WeakAcceptListener listener) {
        this.listeners.remove(WeakAcceptListener.class, listener);
    }

    @Override
    @Deprecated
    public synchronized void addFocusedViewerListener(FocusedViewerListener listener) {
        this.listeners.add(FocusedViewerListener.class, listener);
    }

    @Override
    @Deprecated
    public synchronized void removeFocusedViewerListener(FocusedViewerListener listener) {
        this.listeners.remove(FocusedViewerListener.class, listener);
    }

    @Override
    @Deprecated
    public synchronized void addFocusedSequenceListener(FocusedSequenceListener listener) {
        this.listeners.add(FocusedSequenceListener.class, listener);
    }

    @Override
    @Deprecated
    public synchronized void removeFocusedSequenceListener(FocusedSequenceListener listener) {
        this.listeners.remove(FocusedSequenceListener.class, listener);
    }

    @Override
    public synchronized void addActiveViewerListener(ActiveViewerListener listener) {
        this.listeners.add(ActiveViewerListener.class, listener);
    }

    @Override
    public synchronized void removeActiveViewerListener(ActiveViewerListener listener) {
        this.listeners.remove(ActiveViewerListener.class, listener);
    }

    @Override
    public synchronized void addActiveSequenceListener(ActiveSequenceListener listener) {
        this.listeners.add(ActiveSequenceListener.class, listener);
    }

    @Override
    public synchronized void removeActiveSequenceListener(ActiveSequenceListener listener) {
        this.listeners.remove(ActiveSequenceListener.class, listener);
    }

    private void firePluginStartedEvent(Plugin plugin) {
        for (GlobalPluginListener listener : (GlobalPluginListener[])this.listeners.getListeners(GlobalPluginListener.class)) {
            listener.pluginStarted(plugin);
        }
        MainEvent event = new MainEvent(MainEvent.MainEventSourceType.PLUGIN, MainEvent.MainEventType.OPENED, plugin);
        for (MainListener listener : new ArrayList<MainListener>(this.mainListeners)) {
            listener.pluginOpened(event);
        }
    }

    private void firePluginEndedEvent(Plugin plugin) {
        for (GlobalPluginListener listener : (GlobalPluginListener[])this.listeners.getListeners(GlobalPluginListener.class)) {
            listener.pluginEnded(plugin);
        }
        MainEvent event = new MainEvent(MainEvent.MainEventSourceType.PLUGIN, MainEvent.MainEventType.CLOSED, plugin);
        for (MainListener listener : new ArrayList<MainListener>(this.mainListeners)) {
            listener.pluginClosed(event);
        }
    }

    private void fireViewerOpenedEvent(Viewer viewer) {
        for (GlobalViewerListener listener : new ArrayList<GlobalViewerListener>(this.globalViewerListeners)) {
            listener.viewerOpened(viewer);
        }
        MainEvent event = new MainEvent(MainEvent.MainEventSourceType.VIEWER, MainEvent.MainEventType.OPENED, viewer);
        for (MainListener listener : new ArrayList<MainListener>(this.mainListeners)) {
            listener.viewerOpened(event);
        }
    }

    private void fireViewerClosedEvent(Viewer viewer) {
        for (GlobalViewerListener listener : new ArrayList<GlobalViewerListener>(this.globalViewerListeners)) {
            listener.viewerClosed(viewer);
        }
        MainEvent event = new MainEvent(MainEvent.MainEventSourceType.VIEWER, MainEvent.MainEventType.CLOSED, viewer);
        for (MainListener listener : new ArrayList<MainListener>(this.mainListeners)) {
            listener.viewerClosed(event);
        }
    }

    private void fireViewerDeactivatedEvent(Viewer viewer) {
        for (ActiveViewerListener listener : (ActiveViewerListener[])this.listeners.getListeners(ActiveViewerListener.class)) {
            listener.viewerDeactivated(viewer);
        }
    }

    private void fireViewerActivatedEvent(Viewer viewer) {
        for (ActiveViewerListener listener : (ActiveViewerListener[])this.listeners.getListeners(ActiveViewerListener.class)) {
            listener.viewerActivated(viewer);
        }
        MainEvent event = new MainEvent(MainEvent.MainEventSourceType.VIEWER, MainEvent.MainEventType.FOCUSED, viewer);
        for (MainListener listener : new ArrayList<MainListener>(this.mainListeners)) {
            listener.viewerFocused(event);
        }
        for (FocusedViewerListener listener : (FocusedViewerListener[])this.listeners.getListeners(FocusedViewerListener.class)) {
            listener.focusChanged(viewer);
        }
    }

    private void fireSequenceOpenedEvent(Sequence sequence) {
        for (GlobalSequenceListener listener : new ArrayList<GlobalSequenceListener>(this.globalSequenceListeners)) {
            listener.sequenceOpened(sequence);
        }
        MainEvent event = new MainEvent(MainEvent.MainEventSourceType.SEQUENCE, MainEvent.MainEventType.OPENED, sequence);
        for (MainListener listener : new ArrayList<MainListener>(this.mainListeners)) {
            listener.sequenceOpened(event);
        }
    }

    private void fireSequenceClosedEvent(Sequence sequence) {
        for (GlobalSequenceListener listener : new ArrayList<GlobalSequenceListener>(this.globalSequenceListeners)) {
            listener.sequenceClosed(sequence);
        }
        MainEvent event = new MainEvent(MainEvent.MainEventSourceType.SEQUENCE, MainEvent.MainEventType.CLOSED, sequence);
        for (MainListener listener : new ArrayList<MainListener>(this.mainListeners)) {
            listener.sequenceClosed(event);
        }
    }

    private void fireSequenceDeactivatedEvent(Sequence sequence) {
        for (ActiveSequenceListener listener : (ActiveSequenceListener[])this.listeners.getListeners(ActiveSequenceListener.class)) {
            listener.sequenceDeactivated(sequence);
        }
    }

    private void fireSequenceActivatedEvent(Sequence sequence) {
        for (ActiveSequenceListener listener : (ActiveSequenceListener[])this.listeners.getListeners(ActiveSequenceListener.class)) {
            listener.sequenceActivated(sequence);
        }
        MainEvent event = new MainEvent(MainEvent.MainEventSourceType.SEQUENCE, MainEvent.MainEventType.FOCUSED, sequence);
        for (MainListener listener : new ArrayList<MainListener>(this.mainListeners)) {
            listener.sequenceFocused(event);
        }
        for (FocusedSequenceListener listener : (FocusedSequenceListener[])this.listeners.getListeners(FocusedSequenceListener.class)) {
            listener.focusChanged(sequence);
        }
    }

    private void fireRoiAddedEvent(ROI roi) {
        for (GlobalROIListener listener : new ArrayList<GlobalROIListener>(this.globalROIListeners)) {
            listener.roiAdded(roi);
        }
        MainEvent event = new MainEvent(MainEvent.MainEventSourceType.ROI, MainEvent.MainEventType.ADDED, roi);
        for (MainListener listener : new ArrayList<MainListener>(this.mainListeners)) {
            listener.roiAdded(event);
        }
    }

    private void fireRoiRemovedEvent(ROI roi) {
        for (GlobalROIListener listener : new ArrayList<GlobalROIListener>(this.globalROIListeners)) {
            listener.roiRemoved(roi);
        }
        MainEvent event = new MainEvent(MainEvent.MainEventSourceType.ROI, MainEvent.MainEventType.REMOVED, roi);
        for (MainListener listener : new ArrayList<MainListener>(this.mainListeners)) {
            listener.roiRemoved(event);
        }
    }

    private void fireOverlayAddedEvent(Overlay overlay) {
        for (GlobalOverlayListener listener : new ArrayList<GlobalOverlayListener>(this.globalOverlayListeners)) {
            listener.overlayAdded(overlay);
        }
        Painter painter = overlay instanceof OverlayWrapper ? ((OverlayWrapper)overlay).getPainter() : overlay;
        MainEvent event = new MainEvent(MainEvent.MainEventSourceType.PAINTER, MainEvent.MainEventType.ADDED, painter);
        for (MainListener listener : new ArrayList<MainListener>(this.mainListeners)) {
            listener.painterAdded(event);
        }
    }

    private void fireOverlayRemovedEvent(Overlay overlay) {
        for (GlobalOverlayListener listener : new ArrayList<GlobalOverlayListener>(this.globalOverlayListeners)) {
            listener.overlayRemoved(overlay);
        }
        Painter painter = overlay instanceof OverlayWrapper ? ((OverlayWrapper)overlay).getPainter() : overlay;
        MainEvent event = new MainEvent(MainEvent.MainEventSourceType.PAINTER, MainEvent.MainEventType.REMOVED, painter);
        for (MainListener listener : new ArrayList<MainListener>(this.mainListeners)) {
            listener.painterRemoved(event);
        }
    }

    private void fireActiveViewerChangedEvent(ViewerEvent event) {
        for (ActiveViewerListener activeViewerListener : (ActiveViewerListener[])this.listeners.getListeners(ActiveViewerListener.class)) {
            activeViewerListener.activeViewerChanged(event);
        }
        for (EventListener eventListener : (FocusedViewerListener[])this.listeners.getListeners(FocusedViewerListener.class)) {
            eventListener.focusedViewerChanged(event);
        }
    }

    private void fireActiveSequenceChangedEvent(SequenceEvent event) {
        for (ActiveSequenceListener activeSequenceListener : (ActiveSequenceListener[])this.listeners.getListeners(ActiveSequenceListener.class)) {
            activeSequenceListener.activeSequenceChanged(event);
        }
        for (EventListener eventListener : (FocusedSequenceListener[])this.listeners.getListeners(FocusedSequenceListener.class)) {
            eventListener.focusedSequenceChanged(event);
        }
    }

    @Override
    public boolean canExitExternal() {
        for (WeakAcceptListener listener : (WeakAcceptListener[])this.listeners.getListeners(WeakAcceptListener.class)) {
            try {
                if (listener.accept((Object)this.mainFrame)) continue;
                return false;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    @Deprecated
    public void beginUpdate() {
    }

    @Override
    @Deprecated
    public void endUpdate() {
    }

    @Override
    @Deprecated
    public boolean isUpdating() {
        return false;
    }

    private void pluginStarted(Plugin plugin) {
        this.firePluginStartedEvent(plugin);
    }

    private void pluginEnded(Plugin plugin) {
        this.firePluginEndedEvent(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void viewerOpened(Viewer viewer) {
        Sequence sequence = viewer.getSequence();
        boolean opened = true;
        List<Viewer> list = this.viewers;
        synchronized (list) {
            if (sequence != null) {
                for (Viewer v : this.viewers) {
                    if (v.getSequence() != sequence) continue;
                    opened = false;
                    break;
                }
            }
            this.viewers.add(viewer);
        }
        if (sequence != null && opened) {
            this.sequenceOpened(sequence);
        }
        this.fireViewerOpenedEvent(viewer);
    }

    private void viewerActivationChanged(Viewer oldActive, Viewer newActive) {
        Sequence sequence;
        if (newActive != null) {
            ImageJWrapper ij = Icy.getMainInterface().getImageJ();
            if (ij != null) {
                ij.setActiveImage(null);
            }
            sequence = newActive.getSequence();
        } else {
            sequence = null;
        }
        Sequence oldActiveSequence = this.activeSequence;
        if (oldActiveSequence != sequence) {
            this.activeSequence = sequence;
            this.sequenceActivationChanged(oldActiveSequence, sequence);
        }
        this.fireViewerDeactivatedEvent(oldActive);
        this.fireViewerActivatedEvent(newActive);
    }

    void activeViewerChanged(ViewerEvent event) {
        if (event.getSource() == this.activeViewer) {
            this.fireActiveViewerChangedEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void viewerClosed(Viewer viewer) {
        LUT lut = viewer.getLut();
        if (viewer == this.activeViewer) {
            viewer.removeListener(this.activeViewerListener);
        }
        List<Viewer> list = this.viewers;
        synchronized (list) {
            this.viewers.remove(viewer);
        }
        this.fireViewerClosedEvent(viewer);
        Sequence sequence = viewer.getSequence();
        if (sequence != null && this.getViewers(sequence).isEmpty()) {
            this.sequenceClosed(sequence, lut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sequenceOpened(Sequence sequence) {
        Iterator<Overlay> iterator = this.sequences;
        synchronized (iterator) {
            this.sequences.add(sequence);
        }
        sequence.addListener(this.sequenceListener);
        this.fireSequenceOpenedEvent(sequence);
        for (ROI roi : sequence.getROIs()) {
            this.checkRoiAdded(roi, false);
        }
        for (Overlay overlay : sequence.getOverlays()) {
            this.checkOverlayAdded(overlay, false);
        }
    }

    private void sequenceActivationChanged(Sequence oldActive, Sequence newActive) {
        this.fireSequenceDeactivatedEvent(oldActive);
        this.fireSequenceActivatedEvent(newActive);
    }

    void sequenceChanged(SequenceEvent event) {
        Sequence sequence = event.getSequence();
        if (this.isOpened(sequence)) {
            block0 : switch (event.getSourceType()) {
                case SEQUENCE_ROI: {
                    switch (event.getType()) {
                        case ADDED: {
                            this.checkRoiAdded((ROI)event.getSource(), false);
                            break;
                        }
                        case REMOVED: {
                            this.checkRoiRemoved((ROI)event.getSource(), false);
                        }
                    }
                    break;
                }
                case SEQUENCE_OVERLAY: {
                    switch (event.getType()) {
                        case ADDED: {
                            this.checkOverlayAdded((Overlay)event.getSource(), false);
                            break block0;
                        }
                        case REMOVED: {
                            this.checkOverlayRemoved((Overlay)event.getSource(), false);
                        }
                    }
                }
            }
        }
        if (sequence == this.activeSequence) {
            this.fireActiveSequenceChangedEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sequenceClosed(Sequence sequence, LUT userLut) {
        for (Overlay overlay : sequence.getOverlays()) {
            this.checkOverlayRemoved(overlay, true);
        }
        for (ROI roi : sequence.getROIs()) {
            this.checkRoiRemoved(roi, true);
        }
        sequence.removeListener(this.sequenceListener);
        List<Sequence> list = this.sequences;
        synchronized (list) {
            this.sequences.remove(sequence);
        }
        if (userLut != null) {
            sequence.setUserLUT(userLut);
        }
        sequence.closed();
        this.fireSequenceClosedEvent(sequence);
    }

    private void checkRoiAdded(ROI roi, boolean checkBeforeAdd) {
        ArrayList<Sequence> sequencesContainingRoi = this.getSequencesContaining(roi);
        if (sequencesContainingRoi.size() == (checkBeforeAdd ? 0 : 1)) {
            this.roiAdded(roi);
        }
    }

    private void checkRoiRemoved(ROI roi, boolean checkBeforeRemove) {
        ArrayList<Sequence> sequencesContainingRoi = this.getSequencesContaining(roi);
        if (sequencesContainingRoi.size() == (checkBeforeRemove ? 1 : 0)) {
            this.roiRemoved(roi);
        }
    }

    private void checkOverlayAdded(Overlay overlay, boolean checkBeforeAdd) {
        List<Sequence> sequencesContainingOverlay = this.getSequencesContaining(overlay);
        if (sequencesContainingOverlay.size() == (checkBeforeAdd ? 0 : 1)) {
            this.overlayAdded(overlay);
        }
    }

    private void checkOverlayRemoved(Overlay overlay, boolean checkBeforeRemove) {
        List<Sequence> sequencesContainingOverlay = this.getSequencesContaining(overlay);
        if (sequencesContainingOverlay.size() == (checkBeforeRemove ? 1 : 0)) {
            this.overlayRemoved(overlay);
        }
    }

    private void roiAdded(ROI roi) {
        this.fireRoiAddedEvent(roi);
    }

    private void roiRemoved(ROI roi) {
        this.fireRoiRemovedEvent(roi);
    }

    private void overlayAdded(Overlay overlay) {
        this.fireOverlayAddedEvent(overlay);
    }

    private void overlayRemoved(Overlay overlay) {
        this.fireOverlayRemovedEvent(overlay);
    }

    @Override
    public void setGlobalViewSyncId(int id) {
        for (Viewer viewer : this.getViewers()) {
            viewer.setViewSyncId(id);
        }
    }

    @Override
    public boolean isVirtualMode() {
        return GeneralPreferences.getVirtualMode();
    }

    @Override
    public void setVirtualMode(boolean value) {
        InspectorPanel inspector = this.getInspector();
        if (inspector != null) {
            inspector.setVirtualMode(value);
        }
    }

    private class WeakAcceptListener
    extends WeakListener<AcceptListener>
    implements AcceptListener {
        public WeakAcceptListener(AcceptListener listener) {
            super(listener);
        }

        @Override
        public void removeListener(Object source) {
            MainInterfaceGui.this.internalRemoveCanExitListener(this);
        }

        @Override
        public boolean accept(Object source) {
            AcceptListener listener = (AcceptListener)this.getListener();
            if (listener != null) {
                return listener.accept(source);
            }
            return true;
        }
    }
}

