/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.partition;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.filesystem.MFileOS7;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.CollectionSingleIndexFile;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.partition.PartitionManager;
import ucar.nc2.util.CloseableIterator;

public class PartitionManagerFromIndexDirectory
extends CollectionAbstract
implements PartitionManager {
    private List<File> partIndexFiles;
    private final FeatureCollectionConfig config;
    private List<String> removed;

    public PartitionManagerFromIndexDirectory(String name, FeatureCollectionConfig config, File directory, Logger logger) {
        super(name, logger);
        this.config = config;
        this.root = directory.getPath();
        this.partIndexFiles = new ArrayList<File>();
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".ncx3");
            }
        });
        if (files != null) {
            Collections.addAll(this.partIndexFiles, files);
        }
        this.putAuxInfo("fcConfig", config);
    }

    @Override
    public Iterable<MCollection> makePartitions(CollectionUpdateType forceCollection) throws IOException {
        return new PartIterator();
    }

    @Override
    public void close() {
    }

    @Override
    public Iterable<MFile> getFilesSorted() throws IOException {
        return null;
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() throws IOException {
        return null;
    }

    @Override
    public void removePartition(MCollection partition) {
        if (this.removed == null) {
            this.removed = new ArrayList<String>();
        }
        this.removed.add(partition.getCollectionName());
    }

    private boolean wasRemoved(MCollection partition) {
        return this.removed != null && this.removed.contains(partition.getCollectionName());
    }

    private class PartIterator
    implements Iterator<MCollection>,
    Iterable<MCollection> {
        Iterator<File> iter;
        MCollection next;

        private PartIterator() {
            this.iter = PartitionManagerFromIndexDirectory.this.partIndexFiles.iterator();
            this.next = null;
        }

        @Override
        public Iterator<MCollection> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (!this.iter.hasNext()) {
                this.next = null;
                return false;
            }
            File nextFile = this.iter.next();
            try {
                CollectionSingleIndexFile result = new CollectionSingleIndexFile(new MFileOS7(nextFile.getPath()), PartitionManagerFromIndexDirectory.this.logger);
                if (PartitionManagerFromIndexDirectory.this.wasRemoved(result)) {
                    return this.hasNext();
                }
                result.putAuxInfo("fcConfig", PartitionManagerFromIndexDirectory.this.config);
                this.next = result;
                return true;
            }
            catch (IOException e) {
                PartitionManagerFromIndexDirectory.this.logger.error("PartitionManagerFromList failed on " + nextFile.getPath(), e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public MCollection next() {
            return this.next;
        }

        @Override
        public void remove() {
        }
    }
}

