/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.tools;

import icy.file.FileUtil;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.colormap.IcyColorMap;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.plugin.PluginLoader;
import icy.preferences.PluginsPreferences;
import icy.preferences.XMLPreferences;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.type.collection.CollectionUtil;
import icy.type.collection.array.Array2DUtil;
import icy.type.collection.array.ArrayUtil;
import icy.type.point.Point3D;
import icy.util.DateUtil;
import icy.util.OMEUtil;
import icy.util.ReflectionUtil;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import mmcorej.TaggedImage;
import ome.xml.meta.OMEXMLMetadata;
import ome.xml.model.Pixels;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.Timestamp;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.ConfigGroupPad;
import org.micromanager.acquisition.TaggedImageQueue;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManager.patch.MMPatcher;
import plugins.tprovoost.Microscopy.MicroManager.tools.StageMover;
import plugins.tprovoost.Microscopy.MicroManagerForIcy.MicromanagerPlugin;

public class MMUtils {
    private static final String MM_PATH_ID = "libray_path";
    static XMLPreferences prefs = PluginsPreferences.root(MicromanagerPlugin.class);
    static String uManagerRep = null;
    public static File demoConfigFile = null;
    private static boolean loaded = false;

    public static String getMicroManagerFolder() {
        if (!loaded && !MMUtils.fixSystemLibrairies()) {
            return "";
        }
        return uManagerRep;
    }

    public static boolean isSystemLibrairiesLoaded() {
        return loaded;
    }

    public static boolean fixSystemLibrairies() {
        if (loaded) {
            return loaded;
        }
        uManagerRep = prefs.get(MM_PATH_ID, "");
        File uManagerLibraryRep = new File(uManagerRep);
        if (uManagerRep.isEmpty() || !uManagerLibraryRep.exists() || !uManagerLibraryRep.isDirectory()) {
            ThreadUtil.invokeNow((Runnable)new Runnable(){

                @Override
                public void run() {
                    int option = JOptionPane.showOptionDialog((Component)Icy.getMainInterface().getMainFrame(), "Have you already installed Micro-Manager ?", "Micro-Manager For Icy", 1, 3, null, new String[]{"Select Micro-Manager directory", "Download Micro-Manager", "Cancel"}, "Download Micro-Manager");
                    if (option == 1) {
                        NetworkUtil.openBrowser((String)"http://www.micro-manager.org/wiki/Download%20Micro-Manager_Latest%20Release");
                        MessageDialog.showDialog((String)"Restart this plugin after Micro-Manager installation complete.", (int)1);
                        uManagerRep = null;
                    } else if (option == 0) {
                        JFileChooser fc = new JFileChooser();
                        fc.setFileSelectionMode(1);
                        uManagerRep = fc.showOpenDialog((Component)Icy.getMainInterface().getMainFrame()) == 0 ? fc.getSelectedFile().getAbsolutePath() : null;
                    } else {
                        uManagerRep = null;
                    }
                }
            });
        }
        if (uManagerRep == null) {
            return false;
        }
        if (!uManagerRep.endsWith("/")) {
            uManagerRep = uManagerRep + "/";
        }
        try (ProgressFrame loadingFrame = new ProgressFrame("  Please wait while loading Micro-Manager libraries...  ");){
            loaded = MMUtils.loadJarFrom(new File(uManagerRep + "/" + "plugins" + "/" + "Micro-Manager" + "/"));
        }
        if (!loaded) {
            new FailedAnnounceFrame("Error while loading libraries, have you choosen the correct directory ? Please try again.");
        } else {
            try {
                MMPatcher.applyPatches();
            }
            catch (Throwable t) {
                new FailedAnnounceFrame("Cannot patch Micro-Manager classes, it may not work correctly until you restart Icy !");
            }
            MMUtils.loadDllFrom(new File(uManagerRep));
            File[] cfg = new File(uManagerRep).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String s) {
                    return s.equalsIgnoreCase("MMConfig_demo.cfg");
                }
            });
            if (cfg != null && cfg.length > 0) {
                demoConfigFile = cfg[0];
            }
            prefs.put(MM_PATH_ID, uManagerRep);
            System.setProperty("mmcorej.library.path", uManagerRep);
        }
        return loaded;
    }

    public static void resetLibrayPath() {
        prefs.put(MM_PATH_ID, "");
        System.setProperty("mmcorej.library.path", "");
    }

    public static boolean hasNullOrPoison(List<TaggedImage> images) {
        for (TaggedImage image : images) {
            if (image != null && !TaggedImageQueue.isPoison((TaggedImage)image)) continue;
            return true;
        }
        return false;
    }

    public static String getDateString() {
        return DateUtil.now((String)"yyyy-MM-dd HH'h'mm'm'ss's'");
    }

    public static IcyBufferedImage convertToIcyImage(List<TaggedImage> images) throws JSONException {
        ArrayList<TaggedImage> goodImages = new ArrayList<TaggedImage>(images.size());
        int w = -1;
        int h = -1;
        int bpp = -1;
        for (TaggedImage image : images) {
            if (image == null || TaggedImageQueue.isPoison((TaggedImage)image)) continue;
            if (w == -1) {
                w = MDUtils.getWidth((JSONObject)image.tags);
            } else if (w != MDUtils.getWidth((JSONObject)image.tags)) continue;
            if (h == -1) {
                h = MDUtils.getHeight((JSONObject)image.tags);
            } else if (h != MDUtils.getHeight((JSONObject)image.tags)) continue;
            if (bpp == -1) {
                bpp = (MDUtils.getBitDepth((JSONObject)image.tags) + 7) / 8;
            } else if (bpp != (MDUtils.getBitDepth((JSONObject)image.tags) + 7) / 8) continue;
            goodImages.add(image);
        }
        if (goodImages.size() > 0 && w > 0 && h > 0 && bpp > 0) {
            Object[] data = Array2DUtil.createArray((DataType)ArrayUtil.getDataType((Object)((TaggedImage)goodImages.get((int)0)).pix), (int)goodImages.size());
            for (int i = 0; i < goodImages.size(); ++i) {
                data[i] = ((TaggedImage)goodImages.get((int)i)).pix;
            }
            return new IcyBufferedImage(w, h, data);
        }
        return null;
    }

    public static IcyBufferedImage convertToIcyImage(TaggedImage img) throws JSONException {
        return MMUtils.convertToIcyImage(CollectionUtil.createArrayList((Object)img));
    }

    public static void setMetadata(Sequence sequence, JSONObject tags) throws JSONException, MMScriptException {
        double intervalMs;
        double pixelSizeZ;
        double pixelSize;
        int c;
        OMEXMLMetadata metadata = sequence.getOMEXMLMetadata();
        int numComp = Math.max(1, MDUtils.getNumberOfComponents((JSONObject)tags));
        try {
            if (numComp == 1) {
                JSONArray channelColors = tags.getJSONArray("ChColors");
                for (c = 0; c < sequence.getSizeC(); ++c) {
                    Color channelColor = new Color(channelColors.getInt(c));
                    if (channelColor.equals(Color.black)) continue;
                    IcyColorMap colormap = sequence.getColorModel().getColorMap(c);
                    if (colormap != null) {
                        colormap.setARGBControlPoint(0, Color.black);
                        colormap.setARGBControlPoint(255, channelColor);
                    }
                    if ((colormap = sequence.getColorMap(c)) != null) {
                        colormap.setARGBControlPoint(0, Color.black);
                        colormap.setARGBControlPoint(255, channelColor);
                    }
                    metadata.setChannelColor(OMEUtil.getOMEColor((Color)channelColor), 0, c);
                }
            }
        }
        catch (Exception channelColors) {
            // empty catch block
        }
        try {
            JSONArray channelNames = tags.getJSONArray("ChNames");
            for (c = 0; c < sequence.getSizeC(); ++c) {
                String channelName = channelNames.getString(c / numComp);
                if (StringUtil.isEmpty((String)channelName)) continue;
                sequence.setChannelName(c, channelName);
            }
        }
        catch (Exception channelNames) {
            // empty catch block
        }
        try {
            int ch = MDUtils.getChannelIndex((JSONObject)tags);
            if (ch < sequence.getSizeC()) {
                String channelName;
                Color channelColor;
                if (numComp == 1 && !(channelColor = new Color(MDUtils.getChannelColor((JSONObject)tags))).equals(Color.black) && !channelColor.equals(Color.white)) {
                    IcyColorMap colormap = sequence.getColorModel().getColorMap(ch);
                    if (colormap != null) {
                        colormap.setARGBControlPoint(0, Color.black);
                        colormap.setARGBControlPoint(255, channelColor);
                    }
                    if ((colormap = sequence.getColorMap(ch)) != null) {
                        colormap.setARGBControlPoint(0, Color.black);
                        colormap.setARGBControlPoint(255, channelColor);
                    }
                    metadata.setChannelColor(OMEUtil.getOMEColor((Color)channelColor), 0, ch);
                }
                if (!StringUtil.isEmpty((String)(channelName = MDUtils.getChannelName((JSONObject)tags)))) {
                    sequence.setChannelName(ch, channelName);
                }
            }
        }
        catch (Exception ch) {
            // empty catch block
        }
        if (MDUtils.hasPixelSizeUm((JSONObject)tags) && (pixelSize = MDUtils.getPixelSizeUm((JSONObject)tags)) > 0.0) {
            sequence.setPixelSizeX(pixelSize);
            sequence.setPixelSizeY(pixelSize);
        }
        if (MDUtils.hasZStepUm((JSONObject)tags) && (pixelSizeZ = MDUtils.getZStepUm((JSONObject)tags)) > 0.0) {
            sequence.setPixelSizeZ(pixelSizeZ);
        }
        if (MDUtils.hasIntervalMs((JSONObject)tags) && (intervalMs = MDUtils.getIntervalMs((JSONObject)tags) / 1000.0) > 0.0) {
            sequence.setTimeInterval(intervalMs);
        }
    }

    public static void setImageMetadata(TaggedImage taggedImage, int t, int z, int c, int sizeT, int sizeZ, int sizeC) throws JSONException {
        if (taggedImage == null) {
            return;
        }
        JSONObject tags = taggedImage.tags;
        if (t >= 0) {
            MDUtils.setFrameIndex((JSONObject)tags, (int)t);
        }
        if (z >= 0) {
            MDUtils.setSliceIndex((JSONObject)tags, (int)z);
        }
        if (c >= 0) {
            MDUtils.setChannelIndex((JSONObject)tags, (int)c);
        }
        if (sizeT > 0) {
            tags.put("Frames", sizeT);
        }
        if (sizeZ > 0) {
            tags.put("Slices", sizeZ);
        }
        if (sizeC > 0) {
            tags.put("Channels", sizeC);
        }
    }

    static void setImageData(IcyBufferedImage dest, Object pixels, int channel, boolean rgb) {
        if (rgb) {
            Object RArray = dest.getDataXY(channel * 3 + 0);
            Object GArray = dest.getDataXY(channel * 3 + 1);
            Object BArray = dest.getDataXY(channel * 3 + 2);
            int len = dest.getSizeX() * dest.getSizeY();
            int off = 0;
            for (int i = 0; i < len; ++i) {
                Array.set(RArray, i, Array.get(pixels, off + 2));
                Array.set(GArray, i, Array.get(pixels, off + 1));
                Array.set(BArray, i, Array.get(pixels, off + 0));
                off += 4;
            }
            dest.setDataXY(channel * 3 + 0, RArray);
            dest.setDataXY(channel * 3 + 1, GArray);
            dest.setDataXY(channel * 3 + 2, BArray);
        } else {
            dest.setDataXY(channel, pixels);
        }
    }

    public static boolean setImage(Sequence sequence, TaggedImage taggedImage, long startDate) throws JSONException, MMScriptException {
        Point3D.Double pos;
        if (taggedImage == null || TaggedImageQueue.isPoison((TaggedImage)taggedImage)) {
            return false;
        }
        JSONObject tags = taggedImage.tags;
        if (!MMUtils.isCompatible(sequence, tags)) {
            return false;
        }
        int frame = MDUtils.getFrameIndex((JSONObject)tags);
        int slice = MDUtils.getSliceIndex((JSONObject)tags);
        int ch = MDUtils.getChannelIndex((JSONObject)tags);
        IcyBufferedImage image = sequence.getImage(frame, slice);
        if (image == null) {
            image = MMUtils.createEmptyImage(tags);
        }
        MMUtils.setImageData(image, taggedImage.pix, ch, Math.max(1, MDUtils.getNumberOfComponents((JSONObject)tags)) > 1);
        sequence.setImage(frame, slice, (BufferedImage)image);
        int sizeC = MDUtils.getNumChannels((JSONObject)tags);
        int sizeZ = MDUtils.getNumSlices((JSONObject)tags);
        int planeIndex = frame * (sizeZ * sizeC) + slice * sizeC + ch;
        OMEXMLMetadata metadata = sequence.getOMEXMLMetadata();
        if (sequence.getNumImage() == 1) {
            MMUtils.setMetadata(sequence, tags);
            if (startDate != 0L) {
                metadata.setImageAcquisitionDate(new Timestamp(new DateTime(startDate)), 0);
            }
        }
        Pixels pix = MetaDataUtil.getPixels((OMEXMLMetadata)metadata, (int)0);
        MetaDataUtil.ensurePlane((Pixels)pix, (int)planeIndex);
        metadata.setPlaneTheT(NonNegativeInteger.valueOf((String)String.valueOf(frame)), 0, planeIndex);
        metadata.setPlaneTheZ(NonNegativeInteger.valueOf((String)String.valueOf(slice)), 0, planeIndex);
        metadata.setPlaneTheC(NonNegativeInteger.valueOf((String)String.valueOf(ch)), 0, planeIndex);
        try {
            pos = StageMover.getXYZ();
        }
        catch (Exception e1) {
            pos = new Point3D.Double(0.0, 0.0, 0.0);
        }
        double time = 0.0;
        double exposure = 0.0;
        if (MDUtils.hasXPositionUm((JSONObject)tags)) {
            pos.setX(MDUtils.getXPositionUm((JSONObject)tags));
        }
        if (MDUtils.hasYPositionUm((JSONObject)tags)) {
            pos.setY(MDUtils.getYPositionUm((JSONObject)tags));
        }
        if (MDUtils.hasZPositionUm((JSONObject)tags)) {
            pos.setZ(MDUtils.getZPositionUm((JSONObject)tags));
        }
        if (MDUtils.hasElapsedTimeMs((JSONObject)tags)) {
            time = MDUtils.getElapsedTimeMs((JSONObject)tags) / 1000.0;
        }
        if (time == 0.0 && startDate != 0L) {
            time = (double)(Calendar.getInstance().getTimeInMillis() - startDate) / 1000.0;
        }
        if (MDUtils.hasExposureMs((JSONObject)tags)) {
            exposure = MDUtils.getExposureMs((JSONObject)tags) / 1000.0;
        }
        try {
            if (exposure == 0.0) {
                exposure = MicroManager.getExposure() / 1000.0;
            }
        }
        catch (Throwable e) {
            IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)false);
        }
        metadata.setPlanePositionX(OMEUtil.getLength((double)pos.getX()), 0, planeIndex);
        metadata.setPlanePositionY(OMEUtil.getLength((double)pos.getY()), 0, planeIndex);
        metadata.setPlanePositionZ(OMEUtil.getLength((double)pos.getZ()), 0, planeIndex);
        metadata.setPlaneDeltaT(OMEUtil.getTime((double)time), 0, planeIndex);
        metadata.setPlaneExposureTime(OMEUtil.getTime((double)exposure), 0, planeIndex);
        return true;
    }

    public static boolean setImage(Sequence sequence, TaggedImage taggedImage) throws JSONException, MMScriptException {
        return MMUtils.setImage(sequence, taggedImage, 0L);
    }

    public static boolean isCompatible(Sequence sequence, JSONObject metadata) throws JSONException, MMScriptException {
        if (sequence.isEmpty()) {
            return true;
        }
        return sequence.getSizeX() == MDUtils.getWidth((JSONObject)metadata) && sequence.getSizeY() == MDUtils.getHeight((JSONObject)metadata) && sequence.getSizeC() == MDUtils.getNumChannels((JSONObject)metadata) * Math.max(1, MDUtils.getNumberOfComponents((JSONObject)metadata)) && sequence.getDataType_().getSize() == (MDUtils.getBitDepth((JSONObject)metadata) + 7) / 8;
    }

    public static IcyBufferedImage createEmptyImage(JSONObject metadata) throws JSONException, MMScriptException {
        int width = MDUtils.getWidth((JSONObject)metadata);
        int height = MDUtils.getHeight((JSONObject)metadata);
        int numChannels = MDUtils.getNumChannels((JSONObject)metadata) * Math.max(1, MDUtils.getNumberOfComponents((JSONObject)metadata));
        int bpp = MDUtils.getBitDepth((JSONObject)metadata);
        int bytespp = (bpp + 7) / 8;
        switch (bytespp) {
            default: {
                return new IcyBufferedImage(width, height, numChannels, DataType.UBYTE);
            }
            case 2: {
                return new IcyBufferedImage(width, height, numChannels, DataType.USHORT);
            }
            case 3: 
            case 4: {
                return new IcyBufferedImage(width, height, numChannels, DataType.UINT);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
        }
        return new IcyBufferedImage(width, height, numChannels, DataType.DOUBLE);
    }

    public static String getSelectedGroupName(ConfigGroupPad group) {
        try {
            return (String)ReflectionUtil.invokeMethod((Object)group, (String)"getGroup", (boolean)true, (Object[])new Object[0]);
        }
        catch (Exception e1) {
            try {
                return (String)ReflectionUtil.invokeMethod((Object)group, (String)"getSelectedGroup", (boolean)true, (Object[])new Object[0]);
            }
            catch (Exception e2) {
                return "";
            }
        }
    }

    public static String getSelectedPresetName(ConfigGroupPad group) {
        try {
            return (String)ReflectionUtil.invokeMethod((Object)group, (String)"getPreset", (boolean)true, (Object[])new Object[0]);
        }
        catch (Exception e1) {
            try {
                return (String)ReflectionUtil.invokeMethod((Object)group, (String)"getPresetForSelectedGroup", (boolean)true, (Object[])new Object[0]);
            }
            catch (Exception e2) {
                return "";
            }
        }
    }

    private static boolean loadDllFrom(File microManagerDirectory) {
        List dll = CollectionUtil.asList((Object[])FileUtil.getFiles((File)microManagerDirectory, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String extension = FileUtil.getFileExtension((String)pathname.getAbsolutePath(), (boolean)false);
                return (extension.equalsIgnoreCase("dll") || extension.equalsIgnoreCase("jnilib")) && !pathname.getName().contains("mmgr_dal_") && !pathname.getName().contains("MMCoreJ_wrap");
            }
        }, (boolean)true, (boolean)false, (boolean)true));
        if (dll.isEmpty()) {
            return false;
        }
        int numberOfTry = 0;
        while (!dll.isEmpty()) {
            ++numberOfTry;
            for (File f : dll) {
                try {
                    SystemUtil.loadLibrary((String)f.getAbsolutePath());
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            }
            if (numberOfTry <= 9) continue;
            break;
        }
        return true;
    }

    private static boolean loadJarFrom(File microManagerDirectoryPath) {
        File[] files = FileUtil.getFiles((File)microManagerDirectoryPath, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return FileUtil.getFileExtension((String)pathname.getAbsolutePath(), (boolean)false).equalsIgnoreCase("jar");
            }
        }, (boolean)true, (boolean)false, (boolean)true);
        if (files == null || files.length == 0) {
            return false;
        }
        ClassLoader cl = PluginLoader.getLoader();
        if (cl instanceof PluginLoader.PluginClassLoader) {
            for (File f : files) {
                String path = f.getAbsolutePath();
                String ext = FileUtil.getFileExtension((String)path, (boolean)false).toLowerCase();
                if (!ext.equals("jar") && !ext.equals("class")) continue;
                ((PluginLoader.PluginClassLoader)cl).add(path);
            }
        }
        return true;
    }
}

