/*
 * Decompiled with CFR 0.152.
 */
package icy.swimmingPool;

import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolEventType;
import icy.swimmingPool.SwimmingPoolListener;
import icy.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.EventListenerList;

public class SwimmingPool {
    private final ArrayList<SwimmingObject> objects = new ArrayList();
    private final EventListenerList listeners = new EventListenerList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SwimmingObject object) {
        if (object != null) {
            ArrayList<SwimmingObject> arrayList = this.objects;
            synchronized (arrayList) {
                this.objects.add(object);
            }
            this.fireSwimmingPoolEvent(new SwimmingPoolEvent(SwimmingPoolEventType.ELEMENT_ADDED, object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(SwimmingObject object) {
        boolean b;
        ArrayList<SwimmingObject> arrayList = this.objects;
        synchronized (arrayList) {
            b = this.objects.remove(object);
        }
        if (b) {
            this.fireSwimmingPoolEvent(new SwimmingPoolEvent(SwimmingPoolEventType.ELEMENT_REMOVED, object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        boolean b;
        ArrayList<SwimmingObject> arrayList = this.objects;
        synchronized (arrayList) {
            boolean bl = b = !this.objects.isEmpty();
            if (b) {
                this.objects.clear();
            }
        }
        if (b) {
            this.fireSwimmingPoolEvent(new SwimmingPoolEvent(SwimmingPoolEventType.ELEMENT_REMOVED, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Collection<SwimmingObject> sos) {
        boolean b;
        ArrayList<SwimmingObject> arrayList = this.objects;
        synchronized (arrayList) {
            b = this.objects.removeAll(sos);
        }
        if (b) {
            this.fireSwimmingPoolEvent(new SwimmingPoolEvent(SwimmingPoolEventType.ELEMENT_REMOVED, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(String name, boolean startWith) {
        boolean b = false;
        ArrayList<SwimmingObject> arrayList = this.objects;
        synchronized (arrayList) {
            for (int i = this.objects.size() - 1; i >= 0; --i) {
                SwimmingObject so = this.objects.get(i);
                if (so == null) continue;
                if (startWith) {
                    if (!so.getName().startsWith(name)) continue;
                    this.objects.remove(i);
                    b = true;
                    continue;
                }
                if (!StringUtil.equals(name, so.getName())) continue;
                this.objects.remove(i);
                b = true;
            }
        }
        if (b) {
            this.fireSwimmingPoolEvent(new SwimmingPoolEvent(SwimmingPoolEventType.ELEMENT_REMOVED, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Class<?> objectType) {
        boolean b = false;
        ArrayList<SwimmingObject> arrayList = this.objects;
        synchronized (arrayList) {
            for (int i = this.objects.size() - 1; i >= 0; --i) {
                Object obj;
                SwimmingObject so = this.objects.get(i);
                if (so == null || (obj = so.getObject()) == null || !objectType.isInstance(obj)) continue;
                this.objects.remove(i);
                b = true;
            }
        }
        if (b) {
            this.fireSwimmingPoolEvent(new SwimmingPoolEvent(SwimmingPoolEventType.ELEMENT_REMOVED, null));
        }
    }

    public ArrayList<SwimmingObject> getObjects() {
        return new ArrayList<SwimmingObject>(this.objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SwimmingObject> getObjects(String name, boolean startWith) {
        ArrayList<SwimmingObject> result = new ArrayList<SwimmingObject>();
        ArrayList<SwimmingObject> arrayList = this.objects;
        synchronized (arrayList) {
            for (SwimmingObject so : this.objects) {
                if (so == null) continue;
                if (startWith) {
                    if (!so.getName().startsWith(name)) continue;
                    result.add(so);
                    continue;
                }
                if (!StringUtil.equals(name, so.getName())) continue;
                result.add(so);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SwimmingObject> getObjects(Class<?> objectType) {
        ArrayList<SwimmingObject> result = new ArrayList<SwimmingObject>();
        ArrayList<SwimmingObject> arrayList = this.objects;
        synchronized (arrayList) {
            for (SwimmingObject so : this.objects) {
                Object obj;
                if (so == null || (obj = so.getObject()) == null || !objectType.isInstance(obj)) continue;
                result.add(so);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SwimmingObject> popObjects(String name, boolean startWith) {
        ArrayList<SwimmingObject> result = new ArrayList<SwimmingObject>();
        ArrayList<SwimmingObject> arrayList = this.objects;
        synchronized (arrayList) {
            for (int i = this.objects.size() - 1; i >= 0; --i) {
                SwimmingObject so = this.objects.get(i);
                if (so == null) continue;
                if (startWith) {
                    if (!so.getName().startsWith(name)) continue;
                    result.add(so);
                    this.objects.remove(i);
                    continue;
                }
                if (!StringUtil.equals(name, so.getName())) continue;
                result.add(so);
                this.objects.remove(i);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SwimmingObject> popObjects(Class<?> objectType) {
        ArrayList<SwimmingObject> result = new ArrayList<SwimmingObject>();
        ArrayList<SwimmingObject> arrayList = this.objects;
        synchronized (arrayList) {
            for (int i = this.objects.size() - 1; i >= 0; --i) {
                Object obj;
                SwimmingObject so = this.objects.get(i);
                if (so == null || (obj = so.getObject()) == null || !objectType.isInstance(obj)) continue;
                result.add(so);
                this.objects.remove(i);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasObjects(String name, boolean startWith) {
        ArrayList<SwimmingObject> arrayList = this.objects;
        synchronized (arrayList) {
            for (SwimmingObject so : this.objects) {
                if (so == null) continue;
                if (startWith) {
                    if (!so.getName().startsWith(name)) continue;
                    return true;
                }
                if (!StringUtil.equals(name, so.getName())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasObjects(Class<?> objectType) {
        ArrayList<SwimmingObject> arrayList = this.objects;
        synchronized (arrayList) {
            for (SwimmingObject so : this.objects) {
                Object obj;
                if (so == null || (obj = so.getObject()) == null || !objectType.isInstance(obj)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(String name, boolean startWith) {
        int result = 0;
        ArrayList<SwimmingObject> arrayList = this.objects;
        synchronized (arrayList) {
            for (SwimmingObject so : this.objects) {
                if (so == null) continue;
                if (startWith) {
                    if (!so.getName().startsWith(name)) continue;
                    ++result;
                    continue;
                }
                if (!StringUtil.equals(name, so.getName())) continue;
                ++result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(Class<?> objectType) {
        int result = 0;
        ArrayList<SwimmingObject> arrayList = this.objects;
        synchronized (arrayList) {
            for (SwimmingObject so : this.objects) {
                Object obj;
                if (so == null || (obj = so.getObject()) == null || !objectType.isInstance(obj)) continue;
                ++result;
            }
        }
        return result;
    }

    public void addListener(SwimmingPoolListener listener) {
        this.listeners.add(SwimmingPoolListener.class, listener);
    }

    public void removeListener(SwimmingPoolListener listener) {
        this.listeners.remove(SwimmingPoolListener.class, listener);
    }

    private void fireSwimmingPoolEvent(SwimmingPoolEvent swimmingPoolEvent) {
        for (SwimmingPoolListener listener : (SwimmingPoolListener[])this.listeners.getListeners(SwimmingPoolListener.class)) {
            listener.swimmingPoolChangeEvent(swimmingPoolEvent);
        }
    }
}

