/*
 * Decompiled with CFR 0.152.
 */
package icy.canvas;

import icy.canvas.IcyCanvas;
import icy.common.CollapsibleEvent;
import icy.sequence.DimensionId;

public class IcyCanvasEvent
implements CollapsibleEvent {
    private IcyCanvas source;
    private final IcyCanvasEventType type;
    private final DimensionId dim;

    public IcyCanvasEvent(IcyCanvas source, IcyCanvasEventType type, DimensionId dim) {
        this.source = source;
        this.type = type;
        this.dim = dim;
    }

    public IcyCanvasEvent(IcyCanvas source, IcyCanvasEventType type) {
        this(source, type, DimensionId.NULL);
    }

    public IcyCanvas getSource() {
        return this.source;
    }

    public IcyCanvasEventType getType() {
        return this.type;
    }

    public DimensionId getDim() {
        return this.dim;
    }

    @Override
    public boolean collapse(CollapsibleEvent event) {
        return this.equals(event);
    }

    @Override
    public int hashCode() {
        return this.source.hashCode() ^ this.type.hashCode() ^ this.dim.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IcyCanvasEvent) {
            IcyCanvasEvent e = (IcyCanvasEvent)obj;
            return e.getSource() == this.source && e.getType() == this.type && e.getDim() == this.dim;
        }
        return super.equals(obj);
    }

    public static enum IcyCanvasEventType {
        POSITION_CHANGED,
        OFFSET_CHANGED,
        SCALE_CHANGED,
        ROTATION_CHANGED,
        MOUSE_IMAGE_POSITION_CHANGED,
        SYNC_CHANGED;

    }
}

