/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class MolecularImagingReader
extends FormatReader {
    private static final String MAGIC_STRING = "UK SOFT";
    private static final String DATE_FORMAT = "dd.MM.yyyy HH:mm:ss";
    private long pixelOffset = 0L;

    public MolecularImagingReader() {
        super("Molecular Imaging", "stp");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 16;
        if (!FormatTools.validStream(stream, 16, false)) {
            return false;
        }
        return stream.readString(16).indexOf(MAGIC_STRING) > 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.in.seek(this.pixelOffset + (long)(no * FormatTools.getPlaneSize(this)));
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        String[] lines;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.sizeZ = 0;
        String date = null;
        double pixelSizeX = 0.0;
        double pixelSizeY = 0.0;
        String data = this.in.findString("Data_section  \r\n");
        for (String line : lines = data.split("\n")) {
            int space = (line = line.trim()).indexOf(32);
            if (space == -1) continue;
            String key = line.substring(0, space).trim();
            String value = line.substring(space + 1).trim();
            this.addGlobalMeta(key, value);
            if (key.equals("samples_x")) {
                m3.sizeX = Integer.parseInt(value);
                continue;
            }
            if (key.equals("samples_y")) {
                m3.sizeY = Integer.parseInt(value);
                continue;
            }
            if (key.equals("buffer_id")) {
                ++m3.sizeZ;
                continue;
            }
            if (key.equals("Date")) {
                date = value;
                continue;
            }
            if (key.equals("time")) {
                date = date + " " + value;
                continue;
            }
            if (key.equals("length_x")) {
                pixelSizeX = Double.parseDouble(value) / (double)this.getSizeX();
                continue;
            }
            if (!key.equals("length_y")) continue;
            pixelSizeY = Double.parseDouble(value) / (double)this.getSizeY();
        }
        this.pixelOffset = this.in.getFilePointer();
        m3.sizeC = 1;
        m3.sizeT = 1;
        m3.imageCount = this.getSizeZ();
        m3.rgb = false;
        m3.pixelType = 3;
        m3.littleEndian = true;
        m3.dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (date != null && (date = DateTools.formatDate(date, DATE_FORMAT)) != null) {
            store.setImageAcquisitionDate(new Timestamp(date), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Length sizeX = FormatTools.getPhysicalSizeX(pixelSizeX);
            Length sizeY = FormatTools.getPhysicalSizeY(pixelSizeY);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
        }
    }
}

