/*
 * Decompiled with CFR 0.152.
 */
package icy.network;

import icy.util.StringUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class URLUtil {
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_FTP = "ftp";
    public static final String PROTOCOL_GOPHER = "gopher";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_JAR = "jar";

    public static URL getURL(String path) {
        if (path == null) {
            return null;
        }
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            try {
                return new File(path).toURI().toURL();
            }
            catch (MalformedURLException e2) {
                return null;
            }
        }
    }

    public static boolean isURL(String path) {
        return URLUtil.getURL(path) != null;
    }

    public static boolean isNetworkURL(String path) {
        return URLUtil.isNetworkURL(URLUtil.getURL(path));
    }

    public static boolean isNetworkURL(URL url) {
        return url != null && !url.getProtocol().equals(PROTOCOL_FILE);
    }

    public static boolean isFileURL(String path) {
        return URLUtil.isFileURL(URLUtil.getURL(path));
    }

    public static boolean isFileURL(URL url) {
        return url != null && url.getProtocol().equals(PROTOCOL_FILE);
    }

    public static boolean isAbsolute(String path) {
        if (!StringUtil.isEmpty(path)) {
            int index = path.indexOf(58);
            if (index != -1) {
                if (index + 1 < path.length()) {
                    return path.charAt(index + 1) == '/';
                }
                return false;
            }
            return path.charAt(0) == '/';
        }
        return false;
    }

    public static String getNetworkURLString(String base, String path) {
        if (StringUtil.isEmpty(base)) {
            return path;
        }
        if (StringUtil.isEmpty(path)) {
            return base;
        }
        if (URLUtil.isNetworkURL(path)) {
            return path;
        }
        return base + path;
    }

    public static String getURLProtocol(URL url) {
        if (url == null) {
            return null;
        }
        return url.getProtocol();
    }

    public static String getURLHost(URL url) {
        if (url == null) {
            return null;
        }
        return url.getHost();
    }

    public static String getURLDirectory(String url) {
        return URLUtil.getURLDirectory(URLUtil.getURL(url));
    }

    public static String getURLDirectory(URL url) {
        String path;
        if (url != null && !StringUtil.isEmpty(path = url.getPath())) {
            int index = path.lastIndexOf(47);
            if (index != -1) {
                return path.substring(0, index + 1);
            }
            index = path.lastIndexOf(58);
            if (index != -1) {
                return path.substring(0, index + 1);
            }
        }
        return "";
    }

    public static String getURLFileName(String url) {
        return URLUtil.getURLFileName(URLUtil.getURL(url));
    }

    public static String getURLFileName(String url, boolean withExtension) {
        return URLUtil.getURLFileName(URLUtil.getURL(url), withExtension);
    }

    public static String getURLFileName(URL url) {
        return URLUtil.getURLFileName(url, true);
    }

    public static String getURLFileName(URL url, boolean withExtension) {
        if (url == null) {
            return "";
        }
        String path = url.getPath();
        if (StringUtil.isEmpty(path)) {
            return "";
        }
        int index = path.lastIndexOf(47);
        String fileName = index != -1 ? path.substring(index + 1) : ((index = path.lastIndexOf(58)) != -1 ? path.substring(index + 1) : path);
        if (withExtension) {
            return fileName;
        }
        index = fileName.lastIndexOf(46);
        if (index == 0) {
            return "";
        }
        if (index != -1) {
            return fileName.substring(0, index);
        }
        return fileName;
    }

    public static String getURLFileExtension(String url, boolean withDot) {
        return URLUtil.getURLFileExtension(URLUtil.getURL(url), withDot);
    }

    public static String getURLFileExtension(URL url, boolean withDot) {
        if (url == null) {
            return "";
        }
        String path = url.getPath();
        if (StringUtil.isEmpty(path)) {
            return "";
        }
        int index = path.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        if (withDot) {
            return path.substring(index);
        }
        return path.substring(index + 1);
    }

    public static String getURLQuery(URL url) {
        if (url == null) {
            return null;
        }
        return url.getQuery();
    }

    public static URL buildURL(String basePath, String url) {
        if (!URLUtil.isAbsolute(url) && !StringUtil.isEmpty(basePath)) {
            return URLUtil.getURL(basePath + url);
        }
        return URLUtil.getURL(url);
    }
}

