/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Byte1D;
import mitiv.array.Byte5D;
import mitiv.array.Byte6D;
import mitiv.array.impl.FlatByte1D;
import mitiv.array.impl.FlatByte5D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedByte6D;
import mitiv.array.impl.StriddenByte5D;
import mitiv.array.impl.StriddenByte6D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.ByteGenerator;

public class FlatByte6D
extends Byte6D {
    static final int order = 1;
    final byte[] data;
    final int dim1dim2;
    final int dim1dim2dim3;
    final int dim1dim2dim3dim4;
    final int dim1dim2dim3dim4dim5;

    public FlatByte6D(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        super(dim1, dim2, dim3, dim4, dim5, dim6);
        this.data = new byte[this.number];
        this.dim1dim2 = dim1 * dim2;
        this.dim1dim2dim3 = this.dim1dim2 * dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * dim5;
    }

    public FlatByte6D(int[] dims) {
        super(dims);
        this.data = new byte[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
    }

    public FlatByte6D(Shape shape) {
        super(shape);
        this.data = new byte[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
    }

    public FlatByte6D(byte[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        super(dim1, dim2, dim3, dim4, dim5, dim6);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = dim1 * dim2;
        this.dim1dim2dim3 = this.dim1dim2 * dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * dim5;
    }

    public FlatByte6D(byte[] arr, int[] dims) {
        super(dims);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
    }

    public FlatByte6D(byte[] arr, Shape shape) {
        super(shape);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(byte[] arr) {
        if (arr == null || arr.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int i1, int i2, int i3, int i4, int i5, int i6) {
        return this.dim1dim2dim3dim4dim5 * i6 + this.dim1dim2dim3dim4 * i5 + this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1;
    }

    @Override
    public final byte get(int i1, int i2, int i3, int i4, int i5, int i6) {
        return this.data[this.dim1dim2dim3dim4dim5 * i6 + this.dim1dim2dim3dim4 * i5 + this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1];
    }

    @Override
    public final void set(int i1, int i2, int i3, int i4, int i5, int i6, byte value) {
        this.data[this.dim1dim2dim3dim4dim5 * i6 + this.dim1dim2dim3dim4 * i5 + this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1] = value;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(byte value) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = value;
        }
    }

    @Override
    public void fill(ByteGenerator generator) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = generator.nextByte();
        }
    }

    @Override
    public void increment(byte value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (byte)(this.data[n] + value);
        }
    }

    @Override
    public void decrement(byte value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (byte)(this.data[n] - value);
        }
    }

    @Override
    public void scale(byte value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (byte)(this.data[n] * value);
        }
    }

    @Override
    public void map(ByteFunction function) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = function.apply(this.data[j]);
        }
    }

    @Override
    public void scan(ByteScanner scanner) {
        scanner.initialize(this.data[0]);
        for (int j = 1; j < this.number; ++j) {
            scanner.update(this.data[j]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public byte[] flatten(boolean forceCopy) {
        if (forceCopy) {
            byte[] result = new byte[this.number];
            System.arraycopy(this.data, 0, result, 0, this.number);
            return result;
        }
        return this.data;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public Byte5D slice(int idx) {
        if ((idx = Helper.fixIndex(idx, this.dim6)) == 0) {
            return new FlatByte5D(this.data, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
        }
        return new StriddenByte5D(this.data, this.dim1dim2dim3dim4dim5 * idx, 1, this.dim1, this.dim1dim2, this.dim1dim2dim3, this.dim1dim2dim3dim4, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Byte5D slice(int idx, int dim) {
        int sliceDim5;
        int sliceDim4;
        int sliceDim3;
        int sliceDim2;
        int sliceDim1;
        int sliceStride5;
        int sliceStride4;
        int sliceStride3;
        int sliceStride2;
        int sliceStride1;
        int sliceOffset;
        if ((dim = Helper.fixSliceIndex(dim, 6)) == 0) {
            sliceOffset = Helper.fixIndex(idx, this.dim1);
            sliceStride1 = this.dim1;
            sliceStride2 = this.dim1dim2;
            sliceStride3 = this.dim1dim2dim3;
            sliceStride4 = this.dim1dim2dim3dim4;
            sliceStride5 = this.dim1dim2dim3dim4dim5;
            sliceDim1 = this.dim2;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
            sliceDim4 = this.dim5;
            sliceDim5 = this.dim6;
        } else if (dim == 1) {
            sliceOffset = this.dim1 * Helper.fixIndex(idx, this.dim2);
            sliceStride1 = 1;
            sliceStride2 = this.dim1dim2;
            sliceStride3 = this.dim1dim2dim3;
            sliceStride4 = this.dim1dim2dim3dim4;
            sliceStride5 = this.dim1dim2dim3dim4dim5;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
            sliceDim4 = this.dim5;
            sliceDim5 = this.dim6;
        } else if (dim == 2) {
            sliceOffset = this.dim1dim2 * Helper.fixIndex(idx, this.dim3);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2dim3;
            sliceStride4 = this.dim1dim2dim3dim4;
            sliceStride5 = this.dim1dim2dim3dim4dim5;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim4;
            sliceDim4 = this.dim5;
            sliceDim5 = this.dim6;
        } else if (dim == 3) {
            sliceOffset = this.dim1dim2dim3 * Helper.fixIndex(idx, this.dim4);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2;
            sliceStride4 = this.dim1dim2dim3dim4;
            sliceStride5 = this.dim1dim2dim3dim4dim5;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim5;
            sliceDim5 = this.dim6;
        } else if (dim == 4) {
            sliceOffset = this.dim1dim2dim3dim4 * Helper.fixIndex(idx, this.dim5);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2;
            sliceStride4 = this.dim1dim2dim3;
            sliceStride5 = this.dim1dim2dim3dim4dim5;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim4;
            sliceDim5 = this.dim6;
        } else {
            sliceOffset = this.dim1dim2dim3dim4dim5 * Helper.fixIndex(idx, this.dim6);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2;
            sliceStride4 = this.dim1dim2dim3;
            sliceStride5 = this.dim1dim2dim3dim4;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim4;
            sliceDim5 = this.dim5;
        }
        return new StriddenByte5D(this.data, sliceOffset, sliceStride1, sliceStride2, sliceStride3, sliceStride4, sliceStride5, sliceDim1, sliceDim2, sliceDim3, sliceDim4, sliceDim5);
    }

    @Override
    public Byte6D view(Range rng1, Range rng2, Range rng3, Range rng4, Range rng5, Range rng6) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, 0, 1);
        CompiledRange cr2 = new CompiledRange(rng2, this.dim2, 0, this.dim1);
        CompiledRange cr3 = new CompiledRange(rng3, this.dim3, 0, this.dim1dim2);
        CompiledRange cr4 = new CompiledRange(rng4, this.dim4, 0, this.dim1dim2dim3);
        CompiledRange cr5 = new CompiledRange(rng5, this.dim5, 0, this.dim1dim2dim3dim4);
        CompiledRange cr6 = new CompiledRange(rng6, this.dim6, 0, this.dim1dim2dim3dim4dim5);
        if (cr1.doesNothing() && cr2.doesNothing() && cr3.doesNothing() && cr4.doesNothing() && cr5.doesNothing() && cr6.doesNothing()) {
            return this;
        }
        return new StriddenByte6D(this.data, cr1.getOffset() + cr2.getOffset() + cr3.getOffset() + cr4.getOffset() + cr5.getOffset() + cr6.getOffset(), cr1.getStride(), cr2.getStride(), cr3.getStride(), cr4.getStride(), cr5.getStride(), cr6.getStride(), cr1.getNumber(), cr2.getNumber(), cr3.getNumber(), cr4.getNumber(), cr5.getNumber(), cr6.getNumber());
    }

    @Override
    public Byte6D view(int[] sel1, int[] sel2, int[] sel3, int[] sel4, int[] sel5, int[] sel6) {
        int[] idx1 = Helper.select(0, 1, this.dim1, sel1);
        int[] idx2 = Helper.select(0, this.dim1, this.dim2, sel2);
        int[] idx3 = Helper.select(0, this.dim1dim2, this.dim3, sel3);
        int[] idx4 = Helper.select(0, this.dim1dim2dim3, this.dim4, sel4);
        int[] idx5 = Helper.select(0, this.dim1dim2dim3dim4, this.dim5, sel5);
        int[] idx6 = Helper.select(0, this.dim1dim2dim3dim4dim5, this.dim6, sel6);
        return new SelectedByte6D(this.data, idx1, idx2, idx3, idx4, idx5, idx6);
    }

    @Override
    public Byte1D as1D() {
        return new FlatByte1D(this.data, this.number);
    }
}

