/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.expressions;

import java.util.SortedSet;
import plugins.ylemontag.mathoperations.Expression;
import plugins.ylemontag.mathoperations.Functor;
import plugins.ylemontag.mathoperations.expressions.ExpressionComposition;

public class ExpressionOpposite
extends Expression {
    private Expression _rhs;

    public ExpressionOpposite(Expression rhs) {
        this._rhs = rhs;
    }

    public Expression getRhs() {
        return this._rhs;
    }

    @Override
    public boolean equals(Expression expr) {
        return expr instanceof ExpressionOpposite && this._rhs.equals(((ExpressionOpposite)expr)._rhs);
    }

    @Override
    public String getRepresentation(boolean smartParenthesis) {
        return "-" + this.addParenthesisIfNecessary(this._rhs.getRepresentation(smartParenthesis), smartParenthesis);
    }

    private String addParenthesisIfNecessary(String in, boolean smartParenthesis) {
        String retVal = in;
        if (this._rhs instanceof ExpressionOpposite) {
            retVal = "(" + retVal + ")";
        } else if (this._rhs instanceof ExpressionComposition) {
            int exprPriority = ((ExpressionComposition)this._rhs).getOperator().getPriority();
            if (!smartParenthesis || exprPriority == 0) {
                retVal = "(" + retVal + ")";
            }
        }
        return retVal;
    }

    @Override
    public SortedSet<String> getVariables() {
        return this._rhs.getVariables();
    }

    @Override
    public boolean isValidFunctor(String[] variables) {
        return this._rhs.isValidFunctor(variables);
    }

    @Override
    public Functor getFunctor(String[] variables) {
        Functor functor = this._rhs.getFunctor(variables);
        String pattern = "-" + this.addParenthesisIfNecessary(functor.getFormatPattern(), true);
        final Functor.FunPtr funPtr = functor.getFunctionPointer();
        return new Functor(variables.length, pattern, new Functor.FunPtr(){

            @Override
            public double apply(double[] in) {
                return -funPtr.apply(in);
            }
        });
    }
}

