/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.intensity;

import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import plugins.kernel.roi.descriptor.intensity.ROIIntensityDescriptorsPlugin;

public class ROIStandardDeviationDescriptor
extends ROIDescriptor {
    public static final String ID = "Standard deviation";

    public ROIStandardDeviationDescriptor() {
        super(ID, "Standard Deviation", Double.class);
    }

    @Override
    public String getDescription() {
        return ID;
    }

    @Override
    public boolean separateChannel() {
        return true;
    }

    @Override
    public boolean needRecompute(SequenceEvent change) {
        return change.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA;
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        return ROIStandardDeviationDescriptor.computeStandardDeviation(roi, sequence);
    }

    public static double computeStandardDeviation(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        try {
            return ROIIntensityDescriptorsPlugin.computeIntensityDescriptors((ROI)roi, (Sequence)sequence, (boolean)false).deviation;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(ROIStandardDeviationDescriptor.class.getSimpleName() + ": cannot compute descriptors for '" + roi.getName() + "'", e);
        }
    }
}

