/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.distanceMap3d;

import ij.ImagePlus;
import java.util.ArrayList;
import java.util.Arrays;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.distanceMap3d.CleanUpLocalThickness;
import mcib3d.image3d.distanceMap3d.DistanceRidge;
import mcib3d.image3d.distanceMap3d.EdtByte;
import mcib3d.image3d.distanceMap3d.EdtByteInv;
import mcib3d.image3d.distanceMap3d.EdtFloat;
import mcib3d.image3d.distanceMap3d.EdtFloatInv;
import mcib3d.image3d.distanceMap3d.EdtShort;
import mcib3d.image3d.distanceMap3d.EdtShortInv;
import mcib3d.image3d.distanceMap3d.EdtShortLabel;
import mcib3d.image3d.distanceMap3d.LocalThickness;
import mcib3d.image3d.distanceMap3d.VoxEVF;
import mcib3d.utils.ThreadUtil;
import mcib3d.utils.exceptionPrinter;

public class EDT {
    public static ImageFloat run(ImageHandler ip, float thresh, float scaleXY, float scaleZ, boolean inverse, int nbCPUs) {
        if (nbCPUs <= 0) {
            nbCPUs = ThreadUtil.getNbCpus();
        }
        try {
            if (ip instanceof ImageShort) {
                return inverse ? new EdtShortInv().run((ImageShort)ip, (int)((double)thresh + 0.5), scaleXY, scaleZ, nbCPUs) : new EdtShort().run((ImageShort)ip, (int)((double)thresh + 0.5), scaleXY, scaleZ, nbCPUs);
            }
            if (ip instanceof ImageByte) {
                return inverse ? new EdtByteInv().run((ImageByte)ip, (int)((double)thresh + 0.5), scaleXY, scaleZ, nbCPUs) : new EdtByte().run((ImageByte)ip, (int)((double)thresh + 0.5), scaleXY, scaleZ, nbCPUs);
            }
            if (ip instanceof ImageFloat) {
                return inverse ? new EdtFloatInv().run((ImageFloat)ip, thresh, scaleXY, scaleZ, nbCPUs) : new EdtFloat().run((ImageFloat)ip, thresh, scaleXY, scaleZ, nbCPUs);
            }
        }
        catch (Exception e) {
            exceptionPrinter.print(e, "distance Map ", false);
            return null;
        }
        return null;
    }

    public static ImageFloat run(ImageHandler ip, float thresh, boolean inverse, int nbCPUs) {
        return EDT.run(ip, thresh, (float)ip.getScaleXY(), (float)ip.getScaleZ(), inverse, nbCPUs);
    }

    public static ImageFloat run_includeInside(ImageHandler ip, int thresh, float scaleXY, float scaleZ, boolean absolute, int nbCPUs) {
        ImageFloat ihdm1 = EDT.run(ip, thresh, scaleXY, scaleZ, true, nbCPUs);
        ImageFloat ihdm2 = EDT.run(ip, thresh, scaleXY, scaleZ, false, nbCPUs);
        if (!absolute) {
            for (int z = 0; z < ihdm1.sizeZ; ++z) {
                for (int xy = 0; xy < ihdm1.sizeXY; ++xy) {
                    if (ihdm2.pixels[z][xy] == 0.0f) continue;
                    ihdm1.pixels[z][xy] = -ihdm2.pixels[z][xy];
                }
            }
        } else {
            for (int z = 0; z < ihdm1.sizeZ; ++z) {
                for (int xy = 0; xy < ihdm1.sizeXY; ++xy) {
                    if (ihdm2.pixels[z][xy] == 0.0f) continue;
                    ihdm1.pixels[z][xy] = ihdm2.pixels[z][xy];
                }
            }
        }
        return ihdm1;
    }

    public static ImageFloat run_includeInside(ImageHandler ip, int thresh, boolean absolute, int nbCPUs) {
        return EDT.run_includeInside(ip, thresh, (float)ip.getScaleXY(), (float)ip.getScaleZ(), absolute, nbCPUs);
    }

    public static ImageFloat localThickness(ImageHandler in, ImageInt mask, float thld, float radiusXY, float radiusZ, boolean inside, int nbCPUs) {
        ImageFloat edm = EDT.run(in, thld, radiusXY, radiusZ, inside, nbCPUs);
        if (mask != null) {
            edm.intersectMask(mask);
        }
        DistanceRidge dr = new DistanceRidge();
        ImagePlus distRidge = dr.run(edm.getImagePlus(), radiusXY, radiusZ, nbCPUs);
        if (mask != null) {
            ImageHandler drIm = ImageHandler.wrap(distRidge);
            drIm.intersectMask(mask);
        }
        edm.closeImagePlus();
        LocalThickness lt = new LocalThickness();
        lt.run(distRidge, radiusXY, radiusZ, nbCPUs);
        CleanUpLocalThickness cult = new CleanUpLocalThickness();
        ImagePlus localThickness = cult.run(distRidge);
        distRidge.flush();
        return (ImageFloat)ImageFloat.wrap(localThickness);
    }

    public static ImageFloat localThickness(ImageHandler in, ImageInt mask, float thld, boolean inside, int nbCPUs) {
        return EDT.localThickness(in, mask, thld, (float)in.getScaleXY(), (float)in.getScaleZ(), inside, nbCPUs);
    }

    public static ImageFloat runEdtLabel(ImageInt objects, float scaleXY, float scaleZ, int nbCPUs) {
        try {
            ImageShort is = !(objects instanceof ImageShort) ? new ImageShort(objects, false) : (ImageShort)objects;
            return new EdtShortLabel().run(is, scaleXY, scaleZ, nbCPUs);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void normalizeDistanceMap(ImageFloat distanceMap, ImageInt mask, boolean excludeZeros) {
        ArrayList<VoxEVF> idxList = new ArrayList<VoxEVF>();
        double minDist = Double.NEGATIVE_INFINITY;
        if (excludeZeros) {
            minDist = 0.0;
        }
        for (int z = 0; z < distanceMap.sizeZ; ++z) {
            for (int xy = 0; xy < distanceMap.sizeXY; ++xy) {
                if (mask.getPixelInt(xy, z) > 0 && (double)distanceMap.getPixel(xy, z) > minDist) {
                    idxList.add(new VoxEVF(distanceMap.pixels[z][xy], xy, z));
                    continue;
                }
                distanceMap.setPixel(xy, z, 1.0f);
            }
        }
        if (idxList.isEmpty()) {
            return;
        }
        Object[] idx = new VoxEVF[idxList.size()];
        idx = idxList.toArray(idx);
        double volume = idx.length;
        Arrays.sort(idx);
        for (int i = 0; i < idx.length - 1; ++i) {
            if (((VoxEVF)idx[i + 1]).distance == ((VoxEVF)idx[i]).distance) {
                int j;
                for (j = i + 1; j < idx.length - 1 && ((VoxEVF)idx[i]).distance == ((VoxEVF)idx[j]).distance; ++j) {
                }
                double median = (double)(i + j) / 2.0;
                for (int k = i; k <= j; ++k) {
                    ((VoxEVF)idx[k]).index = median;
                }
                i = j;
                continue;
            }
            ((VoxEVF)idx[i]).index = i;
        }
        if (((VoxEVF)idx[idx.length - 1]).index == 0.0) {
            ((VoxEVF)idx[idx.length - 1]).index = idx.length - 1;
        }
        for (Object idx1 : idx) {
            distanceMap.pixels[((VoxEVF)idx1).z][((VoxEVF)idx1).xy] = (float)(((VoxEVF)idx1).index / volume);
        }
    }
}

