/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.ezplug;

import icy.util.XMLUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.ezplug.EzException;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;

class EzVarIO {
    EzVarIO() {
    }

    static synchronized void save(EzPlug source, HashMap<String, EzVar<?>> ezVarMap, File f) {
        Document xml = XMLUtil.createDocument((boolean)false);
        Element root = XMLUtil.createRootElement((Document)xml, (String)"Parameters");
        for (String id : ezVarMap.keySet()) {
            EzVar<?> var = ezVarMap.get(id);
            try {
                Element parameterNode = XMLUtil.addElement((Node)root, (String)"parameter");
                XMLUtil.setAttributeValue((Element)parameterNode, (String)"ID", (String)id);
                var.getVariable().saveToXML(parameterNode);
            }
            catch (UnsupportedOperationException e) {
                System.err.println("Warning: variable " + id + " has not been saved (unsupported variable type)");
            }
        }
        if (!XMLUtil.saveDocument((Document)xml, (File)f)) {
            throw new EzException(source, "unable to save parameters", true);
        }
    }

    static synchronized void load(EzPlug source, File f, HashMap<String, EzVar<?>> ezVarMap) throws EzException {
        Document xml = XMLUtil.loadDocument((File)f);
        if (xml == null) {
            throw new EzException(source, "unable to load parameter file", true);
        }
        Element root = XMLUtil.getRootElement((Document)xml);
        ArrayList elements = XMLUtil.getElements((Node)root);
        for (Element element : elements) {
            String id = XMLUtil.getAttributeValue((Element)element, (String)"ID", null);
            if (id == null || !ezVarMap.containsKey(id)) continue;
            ezVarMap.get(id).getVariable().loadFromXML(element);
        }
    }
}

