/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dct;

import java.util.concurrent.Future;
import org.jtransforms.fft.FloatFFT_1D;
import org.jtransforms.utils.CommonUtils;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.LongLargeArray;
import pl.edu.icm.jlargearrays.Utilities;

public class FloatDCT_1D {
    private int n;
    private long nl;
    private int[] ip;
    private LongLargeArray ipl;
    private float[] w;
    private FloatLargeArray wl;
    private int nw;
    private long nwl;
    private int nc;
    private long ncl;
    private boolean isPowerOfTwo = false;
    private FloatFFT_1D fft;
    private static final float PI = (float)Math.PI;
    private boolean useLargeArrays;

    public FloatDCT_1D(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        boolean bl = this.useLargeArrays = l >= ConcurrencyUtils.getLargeArraysBeginN();
        if (!this.useLargeArrays) {
            if (l > 0x10000000L) {
                throw new IllegalArgumentException("n must be smaller or equal to 268435456 when useLargeArrays argument is set to false");
            }
            this.n = (int)l;
            if (ConcurrencyUtils.isPowerOf2(l)) {
                this.isPowerOfTwo = true;
                this.ip = new int[(int)Math.ceil(2 + (1 << (int)(Math.log((double)(l / 2L) + 0.5) / Math.log(2.0)) / 2))];
                this.w = new float[this.n * 5 / 4];
                this.nw = this.ip[0];
                if (l > (long)(this.nw << 2)) {
                    this.nw = this.n >> 2;
                    CommonUtils.makewt(this.nw, this.ip, this.w);
                }
                this.nc = this.ip[1];
                if (l > (long)this.nc) {
                    this.nc = this.n;
                    CommonUtils.makect(this.nc, this.w, this.nw, this.ip);
                }
            } else {
                this.w = this.makect(this.n);
                this.fft = new FloatFFT_1D(2L * l);
            }
        } else {
            this.nl = l;
            if (ConcurrencyUtils.isPowerOf2(l)) {
                this.isPowerOfTwo = true;
                this.ipl = new LongLargeArray((long)Math.ceil(2L + (1L << (int)((long)(Math.log((double)(l / 2L) + 0.5) / Math.log(2.0)) / 2L))), false);
                this.wl = new FloatLargeArray(this.nl * 5L / 4L, false);
                this.nwl = this.ipl.getLong(0L);
                if (l > this.nwl << 2) {
                    this.nwl = this.nl >> 2;
                    CommonUtils.makewt(this.nwl, this.ipl, this.wl);
                }
                this.ncl = this.ipl.getLong(1L);
                if (l > this.ncl) {
                    this.ncl = this.nl;
                    CommonUtils.makect(this.ncl, this.wl, this.nwl, this.ipl);
                }
            } else {
                this.wl = this.makect(l);
                this.fft = new FloatFFT_1D(2L * l);
            }
        }
    }

    public void forward(float[] fArray, boolean bl) {
        this.forward(fArray, 0, bl);
    }

    public void forward(FloatLargeArray floatLargeArray, boolean bl) {
        this.forward(floatLargeArray, 0L, bl);
    }

    public void forward(final float[] fArray, final int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.forward(new FloatLargeArray(fArray), (long)n, bl);
        } else if (this.isPowerOfTwo) {
            float f = fArray[n + this.n - 1];
            for (int i = this.n - 2; i >= 2; i -= 2) {
                fArray[n + i + 1] = fArray[n + i] - fArray[n + i - 1];
                int n2 = n + i;
                fArray[n2] = fArray[n2] + fArray[n + i - 1];
            }
            fArray[n + 1] = fArray[n] - f;
            int n3 = n;
            fArray[n3] = fArray[n3] + f;
            if (this.n > 4) {
                FloatDCT_1D.rftbsub(this.n, fArray, n, this.nc, this.w, this.nw);
                CommonUtils.cftbsub(this.n, fArray, n, this.ip, this.nw, this.w);
            } else if (this.n == 4) {
                CommonUtils.cftbsub(this.n, fArray, n, this.ip, this.nw, this.w);
            }
            CommonUtils.dctsub(this.n, fArray, n, this.nc, this.w, this.nw);
            if (bl) {
                CommonUtils.scale(this.n, (float)Math.sqrt(2.0 / (double)this.n), fArray, n, false);
                fArray[n] = fArray[n] / (float)Math.sqrt(2.0);
            }
        } else {
            int n4;
            int n5 = 2 * this.n;
            final float[] fArray2 = new float[n5];
            System.arraycopy(fArray, n, fArray2, 0, this.n);
            int n6 = ConcurrencyUtils.getNumberOfThreads();
            for (n4 = this.n; n4 < n5; ++n4) {
                fArray2[n4] = fArray2[n5 - n4 - 1];
            }
            this.fft.realForward(fArray2);
            if (n6 > 1 && (long)this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n6 = 2;
                n4 = this.n / n6;
                Future[] futureArray = new Future[n6];
                for (int i = 0; i < n6; ++i) {
                    final int n7 = i * n4;
                    final int n8 = i == n6 - 1 ? this.n : n7 + n4;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n7; i < n8; ++i) {
                                int n3 = 2 * i;
                                int n2 = n + i;
                                fArray[n2] = FloatDCT_1D.this.w[n3] * fArray2[n3] - FloatDCT_1D.this.w[n3 + 1] * fArray2[n3 + 1];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (n4 = 0; n4 < this.n; ++n4) {
                    int n9 = 2 * n4;
                    int n10 = n + n4;
                    fArray[n10] = this.w[n9] * fArray2[n9] - this.w[n9 + 1] * fArray2[n9 + 1];
                }
            }
            if (bl) {
                CommonUtils.scale(this.n, 1.0f / (float)Math.sqrt(n5), fArray, n, false);
                fArray[n] = fArray[n] / (float)Math.sqrt(2.0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forward(final FloatLargeArray floatLargeArray, final long l, boolean bl) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (floatLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.forward(floatLargeArray.getData(), (int)l, bl);
            return;
        } else if (this.isPowerOfTwo) {
            float f = floatLargeArray.getFloat(l + this.nl - 1L);
            for (long i = this.nl - 2L; i >= 2L; i -= 2L) {
                floatLargeArray.setFloat(l + i + 1L, floatLargeArray.getFloat(l + i) - floatLargeArray.getFloat(l + i - 1L));
                floatLargeArray.setFloat(l + i, floatLargeArray.getFloat(l + i) + floatLargeArray.getFloat(l + i - 1L));
            }
            floatLargeArray.setFloat(l + 1L, floatLargeArray.getFloat(l) - f);
            floatLargeArray.setFloat(l, floatLargeArray.getFloat(l) + f);
            if (this.nl > 4L) {
                FloatDCT_1D.rftbsub(this.nl, floatLargeArray, l, this.ncl, this.wl, this.nwl);
                CommonUtils.cftbsub(this.nl, floatLargeArray, l, this.ipl, this.nwl, this.wl);
            } else if (this.nl == 4L) {
                CommonUtils.cftbsub(this.nl, floatLargeArray, l, this.ipl, this.nwl, this.wl);
            }
            CommonUtils.dctsub(this.nl, floatLargeArray, l, this.ncl, this.wl, this.nwl);
            if (!bl) return;
            CommonUtils.scale(this.nl, (float)Math.sqrt(2.0 / (double)this.nl), floatLargeArray, l, false);
            floatLargeArray.setFloat(l, floatLargeArray.getFloat(l) / (float)Math.sqrt(2.0));
            return;
        } else {
            long l2;
            long l3 = 2L * this.nl;
            final FloatLargeArray floatLargeArray2 = new FloatLargeArray(l3, false);
            Utilities.arraycopy(floatLargeArray, l, floatLargeArray2, 0L, this.nl);
            int n = ConcurrencyUtils.getNumberOfThreads();
            for (l2 = this.nl; l2 < l3; ++l2) {
                floatLargeArray2.setFloat(l2, floatLargeArray2.getFloat(l3 - l2 - 1L));
            }
            this.fft.realForward(floatLargeArray2);
            if (n > 1 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n = 2;
                l2 = this.nl / (long)n;
                Future[] futureArray = new Future[n];
                for (int i = 0; i < n; ++i) {
                    final long l4 = (long)i * l2;
                    final long l5 = i == n - 1 ? this.nl : l4 + l2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l4; i < l5; ++i) {
                                long l3 = 2L * i;
                                long l2 = l + i;
                                floatLargeArray.setFloat(l2, FloatDCT_1D.this.wl.getFloat(l3) * floatLargeArray2.getFloat(l3) - FloatDCT_1D.this.wl.getFloat(l3 + 1L) * floatLargeArray2.getFloat(l3 + 1L));
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (l2 = 0L; l2 < this.nl; ++l2) {
                    long l6 = 2L * l2;
                    long l7 = l + l2;
                    floatLargeArray.setFloat(l7, this.wl.getFloat(l6) * floatLargeArray2.getFloat(l6) - this.wl.getFloat(l6 + 1L) * floatLargeArray2.getFloat(l6 + 1L));
                }
            }
            if (!bl) return;
            CommonUtils.scale(this.nl, 1.0f / (float)Math.sqrt(l3), floatLargeArray, l, false);
            floatLargeArray.setFloat(l, floatLargeArray.getFloat(l) / (float)Math.sqrt(2.0));
        }
    }

    public void inverse(float[] fArray, boolean bl) {
        this.inverse(fArray, 0, bl);
    }

    public void inverse(FloatLargeArray floatLargeArray, boolean bl) {
        this.inverse(floatLargeArray, 0L, bl);
    }

    public void inverse(final float[] fArray, final int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.inverse(new FloatLargeArray(fArray), (long)n, bl);
        } else if (this.isPowerOfTwo) {
            if (bl) {
                CommonUtils.scale(this.n, (float)Math.sqrt(2.0 / (double)this.n), fArray, n, false);
                fArray[n] = fArray[n] / (float)Math.sqrt(2.0);
            }
            CommonUtils.dctsub(this.n, fArray, n, this.nc, this.w, this.nw);
            if (this.n > 4) {
                CommonUtils.cftfsub(this.n, fArray, n, this.ip, this.nw, this.w);
                FloatDCT_1D.rftfsub(this.n, fArray, n, this.nc, this.w, this.nw);
            } else if (this.n == 4) {
                CommonUtils.cftfsub(this.n, fArray, n, this.ip, this.nw, this.w);
            }
            float f = fArray[n] - fArray[n + 1];
            int n2 = n;
            fArray[n2] = fArray[n2] + fArray[n + 1];
            for (int i = 2; i < this.n; i += 2) {
                fArray[n + i - 1] = fArray[n + i] - fArray[n + i + 1];
                int n3 = n + i;
                fArray[n3] = fArray[n3] + fArray[n + i + 1];
            }
            fArray[n + this.n - 1] = f;
        } else {
            int n4 = 2 * this.n;
            if (bl) {
                CommonUtils.scale(this.n, (float)Math.sqrt(n4), fArray, n, false);
                fArray[n] = fArray[n] * (float)Math.sqrt(2.0);
            }
            final float[] fArray2 = new float[n4];
            int n5 = ConcurrencyUtils.getNumberOfThreads();
            if (n5 > 1 && (long)this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n5 = 2;
                int n6 = this.n / n5;
                Future[] futureArray = new Future[n5];
                for (int i = 0; i < n5; ++i) {
                    final int n7 = i * n6;
                    final int n8 = i == n5 - 1 ? this.n : n7 + n6;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n7; i < n8; ++i) {
                                int n2 = 2 * i;
                                float f = fArray[n + i];
                                fArray2[n2] = FloatDCT_1D.this.w[n2] * f;
                                fArray2[n2 + 1] = -FloatDCT_1D.this.w[n2 + 1] * f;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.n; ++i) {
                    int n9 = 2 * i;
                    float f = fArray[n + i];
                    fArray2[n9] = this.w[n9] * f;
                    fArray2[n9 + 1] = -this.w[n9 + 1] * f;
                }
            }
            this.fft.realInverse(fArray2, true);
            System.arraycopy(fArray2, 0, fArray, n, this.n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void inverse(final FloatLargeArray floatLargeArray, final long l, boolean bl) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (floatLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.inverse(floatLargeArray.getData(), (int)l, bl);
            return;
        } else if (this.isPowerOfTwo) {
            if (bl) {
                CommonUtils.scale(this.nl, (float)Math.sqrt(2.0 / (double)this.nl), floatLargeArray, l, false);
                floatLargeArray.setFloat(l, floatLargeArray.getFloat(l) / (float)Math.sqrt(2.0));
            }
            CommonUtils.dctsub(this.nl, floatLargeArray, l, this.ncl, this.wl, this.nwl);
            if (this.nl > 4L) {
                CommonUtils.cftfsub(this.nl, floatLargeArray, l, this.ipl, this.nwl, this.wl);
                FloatDCT_1D.rftfsub(this.nl, floatLargeArray, l, this.ncl, this.wl, this.nwl);
            } else if (this.nl == 4L) {
                CommonUtils.cftfsub(this.nl, floatLargeArray, l, this.ipl, this.nwl, this.wl);
            }
            float f = floatLargeArray.getFloat(l) - floatLargeArray.getFloat(l + 1L);
            floatLargeArray.setFloat(l, floatLargeArray.getFloat(l) + floatLargeArray.getFloat(l + 1L));
            for (long i = 2L; i < this.nl; i += 2L) {
                floatLargeArray.setFloat(l + i - 1L, floatLargeArray.getFloat(l + i) - floatLargeArray.getFloat(l + i + 1L));
                floatLargeArray.setFloat(l + i, floatLargeArray.getFloat(l + i) + floatLargeArray.getFloat(l + i + 1L));
            }
            floatLargeArray.setFloat(l + this.nl - 1L, f);
            return;
        } else {
            long l2 = 2L * this.nl;
            if (bl) {
                CommonUtils.scale(this.nl, (float)Math.sqrt(l2), floatLargeArray, l, false);
                floatLargeArray.setFloat(l, floatLargeArray.getFloat(l) * (float)Math.sqrt(2.0));
            }
            final FloatLargeArray floatLargeArray2 = new FloatLargeArray(l2, false);
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n = 2;
                long l3 = this.nl / (long)n;
                Future[] futureArray = new Future[n];
                for (int i = 0; i < n; ++i) {
                    final long l4 = (long)i * l3;
                    final long l5 = i == n - 1 ? this.nl : l4 + l3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l4; i < l5; ++i) {
                                long l2 = 2L * i;
                                float f = floatLargeArray.getFloat(l + i);
                                floatLargeArray2.setFloat(l2, FloatDCT_1D.this.wl.getFloat(l2) * f);
                                floatLargeArray2.setFloat(l2 + 1L, -FloatDCT_1D.this.wl.getFloat(l2 + 1L) * f);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (long i = 0L; i < this.nl; ++i) {
                    long l6 = 2L * i;
                    float f = floatLargeArray.getFloat(l + i);
                    floatLargeArray2.setFloat(l6, this.wl.getFloat(l6) * f);
                    floatLargeArray2.setFloat(l6 + 1L, -this.wl.getFloat(l6 + 1L) * f);
                }
            }
            this.fft.realInverse(floatLargeArray2, true);
            Utilities.arraycopy(floatLargeArray2, 0L, floatLargeArray, l, this.nl);
        }
    }

    private float[] makect(int n) {
        int n2 = 2 * n;
        float f = (float)Math.PI / (float)n2;
        float[] fArray = new float[n2];
        fArray[0] = 1.0f;
        for (int i = 1; i < n; ++i) {
            int n3 = 2 * i;
            float f2 = f * (float)i;
            fArray[n3] = (float)Math.cos(f2);
            fArray[n3 + 1] = -((float)Math.sin(f2));
        }
        return fArray;
    }

    private FloatLargeArray makect(long l) {
        long l2 = 2L * l;
        float f = (float)Math.PI / (float)l2;
        FloatLargeArray floatLargeArray = new FloatLargeArray(l2, false);
        floatLargeArray.setFloat(0L, 1.0f);
        for (long i = 1L; i < l; ++i) {
            long l3 = 2L * i;
            float f2 = f * (float)i;
            floatLargeArray.setFloat(l3, (float)Math.cos(f2));
            floatLargeArray.setFloat(l3 + 1L, -((float)Math.sin(f2)));
        }
        return floatLargeArray;
    }

    private static void rftfsub(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            float f = 0.5f - fArray2[n4 + n3 - (n7 += n6)];
            float f2 = fArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            float f3 = fArray[n9] - fArray[n10];
            float f4 = fArray[n9 + 1] + fArray[n10 + 1];
            float f5 = f * f3 - f2 * f4;
            float f6 = f * f4 + f2 * f3;
            int n11 = n9;
            fArray[n11] = fArray[n11] - f5;
            int n12 = n9 + 1;
            fArray[n12] = fArray[n12] - f6;
            int n13 = n10;
            fArray[n13] = fArray[n13] + f5;
            int n14 = n10 + 1;
            fArray[n14] = fArray[n14] - f6;
        }
    }

    private static void rftfsub(long l, FloatLargeArray floatLargeArray, long l2, long l3, FloatLargeArray floatLargeArray2, long l4) {
        long l5 = l >> 1;
        long l6 = 2L * l3 / l5;
        long l7 = 0L;
        for (long i = 2L; i < l5; i += 2L) {
            long l8 = l - i;
            float f = 0.5f - floatLargeArray2.getFloat(l4 + l3 - (l7 += l6));
            float f2 = floatLargeArray2.getFloat(l4 + l7);
            long l9 = l2 + i;
            long l10 = l2 + l8;
            float f3 = floatLargeArray.getFloat(l9) - floatLargeArray.getFloat(l10);
            float f4 = floatLargeArray.getFloat(l9 + 1L) + floatLargeArray.getFloat(l10 + 1L);
            float f5 = f * f3 - f2 * f4;
            float f6 = f * f4 + f2 * f3;
            floatLargeArray.setFloat(l9, floatLargeArray.getFloat(l9) - f5);
            floatLargeArray.setFloat(l9 + 1L, floatLargeArray.getFloat(l9 + 1L) - f6);
            floatLargeArray.setFloat(l10, floatLargeArray.getFloat(l10) + f5);
            floatLargeArray.setFloat(l10 + 1L, floatLargeArray.getFloat(l10 + 1L) - f6);
        }
    }

    private static void rftbsub(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            float f = 0.5f - fArray2[n4 + n3 - (n7 += n6)];
            float f2 = fArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            float f3 = fArray[n9] - fArray[n10];
            float f4 = fArray[n9 + 1] + fArray[n10 + 1];
            float f5 = f * f3 + f2 * f4;
            float f6 = f * f4 - f2 * f3;
            int n11 = n9;
            fArray[n11] = fArray[n11] - f5;
            int n12 = n9 + 1;
            fArray[n12] = fArray[n12] - f6;
            int n13 = n10;
            fArray[n13] = fArray[n13] + f5;
            int n14 = n10 + 1;
            fArray[n14] = fArray[n14] - f6;
        }
    }

    private static void rftbsub(long l, FloatLargeArray floatLargeArray, long l2, long l3, FloatLargeArray floatLargeArray2, long l4) {
        long l5 = l >> 1;
        long l6 = 2L * l3 / l5;
        long l7 = 0L;
        for (long i = 2L; i < l5; i += 2L) {
            long l8 = l - i;
            float f = 0.5f - floatLargeArray2.getFloat(l4 + l3 - (l7 += l6));
            float f2 = floatLargeArray2.getFloat(l4 + l7);
            long l9 = l2 + i;
            long l10 = l2 + l8;
            float f3 = floatLargeArray.getFloat(l9) - floatLargeArray.getFloat(l10);
            float f4 = floatLargeArray.getFloat(l9 + 1L) + floatLargeArray.getFloat(l10 + 1L);
            float f5 = f * f3 + f2 * f4;
            float f6 = f * f4 - f2 * f3;
            floatLargeArray.setFloat(l9, floatLargeArray.getFloat(l9) - f5);
            floatLargeArray.setFloat(l9 + 1L, floatLargeArray.getFloat(l9 + 1L) - f6);
            floatLargeArray.setFloat(l10, floatLargeArray.getFloat(l10) + f5);
            floatLargeArray.setFloat(l10 + 1L, floatLargeArray.getFloat(l10 + 1L) - f6);
        }
    }
}

