/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame.sequence;

import icy.gui.component.sequence.SequenceChooser;
import icy.gui.frame.ActionFrame;
import icy.gui.util.ComponentUtil;
import icy.main.Icy;
import icy.sequence.Sequence;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SequenceActionFrame
extends ActionFrame {
    private final SequenceChooser sequenceSelector;
    private final ArrayList<SourceChangeListener> sourceChangeListeners = new ArrayList();

    public SequenceActionFrame(String title, boolean resizable, boolean iconifiable) {
        super(title, resizable, iconifiable);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        JPanel sourcePanel = new JPanel();
        sourcePanel.setBorder(BorderFactory.createTitledBorder("Select the source"));
        sourcePanel.setLayout(new BoxLayout(sourcePanel, 3));
        ComponentUtil.setFixedHeight(sourcePanel, 58);
        JPanel sequenceSelectPanel = new JPanel();
        sequenceSelectPanel.setLayout(new BoxLayout(sequenceSelectPanel, 2));
        JLabel sequenceSelectLabel = new JLabel("Sequence  ");
        this.sequenceSelector = new SequenceChooser(true, null, 48);
        this.sequenceSelector.setSelectedSequence(Icy.getMainInterface().getActiveSequence());
        this.sequenceSelector.setMinimumSize(new Dimension(100, 24));
        this.sequenceSelector.addListener(new SequenceChooser.SequenceChooserListener(){

            @Override
            public void sequenceChanged(Sequence sequence) {
                SequenceActionFrame.this.fireSequenceChangeEvent();
            }
        });
        sequenceSelectPanel.add(Box.createHorizontalStrut(10));
        sequenceSelectPanel.add(sequenceSelectLabel);
        sequenceSelectPanel.add(this.sequenceSelector);
        sequenceSelectPanel.add(Box.createHorizontalStrut(10));
        sourcePanel.add(sequenceSelectPanel);
        this.mainPanel.add(sourcePanel);
    }

    public SequenceActionFrame(String title, boolean resizable) {
        this(title, resizable, false);
    }

    public SequenceActionFrame(String title) {
        this(title, false, false);
    }

    public Sequence getSequence() {
        return this.sequenceSelector.getSelectedSequence();
    }

    public void addSourceChangeListener(SourceChangeListener listener) {
        if (!this.sourceChangeListeners.contains(listener)) {
            this.sourceChangeListeners.add(listener);
        }
    }

    public void removeSourceChangeListener(SourceChangeListener listener) {
        this.sourceChangeListeners.remove(listener);
    }

    void fireSequenceChangeEvent() {
        Sequence sequence = this.getSequence();
        for (SourceChangeListener listener : this.sourceChangeListeners) {
            listener.sequenceChanged(sequence);
        }
    }

    public static interface SourceChangeListener {
        public void sequenceChanged(Sequence var1);
    }
}

