package plugins.nchenouard.trackprocessorperformance;

import icy.file.FileUtil;
import icy.file.xls.XlsManager;
import icy.plugin.abstract_.PluginActionable;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;
import plugins.nchenouard.trackprocessorchallengetracksimporter.TrackExportAndImportUtilities;

public class BatchMSDsandDistanceComputation extends PluginActionable
{
	static int cntThread = 0;
	static File[] refFiles;
	static File[] cFiles;
	static File cDir;
	static int numThread = 8;
	static Thread[] threadTab = new Thread[numThread];
	static String[] forbiddenFiles;

	@Override
	public void run()
	{
		File refDir = new File("C:/Users/nicolas/Documents/trackingChallenge2012/PTC2012/GroundTruth");
		refFiles = refDir.listFiles();

		cDir = new File("C:/Users/nicolas/Documents/trackingChallenge2012/PTC2012/Team08");
		cFiles = cDir.listFiles();

//		forbiddenFiles = new String[]{"MIC_H", "MIC_L"};
//		for (int k = 0; k < threadTab.length; k++)
//		{
//			threadTab[k] = new ComputationThread();
//		}
//
//		for (Thread th:threadTab)
//			th.start();

		forbiddenFiles = new String[]{"none"};
		computeMSDS();
	}

	class ComputationThread extends Thread
	{
		@Override
		public void run()
		{
			while (cntThread < refFiles.length)
			{
				File f = refFiles[cntThread++];
				if (f.getName().endsWith(".xml"))
				{
					boolean forbidden = false;
					for (String s:forbiddenFiles)
					{
						if (f.getName().startsWith(s))
							forbidden = true;
					}
					if (!forbidden)
					{
						for (File fc:cFiles)
						{
							if (fc.getName().equals(f.getName()))
							{
								System.out.println(f.getName());
								// load tracks
								ArrayList<TrackSegment> tracks = new ArrayList<TrackSegment>();
								ArrayList<TrackSegment> cTracks = new ArrayList<TrackSegment>();
								try
								{
									tracks.addAll(TrackExportAndImportUtilities.importTracksFile(f));
									cTracks.addAll(TrackExportAndImportUtilities.importTracksFile(fc));
								}
								catch (Exception e) {
									e.printStackTrace();
									return;
								}

								// pair them
								OneToOneMatcher matcher = new OneToOneMatcher(tracks, cTracks);
								DistanceTypes distType = DistanceTypes.DISTANCE_EUCLIDIAN;
								try {
									ArrayList<TrackPair> pairs = matcher.pairTracks(5, distType, true);
									PerformanceAnalyzer analyzer = new PerformanceAnalyzer(tracks, cTracks, pairs);


									// display distance between reference tracks and paired tracks
									try {
										BufferedWriter out = new BufferedWriter(new FileWriter("C:/Users/nicolas/Documents/"+ f.getName()+"_distance.txt"));
										out.write("track to track distance:\n");
										for (TrackPair tp:pairs)
										{
											TrackToTrackDistance d = new TrackToTrackDistance(tp.referenceTrack, tp.candidateTrack, distType, 5);
											out.write(d.distance + "\t");
										}
										out.write("\ntrack to track distance, normalized by reference track length: \n");
										for (TrackPair tp:pairs)
										{
											TrackToTrackDistance d = new TrackToTrackDistance(tp.referenceTrack, tp.candidateTrack, distType, 5);
											out.write((d.distance / tp.referenceTrack.getDetectionList().size()) + "\t");
										}
										out.close();
									} catch (IOException e) {}

									try {
										BufferedWriter out = new BufferedWriter(new FileWriter("C:/Users/nicolas/Documents/"+ f.getName()+"_msds.txt"));
										double[] msds = analyzer.getCandidateTracksMSDs();
										double[] refMsds = analyzer.getReferenceTracksMSDs();
										out.write("reference tracks msds:\n");
										for (int i = 0; i < msds.length; i++)
											out.write(msds[i] + "\t");
										out.write("\n");
										out.write("candidate tracks msds:\n");
										for (int i = 0; i < msds.length; i++)
											out.write(refMsds[i] + "\t");        	
										out.close();
									} catch (IOException e) {}


								} catch (Exception e) {
									e.printStackTrace();
									return;
								}
							}
						}

					}
				}
			}
			System.out.println("Thread ended");
		}
	}


	public void computeMSDS()
	{
		File XLSFile = new File ( cDir.getAbsolutePath() + FileUtil.separator + "msds.xls" );
		ArrayList<double[]> msd = new ArrayList<double[]>();
		ArrayList<double[]> msdStd = new ArrayList<double[]>();
		int maxTGap = 30;
		for (int i = 0; i < cFiles.length; i ++)
		{
			File f = cFiles[i];
			System.out.println(f.getName());
			boolean forbidden = false;
			for (String s:forbiddenFiles)
			{
				if (f.getName().startsWith(s))
					forbidden = true;
			}
			forbidden = forbidden || !f.getName().endsWith(".xml");
			if (!forbidden)
			{
				ArrayList<TrackSegment> cTracks = new ArrayList<TrackSegment>();
				try
				{
					cTracks.addAll(TrackExportAndImportUtilities.importTracksFile(f));
				}
				catch (Exception e) {
					e.printStackTrace();
					return;
				}
				double[][] msdTab = getMSDs(cTracks, maxTGap);
				msd.add(msdTab[0]);
				msdStd.add(msdTab[1]);
			}
		}
		XlsManager xlsManager;
		try {
			xlsManager = new XlsManager( XLSFile );
			xlsManager.createNewPage("MSDs");
			xlsManager.setLabel( 0 , 0 , "delta t Squared" );
			for (int k = 1; k <= maxTGap; k++)
				xlsManager.setLabel( 0 , k , Integer.toString(k*k));
			int cnt = 0;
			for (int i = 0; i < cFiles.length; i ++)
			{
				File f = cFiles[i];
				boolean forbidden = false;
				for (String s:forbiddenFiles)
				{
					if (f.getName().startsWith(s))
						forbidden = true;
				}
				forbidden = forbidden || !f.getName().endsWith(".xml");
				if (!forbidden)
				{
					xlsManager.setLabel( cnt + 1 , 0 , f.getName());
					double[] m = msd.get(cnt);
					for (int k = 0; k < m.length; k++)
					{
						if (m[k] > 0)
							xlsManager.setLabel( cnt + 1 , k + 1 , Double.toString(m[k]));
					}
					cnt++;
				}
			}
			xlsManager.createNewPage("MSD standard deviation");
			xlsManager.setLabel( 0 , 0 , "delta t Squared" );
			for (int k = 1; k <= maxTGap; k++)
				xlsManager.setLabel( 0 , k , Integer.toString(k*k));
			cnt = 0;
			for (int i = 0; i < cFiles.length; i ++)
			{
				File f = cFiles[i];
				boolean forbidden = false;
				for (String s:forbiddenFiles)
				{
					if (f.getName().startsWith(s))
						forbidden = true;
				}
				forbidden = forbidden || !f.getName().endsWith(".xml");
				if (!forbidden)
				{
					xlsManager.setLabel( cnt + 1, 0 , f.getName());
					double[] m = msdStd.get(cnt);
					for (int k = 0; k < m.length; k++)
					{
						if (m[k] > 0)
							xlsManager.setLabel( cnt + 1 , k + 1 , Double.toString(m[k]));
					}
					cnt++;
				}
			}
			xlsManager.SaveAndClose();
		} catch (IOException e1) {
			e1.printStackTrace();
		}
	}

	protected double[][] getMSDs(ArrayList<TrackSegment> tracks, int maxTGap)
	{
		double[] msds = new double[maxTGap];
		double[] msdSq = new double[maxTGap];
		int[] numJumps = new int[maxTGap];

		for (TrackSegment ts:tracks)
		{
			for (int tGap = 1; tGap <= maxTGap; tGap++)
			{
				int firstT = ts.getFirstDetection().getT();
				int lastT = ts.getLastDetection().getT();

				for (int t = firstT; t <= lastT - tGap; t++)
				{
					Detection d1 = ts.getDetectionAtTime(t);
					if (d1 != null && d1.getX() != Double.NaN && d1.getY() != Double.NaN && d1.getZ() != Double.NaN)
					{
						Detection d2 = ts.getDetectionAtTime(t + tGap);
						if (d2 != null && d2.getX() != Double.NaN && d2.getY() != Double.NaN && d2.getZ() != Double.NaN)
						{
							numJumps[tGap - 1] ++;
						}
					}
				}
			}
		}
		
		for (TrackSegment ts:tracks)
		{
			for (int tGap = 1; tGap <= maxTGap; tGap++)
			{
				int firstT = ts.getFirstDetection().getT();
				int lastT = ts.getLastDetection().getT();

				for (int t = firstT; t <= lastT - tGap; t++)
				{
					Detection d1 = ts.getDetectionAtTime(t);
					if (d1 != null && d1.getX() != Double.NaN && d1.getY() != Double.NaN && d1.getZ() != Double.NaN)
					{
						Detection d2 = ts.getDetectionAtTime(t + tGap);
						if (d2 != null && d2.getX() != Double.NaN && d2.getY() != Double.NaN && d2.getZ() != Double.NaN)
						{
							double d = (d1.getX() - d2.getX())*(d1.getX() - d2.getX()) + (d1.getY() - d2.getY())*(d1.getY() - d2.getY()) + (d1.getZ() - d2.getZ())*(d1.getZ() - d2.getZ());
							msds[tGap - 1] += d/numJumps[tGap - 1];
							msdSq[tGap - 1] += d*d/numJumps[tGap - 1];
						}
					}
				}
			}
		}
		for (int k = 0; k < msds.length; k++)
			if (numJumps[k] > 0)
				msdSq[k] = Math.sqrt(msdSq[k] - msds[k]*msds[k]);				
		double[][] msdTab = new double[2][];
		msdTab[0] = msds;
		msdTab[1] = msdSq;
		return msdTab;
	}
} 