/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;

public class VerticalTransformSubset
extends VerticalTransformImpl {
    private VerticalTransform original;
    private Range t_range;
    private List<Range> subsetList = new ArrayList<Range>();

    public VerticalTransformSubset(VerticalTransform original, Range t_range, Range z_range, Range y_range, Range x_range) {
        super(null);
        this.original = original;
        this.t_range = t_range;
        this.subsetList.add(z_range);
        this.subsetList.add(y_range);
        this.subsetList.add(x_range);
        this.units = original.getUnitString();
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int subsetIndex) throws IOException, InvalidRangeException {
        int orgIndex = subsetIndex;
        if (this.isTimeDependent() && this.t_range != null) {
            orgIndex = this.t_range.element(subsetIndex);
        }
        ArrayDouble.D3 data = this.original.getCoordinateArray(orgIndex);
        return (ArrayDouble.D3)data.sectionNoReduce(this.subsetList);
    }

    @Override
    public ArrayDouble.D1 getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) throws IOException, InvalidRangeException {
        ArrayDouble.D3 data = this.original.getCoordinateArray(timeIndex);
        int[] origin = new int[3];
        int[] shape = new int[]{this.subsetList.get(0).length(), 1, 1};
        origin[0] = timeIndex;
        if (this.isTimeDependent() && this.t_range != null) {
            origin[0] = this.t_range.element(timeIndex);
        }
        origin[1] = yIndex;
        origin[2] = xIndex;
        Array section = data.section(origin, shape);
        return (ArrayDouble.D1)section.reduce();
    }

    @Override
    public boolean isTimeDependent() {
        return this.original.isTimeDependent();
    }
}

