/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.core;

import icy.gui.viewer.Viewer;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.util.StringUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.api.SequenceSettings;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManager.tools.MMUtils;

public class AcquisitionResult {
    protected final Map<Integer, Sequence> sequences;
    protected final SequenceSettings settings;
    protected final JSONObject summaryMetadata;
    protected final boolean dateSuffix;
    protected final long startTime;
    protected boolean done;

    public AcquisitionResult(SequenceSettings settings, JSONObject summaryMetadata, boolean dateSuffix) {
        this.settings = settings;
        this.summaryMetadata = summaryMetadata;
        this.dateSuffix = dateSuffix;
        this.sequences = new HashMap<Integer, Sequence>();
        this.startTime = Calendar.getInstance().getTimeInMillis();
        this.done = false;
    }

    public List<Sequence> getSequences() {
        return new ArrayList<Sequence>(this.sequences.values());
    }

    public void imageReceived(TaggedImage taggedImage) throws JSONException, MMScriptException {
        Viewer viewer;
        JSONObject tags = taggedImage.tags;
        Integer position = MDUtils.getPositionIndex((JSONObject)tags);
        Sequence seq = this.sequences.get(position);
        if (seq == null) {
            String positionName = MDUtils.getPositionName((JSONObject)tags);
            seq = new Sequence(this.settings.prefix + (!StringUtil.isEmpty((String)positionName) && this.settings.usePositionList ? " - " + positionName : "") + (this.dateSuffix ? " - " + MMUtils.getDateString() : ""));
            this.sequences.put(position, seq);
            if (MicroManager.getDisplayAcquisitionSequence()) {
                Icy.getMainInterface().addSequence(seq);
            }
        }
        MMUtils.setImage(seq, taggedImage, this.startTime);
        if (seq.getNumImage() == 1) {
            MMUtils.setMetadata(seq, this.summaryMetadata);
        }
        if ((viewer = seq.getFirstViewer()) != null) {
            int t = MDUtils.getFrameIndex((JSONObject)tags);
            int z = MDUtils.getSliceIndex((JSONObject)tags);
            viewer.setPositionT(t);
            viewer.setPositionZ(z);
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public void done() {
        this.done = true;
        for (Sequence sequence : this.sequences.values()) {
        }
    }
}

