/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols;

import icy.common.Version;
import icy.file.FileUtil;
import icy.main.Icy;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.PluginActionable;
import icy.preferences.PluginsPreferences;
import icy.preferences.XMLPreferences;
import icy.system.thread.ThreadUtil;
import icy.util.XMLUtil;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.blocks.util.BlocksML;
import plugins.adufour.blocks.util.BlocksReloadedException;
import plugins.adufour.protocols.gui.MainFrame;
import plugins.adufour.protocols.gui.ProtocolPanel;

public class Protocols
extends PluginActionable {
    public static final int MENU_SHORTCUT_KEY = GraphicsEnvironment.isHeadless() ? 0 : Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String PREF_FOLDER = "protocolFolder";
    private static MainFrame mainFrame;
    private static boolean reloading;
    public static final String downloadedProtocolFolder;
    private static volatile XMLPreferences preferences;
    private static final LinkedHashMap<String, String> commandLineArguments;

    public static String getDefaultProtocolFolder() {
        return preferences.get(PREF_FOLDER, System.getProperty("user.home"));
    }

    public static void setDefaultProtocolFolder(String path) {
        preferences.put(PREF_FOLDER, path);
    }

    public static MainFrame getInstance() {
        return mainFrame;
    }

    public static boolean isReloading() {
        return reloading;
    }

    public static void setReloading(boolean value) {
        reloading = value;
    }

    public void reload(Document reloadingXML, String reloadingPath) {
        if (mainFrame == null) {
            return;
        }
        reloading = true;
        preferences.putInt("Window X", mainFrame.getX());
        preferences.putInt("Window Y", mainFrame.getY());
        int counter = 1;
        for (ProtocolPanel protocol : mainFrame.getProtocolPanels()) {
            try {
                File attachedFile = protocol.getFile();
                String xmlProtocol = attachedFile != null && attachedFile.getAbsolutePath().equals(reloadingPath) ? BlocksML.getInstance().toString(reloadingXML) : BlocksML.getInstance().toString(protocol.getWorkFlow());
                XMLPreferences node = preferences.node("Protocol #" + counter++);
                node.putBoolean("dirty", protocol.isDirty());
                node.put("xml", xmlProtocol);
                if (attachedFile == null) continue;
                node.put("fileName", attachedFile.getAbsolutePath());
            }
            catch (TransformerException e) {
                System.err.println("Warning: couldn't store protocol " + protocol.getName() + ":");
                e.printStackTrace();
                System.err.println("---");
            }
        }
        Protocols.close();
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ((PluginActionable)PluginLoader.getPluginClass((String)Protocols.class.getName()).newInstance()).run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static Map<String, String> getCommandLineArguments() {
        return commandLineArguments;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block16: {
            if (Icy.getMainInterface().isHeadLess()) {
                Protocols.runHeadless();
                return;
            }
            if (mainFrame != null) {
                mainFrame.requestFocus();
                mainFrame.toFront();
                return;
            }
            mainFrame = new MainFrame(this);
            try {
                int x = preferences.getInt("Window X", mainFrame.getX());
                int y = preferences.getInt("Window Y", mainFrame.getY());
                mainFrame.setLocation(x, y);
                String protocolPath = Protocols.parseCommandLineArgs(false);
                if (protocolPath != null) {
                    ProtocolPanel panel = new ProtocolPanel(mainFrame);
                    Document xml = XMLUtil.loadDocument((String)protocolPath);
                    if (xml != null) {
                        panel.setFile(new File(protocolPath));
                    }
                    mainFrame.addProtocolPane(panel);
                    if (xml == null) break block16;
                    try {
                        panel.loadWorkFlow(xml, true);
                        break block16;
                    }
                    catch (BlocksReloadedException e) {
                        this.reload(xml, panel.getFile().getAbsolutePath());
                        return;
                    }
                }
                ArrayList protocols = preferences.getChildren();
                if (protocols.size() == 0) {
                    mainFrame.addProtocolPane(new ProtocolPanel(mainFrame));
                } else {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    for (XMLPreferences node : preferences.getChildren()) {
                        ProtocolPanel panel = new ProtocolPanel(mainFrame);
                        String fileName = node.get("fileName", null);
                        if (fileName != null) {
                            panel.setFile(new File(fileName));
                        }
                        mainFrame.addProtocolPane(panel);
                        Document xml = builder.parse(new InputSource(new StringReader(node.get("xml", null))));
                        try {
                            panel.loadWorkFlow(xml, node.getBoolean("dirty", false));
                            preferences.remove(node.name());
                        }
                        catch (BlocksReloadedException e) {
                            this.reload(xml, panel.getFile().getAbsolutePath());
                            return;
                        }
                    }
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        mainFrame.addToDesktopPane();
        mainFrame.setVisible(true);
    }

    private static String parseCommandLineArgs(boolean verify) {
        String[] clargs = Icy.getCommandLinePluginArgs();
        String result = null;
        boolean ok = false;
        for (String clarg : clargs) {
            if (!clarg.contains("=")) {
                if (!verify) continue;
                throw new IllegalArgumentException("Invalid command line argument: " + clarg);
            }
            String[] keyValuePair = clarg.split("=");
            if (keyValuePair.length != 2) {
                if (!verify) continue;
                throw new IllegalArgumentException("Invalid command line argument: " + clarg);
            }
            String key = keyValuePair[0];
            String value = keyValuePair[1];
            if (key.isEmpty()) {
                if (!verify) continue;
                throw new IllegalArgumentException("Invalid command line argument (no key): " + clarg);
            }
            if (value.isEmpty()) {
                if (!verify) continue;
                throw new IllegalArgumentException("Invalid command line argument (no value): " + clarg);
            }
            if (key.equalsIgnoreCase("protocol")) {
                result = value;
                ok = true;
                continue;
            }
            commandLineArguments.put(key, value);
        }
        if (ok) {
            Icy.clearCommandLinePluginArgs();
        }
        return result;
    }

    private static void runHeadless() {
        String protocolFile = Protocols.parseCommandLineArgs(true);
        Document xml = XMLUtil.loadDocument((String)protocolFile);
        if (xml == null) {
            throw new IllegalArgumentException(protocolFile + " is not a valid protocol file");
        }
        System.out.println("Loading workflow...");
        WorkFlow workFlow = new WorkFlow(true);
        BlocksML.getInstance().loadWorkFlow(xml, workFlow);
        workFlow.run();
    }

    public static void loadWorkFlow(File file) {
        if (mainFrame == null) {
            new Protocols().run();
        }
        mainFrame.loadWorkFlow(file);
    }

    public static void close() {
        if (mainFrame != null && mainFrame.isVisible()) {
            mainFrame.close();
        }
        mainFrame = null;
    }

    public static void dispatchEvent(KeyEvent key) {
        if (mainFrame != null) {
            mainFrame.getContentPane().dispatchEvent(key);
        }
    }

    public String getFriendlyVersion() {
        Version v = this.getDescriptor().getVersion();
        return "Blocks engine v." + v.getMajor() + "." + v.getMinor();
    }

    static {
        reloading = false;
        downloadedProtocolFolder = FileUtil.getApplicationDirectory() + File.separator + "protocols";
        preferences = PluginsPreferences.getPreferences().node(Protocols.class.getName());
        commandLineArguments = new LinkedHashMap();
    }
}

