/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;

public enum CharacterEncoding {
    ASCII("ASCII", HDF5Constants.H5T_CSET_ASCII, 1),
    UTF8("UTF8", HDF5Constants.H5T_CSET_UTF8, 4);

    private final String charSetName;
    private final int cValue;
    private final int maxBytesPerChar;

    private CharacterEncoding(String charSetName, int cValue, int maxBytesPerChar) {
        this.charSetName = charSetName;
        this.cValue = cValue;
        this.maxBytesPerChar = maxBytesPerChar;
    }

    int getCValue() {
        return this.cValue;
    }

    String getCharSetName() {
        return this.charSetName;
    }

    int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    static CharacterEncoding fromCValue(int cValue) throws IllegalArgumentException {
        if (cValue == HDF5Constants.H5T_CSET_ASCII) {
            return ASCII;
        }
        if (cValue == HDF5Constants.H5T_CSET_UTF8) {
            return UTF8;
        }
        throw new IllegalArgumentException("Illegal character encoding id " + cValue);
    }
}

