/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.optim.LineSearch;
import mitiv.optim.LineSearchTask;
import mitiv.optim.OptimStatus;

public class NonmonotoneLineSearch
extends LineSearch {
    private double sigma1 = 0.1;
    private double sigma2 = 0.9;
    private double ftol = 1.0E-4;
    private double[] fsav;
    private double fmax = Double.NEGATIVE_INFINITY;
    private final int m;
    private int mp;

    public double getTolerance() {
        return this.ftol;
    }

    public void setTolerance(double ftol) {
        if (Double.isNaN(ftol) || ftol <= 0.0 || ftol >= 1.0) {
            throw new IllegalArgumentException();
        }
        this.ftol = ftol;
    }

    public double getLowerBound() {
        return this.sigma1;
    }

    public double getUpperBound() {
        return this.sigma2;
    }

    public void setBounds(double lower, double upper) {
        if (Double.isNaN(lower) || Double.isNaN(upper) || lower <= 0.0 || lower >= upper || upper >= 1.0) {
            throw new IllegalArgumentException();
        }
        this.sigma1 = lower;
        this.sigma2 = upper;
    }

    public NonmonotoneLineSearch() {
        this(10);
    }

    public NonmonotoneLineSearch(int m) {
        if (m < 1) {
            m = 1;
        }
        this.m = m;
        this.fsav = new double[m];
        this.reset();
    }

    @Override
    public boolean useDerivative() {
        return true;
    }

    private void reset() {
        this.mp = 0;
        for (int k = 0; k < this.m; ++k) {
            this.fsav[k] = Double.NEGATIVE_INFINITY;
        }
    }

    @Override
    protected void startHook() {
        this.fsav[this.mp % this.m] = this.finit;
        ++this.mp;
        int n = Math.min(this.mp, this.mp);
        this.fmax = this.fsav[0];
        for (int k = 1; k < n; ++k) {
            if (!(this.fmax < this.fsav[k])) continue;
            this.fmax = this.fsav[k];
        }
        this.success(LineSearchTask.SEARCH);
    }

    @Override
    public void iterateHook(double f, double g) {
        if (f <= this.fmax + this.stp * this.ftol * this.ginit) {
            this.success(LineSearchTask.CONVERGENCE);
            return;
        }
        if (this.stp <= this.stpmin) {
            this.stp = this.stpmin;
            this.warning(OptimStatus.STEP_EQ_STPMIN);
            return;
        }
        double q = -this.ginit * this.stp * this.stp;
        double r = (f - this.finit - this.stp * this.ginit) * 2.0;
        this.stp = r > 0.0 && this.sigma1 * r <= q && q <= this.sigma2 * r * this.stp ? q / r : (this.stp + this.stpmin) / 2.0;
        this.stp = Math.max(this.stp, this.stpmin);
        if (this.stp > 0.0) {
            this.success(LineSearchTask.SEARCH);
        } else {
            this.warning(OptimStatus.STEP_EQ_STPMIN);
        }
    }

    public static void main(String[] args) {
        NonmonotoneLineSearch lineSearch = new NonmonotoneLineSearch(10);
        double alpha = 12.0;
        double f0 = 0.0;
        double g0 = -1.0;
        double h0 = 5.0;
        LineSearchTask state = lineSearch.start(f0, g0, alpha, 0.0, 1.0E20 * alpha);
        System.out.println("state = " + (Object)((Object)state));
        System.out.println("finished = " + lineSearch.finished());
        for (int k = 1; k <= 6; ++k) {
            alpha = lineSearch.getStep();
            double f1 = f0 + alpha * (g0 + 0.5 * h0 * alpha);
            double g1 = g0 + h0 * alpha;
            state = lineSearch.iterate(f1, g1);
            System.out.println("alpha[" + k + "] = " + alpha + "; f[" + k + "] = " + f1 + "; g[" + k + "] = " + g1 + "; state[" + k + "] = " + (Object)((Object)state) + "; finished[" + k + "] = " + lineSearch.finished() + ";");
        }
    }
}

