/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array2D;
import mitiv.array.Byte2D;
import mitiv.array.Double1D;
import mitiv.array.DoubleArray;
import mitiv.array.Float2D;
import mitiv.array.Int2D;
import mitiv.array.Long2D;
import mitiv.array.ShapedArray;
import mitiv.array.Short2D;
import mitiv.array.impl.FlatDouble2D;
import mitiv.array.impl.StriddenDouble2D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double2D
extends Array2D
implements DoubleArray {
    protected Double2D(int dim1, int dim2) {
        super(dim1, dim2);
    }

    protected Double2D(int[] dims) {
        super(dims);
    }

    protected Double2D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2);

    public abstract void set(int var1, int var2, double var3);

    @Override
    public void fill(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, value);
                }
            }
        }
    }

    @Override
    public void increment(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, this.get(i1, i2) + value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, this.get(i1, i2) + value);
                }
            }
        }
    }

    @Override
    public void decrement(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, this.get(i1, i2) - value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, this.get(i1, i2) - value);
                }
            }
        }
    }

    @Override
    public void scale(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, this.get(i1, i2) * value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, this.get(i1, i2) * value);
                }
            }
        }
    }

    @Override
    public void map(DoubleFunction function) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, function.apply(this.get(i1, i2)));
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, function.apply(this.get(i1, i2)));
                }
            }
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, generator.nextDouble());
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, generator.nextDouble());
                }
            }
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    if (initialized) {
                        scanner.update(this.get(i1, i2));
                        continue;
                    }
                    scanner.initialize(this.get(i1, i2));
                    initialized = true;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    if (initialized) {
                        scanner.update(this.get(i1, i2));
                        continue;
                    }
                    scanner.initialize(this.get(i1, i2));
                    initialized = true;
                }
            }
        }
    }

    @Override
    public final double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double minValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    double value = this.get(i1, i2);
                    if (!(value < minValue)) continue;
                    minValue = value;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    double value = this.get(i1, i2);
                    if (!(value < minValue)) continue;
                    minValue = value;
                }
            }
        }
        return minValue;
    }

    @Override
    public double max() {
        double maxValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    double value = this.get(i1, i2);
                    if (!(value > maxValue)) continue;
                    maxValue = value;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    double value = this.get(i1, i2);
                    if (!(value > maxValue)) continue;
                    maxValue = value;
                }
            }
        }
        return maxValue;
    }

    @Override
    public double[] getMinAndMax() {
        double[] result = new double[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(double[] mm) {
        double minValue;
        double maxValue = minValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    double value = this.get(i1, i2);
                    if (value < minValue) {
                        minValue = value;
                    }
                    if (!(value > maxValue)) continue;
                    maxValue = value;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    double value = this.get(i1, i2);
                    if (value < minValue) {
                        minValue = value;
                    }
                    if (!(value > maxValue)) continue;
                    maxValue = value;
                }
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public double sum() {
        double totalValue = 0.0;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    totalValue += this.get(i1, i2);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    totalValue += this.get(i1, i2);
                }
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte2D toByte() {
        byte[] out = new byte[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (byte)inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = (byte)this.get(i1, i2);
                }
            }
        }
        return Byte2D.wrap(out, this.getShape());
    }

    @Override
    public Short2D toShort() {
        short[] out = new short[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (short)inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = (short)this.get(i1, i2);
                }
            }
        }
        return Short2D.wrap(out, this.getShape());
    }

    @Override
    public Int2D toInt() {
        int[] out = new int[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (int)inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = (int)this.get(i1, i2);
                }
            }
        }
        return Int2D.wrap(out, this.getShape());
    }

    @Override
    public Long2D toLong() {
        long[] out = new long[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (long)inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = (long)this.get(i1, i2);
                }
            }
        }
        return Long2D.wrap(out, this.getShape());
    }

    @Override
    public Float2D toFloat() {
        float[] out = new float[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (float)inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = (float)this.get(i1, i2);
                }
            }
        }
        return Float2D.wrap(out, this.getShape());
    }

    @Override
    public Double2D toDouble() {
        return this;
    }

    @Override
    public Double2D copy() {
        return new FlatDouble2D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Double2D src = arr.getType() == 5 ? (Double2D)arr : (Double2D)arr.toDouble();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, src.get(i1, i2));
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, src.get(i1, i2));
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, src.get(++i));
                }
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, src.get(++i));
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double2D create() {
        return new FlatDouble2D(this.getShape());
    }

    public static Double2D create(int dim1, int dim2) {
        return new FlatDouble2D(dim1, dim2);
    }

    public static Double2D create(int[] dims) {
        return new FlatDouble2D(dims);
    }

    public static Double2D create(Shape shape) {
        return new FlatDouble2D(shape);
    }

    public static Double2D wrap(double[] data, int dim1, int dim2) {
        return new FlatDouble2D(data, dim1, dim2);
    }

    public static Double2D wrap(double[] data, int[] dims) {
        return new FlatDouble2D(data, dims);
    }

    public static Double2D wrap(double[] data, Shape shape) {
        return new FlatDouble2D(data, shape);
    }

    public static Double2D wrap(double[] data, int offset, int stride1, int stride2, int dim1, int dim2) {
        return new StriddenDouble2D(data, offset, stride1, stride2, dim1, dim2);
    }

    @Override
    public abstract Double1D slice(int var1);

    @Override
    public abstract Double1D slice(int var1, int var2);

    @Override
    public abstract Double2D view(Range var1, Range var2);

    @Override
    public abstract Double2D view(int[] var1, int[] var2);

    @Override
    public abstract Double1D as1D();
}

