/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

public class ImageSequence
implements TextureSequence {
    private final int textureUnit;
    private final boolean useBuildInTexLookup;
    private final List<TextureSequence.TextureFrame> frames = new ArrayList<TextureSequence.TextureFrame>();
    private final int[] texMinMagFilter = new int[]{9728, 9728};
    private final int[] texWrapST = new int[]{33071, 33071};
    private volatile int frameIdx = 0;
    private volatile boolean manualStepping = false;
    private int textureFragmentShaderHashCode = 0;
    private String textureLookupFunctionName = "myTexture2D";

    public ImageSequence(int n, boolean bl) {
        this.textureUnit = n;
        this.useBuildInTexLookup = bl;
    }

    public void setParams(int n, int n2, int n3, int n4) {
        this.texMinMagFilter[0] = n2;
        this.texMinMagFilter[1] = n;
        this.texWrapST[0] = n3;
        this.texWrapST[1] = n4;
    }

    public final void addFrame(GL gL, Texture texture) {
        TextureSequence.TextureFrame textureFrame = new TextureSequence.TextureFrame(texture);
        this.frames.add(textureFrame);
        texture.bind(gL);
        gL.glTexParameteri(this.getTextureTarget(), 10241, this.texMinMagFilter[0]);
        gL.glTexParameteri(this.getTextureTarget(), 10240, this.texMinMagFilter[1]);
        gL.glTexParameteri(this.getTextureTarget(), 10242, this.texWrapST[0]);
        gL.glTexParameteri(this.getTextureTarget(), 10243, this.texWrapST[1]);
    }

    public final void addFrame(GL gL, Class<?> clazz, String string, String string2) throws IOException {
        URLConnection uRLConnection = IOUtil.getResource((String)string, (ClassLoader)clazz.getClassLoader(), clazz);
        if (null != uRLConnection) {
            TextureData textureData = TextureIO.newTextureData(GLProfile.getGL2ES2(), uRLConnection.getInputStream(), false, string2);
            Texture texture = new Texture(this.getTextureTarget());
            texture.updateImage(gL, textureData);
            this.addFrame(gL, texture);
        }
    }

    public final int getFrameCount() {
        return this.frames.size();
    }

    public final int getCurrentIdx() {
        return this.frameIdx;
    }

    public final void setCurrentIdx(int n) throws IndexOutOfBoundsException {
        if (0 > n || n >= this.frames.size()) {
            throw new IndexOutOfBoundsException("idx shall be within 0 <= " + n + " < " + this.frames.size());
        }
        this.frameIdx = n;
    }

    public final void setManualStepping(boolean bl) {
        this.manualStepping = bl;
    }

    public final boolean getManualStepping() {
        return this.manualStepping;
    }

    public final TextureSequence.TextureFrame getFrame(int n) {
        return this.frames.get(n);
    }

    public void destroy(GL gL) throws GLException {
        for (int i = this.frames.size() - 1; i >= 0; --i) {
            this.frames.get(i).getTexture().destroy(gL);
        }
        this.frames.clear();
    }

    @Override
    public int getTextureTarget() {
        return 3553;
    }

    @Override
    public int getTextureUnit() {
        return this.textureUnit;
    }

    @Override
    public int[] getTextureMinMagFilter() {
        return this.texMinMagFilter;
    }

    @Override
    public int[] getTextureWrapST() {
        return this.texWrapST;
    }

    @Override
    public boolean isTextureAvailable() {
        return this.frames.size() > 0;
    }

    @Override
    public TextureSequence.TextureFrame getLastTexture() throws IllegalStateException {
        return this.frames.get(this.frameIdx);
    }

    @Override
    public TextureSequence.TextureFrame getNextTexture(GL gL) throws IllegalStateException {
        if (!this.manualStepping) {
            this.frameIdx = (this.frameIdx + 1) % this.frames.size();
        }
        return this.frames.get(this.frameIdx);
    }

    @Override
    public String getRequiredExtensionsShaderStub() throws IllegalStateException {
        return "// TextTextureSequence: No extensions required\n";
    }

    @Override
    public String getTextureSampler2DType() throws IllegalStateException {
        return "sampler2D";
    }

    @Override
    public String getTextureLookupFunctionName(String string) throws IllegalStateException {
        if (this.useBuildInTexLookup) {
            return "texture2D";
        }
        if (null != string && string.length() > 0) {
            this.textureLookupFunctionName = string;
        }
        return this.textureLookupFunctionName;
    }

    @Override
    public String getTextureLookupFragmentShaderImpl() throws IllegalStateException {
        if (this.useBuildInTexLookup) {
            return "";
        }
        return "\nvec4 " + this.textureLookupFunctionName + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n  return texture2D(image, texCoord);\n}\n\n";
    }

    @Override
    public int getTextureFragmentShaderHashCode() {
        if (!this.isTextureAvailable()) {
            this.textureFragmentShaderHashCode = 0;
            return 0;
        }
        if (0 == this.textureFragmentShaderHashCode) {
            int n = 31 + this.getTextureLookupFragmentShaderImpl().hashCode();
            this.textureFragmentShaderHashCode = n = (n << 5) - n + this.getTextureSampler2DType().hashCode();
        }
        return this.textureFragmentShaderHashCode;
    }
}

