/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.editor;

import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class VisibleCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    private static final long serialVersionUID = -3974658249790735980L;
    protected JLabel label = new JLabel();
    int iconSize;
    boolean visible;

    public VisibleCellEditor(int iconSize) {
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                VisibleCellEditor.this.visible = !VisibleCellEditor.this.visible;
                VisibleCellEditor.this.stopCellEditing();
            }
        });
        this.iconSize = iconSize;
        this.visible = true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.visible;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.visible = (Boolean)value;
        if (this.visible) {
            this.label.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_VISIBLE, this.iconSize)));
        } else {
            this.label.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_NOT_VISIBLE, this.iconSize)));
        }
        if (isSelected) {
            this.label.setForeground(table.getSelectionForeground());
            this.label.setBackground(table.getSelectionBackground());
        } else {
            Color alternateColor;
            Color background = table.getBackground();
            if ((background == null || background instanceof UIResource) && (alternateColor = UIManager.getColor("Table.alternateRowColor")) != null && (row & 1) == 0) {
                background = alternateColor;
            }
            this.label.setForeground(table.getForeground());
            this.label.setBackground(background);
        }
        return this.label;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.visible = (Boolean)value;
        if (this.visible) {
            this.label.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_VISIBLE, this.iconSize)));
        } else {
            this.label.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_NOT_VISIBLE, this.iconSize)));
        }
        this.label.setForeground(tree.getForeground());
        this.label.setBackground(tree.getBackground());
        return this.label;
    }
}

