/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.model;

import plugins.adufour.vars.gui.model.RangeModel;

public class IntegerRangeModel
extends RangeModel<Integer> {
    public IntegerRangeModel(Integer defaultValue, Integer min, Integer max, Integer step) {
        this(defaultValue, min, max, step, RangeModel.RangeEditorType.SPINNER);
    }

    public IntegerRangeModel(Integer defaultValue, Integer min, Integer max, Integer step, RangeModel.RangeEditorType editorType) {
        super(defaultValue, min, max, step, editorType, null);
    }

    @Override
    public boolean isValid(Integer value) {
        return this.min.compareTo(value) <= 0 && this.max.compareTo(value) >= 0 && value % (Integer)this.step == 0;
    }

    @Override
    public int getRangeSize() {
        return ((Integer)this.max - (Integer)this.min) / (Integer)this.step;
    }

    @Override
    public Integer getValueForIndex(int index) {
        return (Integer)this.min + index * (Integer)this.step;
    }

    @Override
    public int indexOf(Integer value) {
        return Math.round((value - (Integer)this.min) / (Integer)this.step);
    }
}

