/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.logical;

import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;

public class ROIContainedDescriptor
extends ROIDescriptor {
    public static final String ID = "Contained";

    public ROIContainedDescriptor() {
        super(ID, ID, Double.class);
    }

    @Override
    public String getDescription() {
        return "Number of contained ROI(s)";
    }

    @Override
    public boolean separateChannel() {
        return false;
    }

    @Override
    public boolean needRecompute(SequenceEvent change) {
        return change.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_ROI;
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws InterruptedException {
        return ROIContainedDescriptor.computeContainedROIs(roi, sequence);
    }

    public static double computeContainedROIs(ROI roi, Sequence sequence) throws InterruptedException {
        if (roi == null || sequence == null) {
            return 0.0;
        }
        int result = 0;
        for (ROI r : sequence.getROIs()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (r == roi || r == null || !roi.contains(r)) continue;
            ++result;
        }
        return result;
    }
}

