/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Array2D;
import mitiv.array.Array3D;
import mitiv.array.Array4D;
import mitiv.array.Array5D;
import mitiv.array.Array6D;
import mitiv.array.Array7D;
import mitiv.array.Array8D;
import mitiv.array.Array9D;
import mitiv.array.ArrayFactory;
import mitiv.array.Byte1D;
import mitiv.array.Byte2D;
import mitiv.array.ByteArray;
import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.DoubleArray;
import mitiv.array.Float1D;
import mitiv.array.Float2D;
import mitiv.array.FloatArray;
import mitiv.array.Int1D;
import mitiv.array.Int2D;
import mitiv.array.IntArray;
import mitiv.array.Long1D;
import mitiv.array.Long2D;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.Short2D;
import mitiv.array.ShortArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.ArrayOps;

public class ArrayUtils {
    public static double sum(ShapedArray arr) {
        double sum = 0.0;
        if (arr != null) {
            switch (arr.getType()) {
                case 0: {
                    sum = ((ByteArray)arr).sum();
                    break;
                }
                case 1: {
                    sum = ((ShortArray)arr).sum();
                    break;
                }
                case 2: {
                    sum = ((IntArray)arr).sum();
                    break;
                }
                case 3: {
                    sum = ((LongArray)arr).sum();
                    break;
                }
                case 4: {
                    sum = ((FloatArray)arr).sum();
                    break;
                }
                case 5: {
                    sum = ((DoubleArray)arr).sum();
                }
            }
        }
        return sum;
    }

    public static byte[] toByte(byte[] src) {
        return src;
    }

    public static byte[] toByte(short[] src) {
        int number = src.length;
        byte[] dst = new byte[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (byte)src[j];
        }
        return dst;
    }

    public static byte[] toByte(int[] src) {
        int number = src.length;
        byte[] dst = new byte[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (byte)src[j];
        }
        return dst;
    }

    public static byte[] toByte(long[] src) {
        int number = src.length;
        byte[] dst = new byte[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (byte)src[j];
        }
        return dst;
    }

    public static byte[] toByte(float[] src) {
        int number = src.length;
        byte[] dst = new byte[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (byte)src[j];
        }
        return dst;
    }

    public static byte[] toByte(double[] src) {
        int number = src.length;
        byte[] dst = new byte[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (byte)src[j];
        }
        return dst;
    }

    public static short[] toShort(byte[] src) {
        int number = src.length;
        short[] dst = new short[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (short)(src[j] & 0xFF);
        }
        return dst;
    }

    public static short[] toShort(short[] src) {
        return src;
    }

    public static short[] toShort(int[] src) {
        int number = src.length;
        short[] dst = new short[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (short)src[j];
        }
        return dst;
    }

    public static short[] toShort(long[] src) {
        int number = src.length;
        short[] dst = new short[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (short)src[j];
        }
        return dst;
    }

    public static short[] toShort(float[] src) {
        int number = src.length;
        short[] dst = new short[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (short)src[j];
        }
        return dst;
    }

    public static short[] toShort(double[] src) {
        int number = src.length;
        short[] dst = new short[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (short)src[j];
        }
        return dst;
    }

    public static int[] toInt(byte[] src) {
        int number = src.length;
        int[] dst = new int[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j] & 0xFF;
        }
        return dst;
    }

    public static int[] toInt(short[] src) {
        int number = src.length;
        int[] dst = new int[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static int[] toInt(int[] src) {
        return src;
    }

    public static int[] toInt(long[] src) {
        int number = src.length;
        int[] dst = new int[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (int)src[j];
        }
        return dst;
    }

    public static int[] toInt(float[] src) {
        int number = src.length;
        int[] dst = new int[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (int)src[j];
        }
        return dst;
    }

    public static int[] toInt(double[] src) {
        int number = src.length;
        int[] dst = new int[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (int)src[j];
        }
        return dst;
    }

    public static long[] toLong(byte[] src) {
        int number = src.length;
        long[] dst = new long[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j] & 0xFF;
        }
        return dst;
    }

    public static long[] toLong(short[] src) {
        int number = src.length;
        long[] dst = new long[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static long[] toLong(int[] src) {
        int number = src.length;
        long[] dst = new long[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static long[] toLong(long[] src) {
        return src;
    }

    public static long[] toLong(float[] src) {
        int number = src.length;
        long[] dst = new long[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (long)src[j];
        }
        return dst;
    }

    public static long[] toLong(double[] src) {
        int number = src.length;
        long[] dst = new long[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (long)src[j];
        }
        return dst;
    }

    public static float[] toFloat(byte[] src) {
        int number = src.length;
        float[] dst = new float[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j] & 0xFF;
        }
        return dst;
    }

    public static float[] toFloat(short[] src) {
        int number = src.length;
        float[] dst = new float[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static float[] toFloat(int[] src) {
        int number = src.length;
        float[] dst = new float[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static float[] toFloat(long[] src) {
        int number = src.length;
        float[] dst = new float[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static float[] toFloat(float[] src) {
        return src;
    }

    public static float[] toFloat(double[] src) {
        int number = src.length;
        float[] dst = new float[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = (float)src[j];
        }
        return dst;
    }

    public static double[] toDouble(byte[] src) {
        int number = src.length;
        double[] dst = new double[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j] & 0xFF;
        }
        return dst;
    }

    public static double[] toDouble(short[] src) {
        int number = src.length;
        double[] dst = new double[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static double[] toDouble(int[] src) {
        int number = src.length;
        double[] dst = new double[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static double[] toDouble(long[] src) {
        int number = src.length;
        double[] dst = new double[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static double[] toDouble(float[] src) {
        int number = src.length;
        double[] dst = new double[number];
        for (int j = 0; j < number; ++j) {
            dst[j] = src[j];
        }
        return dst;
    }

    public static double[] toDouble(double[] src) {
        return src;
    }

    public static ShapedArray pad(ShapedArray array, Shape shape) {
        return ArrayUtils.pad(array, shape, null, 0.0);
    }

    public static ShapedArray pad(ShapedArray array, Shape shape, Double value) {
        return ArrayUtils.pad(array, shape, null, value);
    }

    public static ShapedArray pad(ShapedArray array, Shape shape, int[] offset) {
        return ArrayUtils.pad(array, shape, offset, 0.0);
    }

    public static ShapedArray pad(ShapedArray array, Shape shape, int[] offset, double value) {
        Range[] range = ArrayUtils.getROI(shape, array.getShape(), offset);
        if (range == null) {
            return array;
        }
        int rank = range.length;
        int type = array.getType();
        ShapedArray result = ArrayFactory.create(type, shape);
        switch (type) {
            case 0: {
                ((ByteArray)result).fill((byte)value);
                break;
            }
            case 1: {
                ((ShortArray)result).fill((short)value);
                break;
            }
            case 2: {
                ((IntArray)result).fill((int)value);
                break;
            }
            case 3: {
                ((LongArray)result).fill((long)value);
                break;
            }
            case 4: {
                ((FloatArray)result).fill((float)value);
                break;
            }
            case 5: {
                ((DoubleArray)result).fill(value);
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
        switch (rank) {
            case 1: {
                ((Array1D)result).view(range[0]).assign(array);
                break;
            }
            case 2: {
                ((Array2D)result).view(range[0], range[1]).assign(array);
                break;
            }
            case 3: {
                ((Array3D)result).view(range[0], range[1], range[2]).assign(array);
                break;
            }
            case 4: {
                ((Array4D)result).view(range[0], range[1], range[2], range[3]).assign(array);
                break;
            }
            case 5: {
                ((Array5D)result).view(range[0], range[1], range[2], range[3], range[4]).assign(array);
                break;
            }
            case 6: {
                ((Array6D)result).view(range[0], range[1], range[2], range[3], range[4], range[5]).assign(array);
                break;
            }
            case 7: {
                ((Array7D)result).view(range[0], range[1], range[2], range[3], range[4], range[5], range[6]).assign(array);
                break;
            }
            case 8: {
                ((Array8D)result).view(range[0], range[1], range[2], range[3], range[4], range[5], range[6], range[7]).assign(array);
                break;
            }
            case 9: {
                ((Array9D)result).view(range[0], range[1], range[2], range[3], range[4], range[5], range[6], range[7], range[8]).assign(array);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported rank");
            }
        }
        return result;
    }

    public static ShapedArray crop(ShapedArray array, Shape shape) {
        return ArrayUtils.crop(array, shape, null);
    }

    public static ShapedArray crop(ShapedArray array, Shape shape, int[] offset) {
        Range[] range = ArrayUtils.getROI(array.getShape(), shape, offset);
        if (range == null) {
            return array;
        }
        switch (range.length) {
            case 1: {
                return ((Array1D)array).view(range[0]);
            }
            case 2: {
                return ((Array2D)array).view(range[0], range[1]);
            }
            case 3: {
                return ((Array3D)array).view(range[0], range[1], range[2]);
            }
            case 4: {
                return ((Array4D)array).view(range[0], range[1], range[2], range[3]);
            }
            case 5: {
                return ((Array5D)array).view(range[0], range[1], range[2], range[3], range[4]);
            }
            case 6: {
                return ((Array6D)array).view(range[0], range[1], range[2], range[3], range[4], range[5]);
            }
            case 7: {
                return ((Array7D)array).view(range[0], range[1], range[2], range[3], range[4], range[5], range[6]);
            }
            case 8: {
                return ((Array8D)array).view(range[0], range[1], range[2], range[3], range[4], range[5], range[6], range[7]);
            }
            case 9: {
                return ((Array9D)array).view(range[0], range[1], range[2], range[3], range[4], range[5], range[6], range[7], range[8]);
            }
        }
        throw new IllegalArgumentException("Unsupported rank");
    }

    private static Range[] getROI(Shape large, Shape small, int[] offset) {
        int k;
        int smallDim;
        int largeDim;
        int k2;
        int rank = large.rank();
        if (small.rank() != rank) {
            throw new NonConformableArrayException("Not same rank");
        }
        Boolean nothing = true;
        Boolean outOfBounds = false;
        if (offset == null) {
            for (k2 = 0; k2 < rank; ++k2) {
                largeDim = large.dimension(k2);
                smallDim = small.dimension(k2);
                if (smallDim > largeDim) {
                    outOfBounds = true;
                    break;
                }
                if (smallDim == largeDim) continue;
                nothing = false;
            }
        } else {
            if (offset.length != rank) {
                throw new NonConformableArrayException("Bad number of offsets");
            }
            for (k2 = 0; k2 < rank; ++k2) {
                largeDim = large.dimension(k2);
                smallDim = small.dimension(k2);
                if (offset[k2] < 0 || smallDim + offset[k2] > largeDim) {
                    outOfBounds = true;
                    break;
                }
                if (smallDim == largeDim) continue;
                nothing = false;
            }
        }
        if (outOfBounds.booleanValue()) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds region of interest");
        }
        if (nothing.booleanValue()) {
            return null;
        }
        Range[] range = new Range[rank];
        if (offset == null) {
            for (k = 0; k < rank; ++k) {
                int largeDim2 = large.dimension(k);
                int smallDim2 = small.dimension(k);
                int first = largeDim2 / 2 - smallDim2 / 2;
                int last = first + smallDim2 - 1;
                range[k] = new Range(first, last, 1);
            }
        } else {
            for (k = 0; k < rank; ++k) {
                smallDim = small.dimension(k);
                int first = offset[k];
                int last = first + smallDim - 1;
                range[k] = new Range(first, last, 1);
            }
        }
        return range;
    }

    public static ShapedArray extract(ShapedArray array, Shape shape, int[] offset, double value) {
        int rank = shape.rank();
        if (array.getRank() != rank) {
            throw new NonConformableArrayException("Bad number of dimensions for the resized array");
        }
        Range[] srcRange = new Range[rank];
        Range[] dstRange = new Range[rank];
        int ops = 0;
        for (int k = 0; k < rank; ++k) {
            int srcOff;
            int dstDim = shape.dimension(k);
            int srcDim = array.getDimension(k);
            int off = offset == null ? srcDim / 2 - dstDim / 2 : offset[k];
            int dstOff = Math.max(0, -off);
            int len = Math.min(dstDim - dstOff, srcDim - (srcOff = Math.max(0, off)));
            if (len <= 0) {
                ops = 5;
                break;
            }
            if (dstDim != srcDim) {
                ops |= 2;
            }
            if (dstOff > 0 || dstOff + len < dstDim) {
                ops |= 1;
            }
            srcRange[k] = new Range(srcOff, srcOff + len - 1);
            dstRange[k] = new Range(dstOff, dstOff + len - 1);
        }
        if (ops == 0) {
            return array;
        }
        int type = array.getType();
        ShapedArray result = ArrayFactory.create(type, shape);
        if (ops & true) {
            switch (type) {
                case 0: {
                    ((ByteArray)result).fill((byte)value);
                    break;
                }
                case 1: {
                    ((ShortArray)result).fill((short)value);
                    break;
                }
                case 2: {
                    ((IntArray)result).fill((int)value);
                    break;
                }
                case 3: {
                    ((LongArray)result).fill((long)value);
                    break;
                }
                case 4: {
                    ((FloatArray)result).fill((float)value);
                    break;
                }
                case 5: {
                    ((DoubleArray)result).fill(value);
                    break;
                }
                default: {
                    throw new IllegalTypeException();
                }
            }
        }
        if ((ops & 4) == 0) {
            switch (rank) {
                case 1: {
                    ((Array1D)result).view(dstRange[0]).assign(((Array1D)array).view(srcRange[0]));
                    break;
                }
                case 2: {
                    ((Array2D)result).view(dstRange[0], dstRange[1]).assign(((Array2D)array).view(srcRange[0], srcRange[1]));
                    break;
                }
                case 3: {
                    ((Array3D)result).view(dstRange[0], dstRange[1], dstRange[2]).assign(((Array3D)array).view(srcRange[0], srcRange[1], srcRange[2]));
                    break;
                }
                case 4: {
                    ((Array4D)result).view(dstRange[0], dstRange[1], dstRange[2], dstRange[3]).assign(((Array4D)array).view(srcRange[0], srcRange[1], srcRange[2], srcRange[3]));
                    break;
                }
                case 5: {
                    ((Array5D)result).view(dstRange[0], dstRange[1], dstRange[2], dstRange[3], dstRange[4]).assign(((Array5D)array).view(srcRange[0], srcRange[1], srcRange[2], srcRange[3], srcRange[4]));
                    break;
                }
                case 6: {
                    ((Array6D)result).view(dstRange[0], dstRange[1], dstRange[2], dstRange[3], dstRange[4], dstRange[5]).assign(((Array6D)array).view(srcRange[0], srcRange[1], srcRange[2], srcRange[3], srcRange[4], srcRange[5]));
                    break;
                }
                case 7: {
                    ((Array7D)result).view(dstRange[0], dstRange[1], dstRange[2], dstRange[3], dstRange[4], dstRange[5], dstRange[6]).assign(((Array7D)array).view(srcRange[0], srcRange[1], srcRange[2], srcRange[3], srcRange[4], srcRange[5], srcRange[6]));
                    break;
                }
                case 8: {
                    ((Array8D)result).view(dstRange[0], dstRange[1], dstRange[2], dstRange[3], dstRange[4], dstRange[5], dstRange[6], dstRange[7]).assign(((Array8D)array).view(srcRange[0], srcRange[1], srcRange[2], srcRange[3], srcRange[4], srcRange[5], srcRange[6], srcRange[7]));
                    break;
                }
                case 9: {
                    ((Array9D)result).view(dstRange[0], dstRange[1], dstRange[2], dstRange[3], dstRange[4], dstRange[5], dstRange[6], dstRange[7], dstRange[8]).assign(((Array9D)array).view(srcRange[0], srcRange[1], srcRange[2], srcRange[3], srcRange[4], srcRange[5], srcRange[6], srcRange[7], srcRange[8]));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported rank");
                }
            }
        }
        return result;
    }

    public static ShapedArray extract(ShapedArray array, Shape shape, int[] offset) {
        return ArrayUtils.extract(array, shape, offset, 0.0);
    }

    public static ShapedArray extract(ShapedArray array, Shape shape, double value) {
        return ArrayUtils.extract(array, shape, null, value);
    }

    public static ShapedArray extract(ShapedArray array, Shape shape) {
        return ArrayUtils.extract(array, shape, null, 0.0);
    }

    public static ShapedArray roll(ShapedArray arr) {
        Shape shape = arr.getShape();
        int rank = shape.rank();
        int[] off = new int[rank];
        boolean nothing = true;
        for (int k = 0; k < rank; ++k) {
            int dim = shape.dimension(k);
            off[k] = -(dim / 2);
            if (dim == 1) continue;
            nothing = false;
        }
        if (nothing) {
            return arr;
        }
        return ArrayUtils.roll(arr, off);
    }

    public static ShapedArray roll(ShapedArray arr, int[] off) {
        Shape shape = arr.getShape();
        int rank = shape.rank();
        if (off.length != rank) {
            throw new IllegalArgumentException("Range mismatch");
        }
        boolean nothing = true;
        int[][] sel = new int[rank][];
        for (int k = 0; k < rank; ++k) {
            int dim = shape.dimension(k);
            int offset = dim == 1 ? 0 : (dim + off[k] % dim) % dim;
            if (offset != 0) {
                nothing = false;
            }
            int[] index = new int[dim];
            for (int j = 0; j < dim; ++j) {
                index[j] = (j + offset) % dim;
            }
            sel[k] = index;
        }
        if (nothing) {
            return arr;
        }
        switch (rank) {
            case 1: {
                return ((Array1D)arr).view(sel[0]);
            }
            case 2: {
                return ((Array2D)arr).view(sel[0], sel[1]);
            }
            case 3: {
                return ((Array3D)arr).view(sel[0], sel[1], sel[2]);
            }
            case 4: {
                return ((Array4D)arr).view(sel[0], sel[1], sel[2], sel[3]);
            }
            case 5: {
                return ((Array5D)arr).view(sel[0], sel[1], sel[2], sel[3], sel[4]);
            }
            case 6: {
                return ((Array6D)arr).view(sel[0], sel[1], sel[2], sel[3], sel[4], sel[5]);
            }
            case 7: {
                return ((Array7D)arr).view(sel[0], sel[1], sel[2], sel[3], sel[4], sel[5], sel[6]);
            }
            case 8: {
                return ((Array8D)arr).view(sel[0], sel[1], sel[2], sel[3], sel[4], sel[5], sel[6], sel[7]);
            }
            case 9: {
                return ((Array9D)arr).view(sel[0], sel[1], sel[2], sel[3], sel[4], sel[5], sel[6], sel[7], sel[8]);
            }
        }
        throw new IllegalArgumentException("Unsupported rank");
    }

    public static ShapedArray dot(ShapedArray matrix, Array1D vector) {
        ShapedArray dotres;
        block28: {
            int maxtype;
            block27: {
                Shape shape1 = matrix.getShape();
                dotres = null;
                int rank1 = shape1.rank();
                if (shape1.dimension(rank1 - 1) != vector.getNumber()) {
                    throw new IllegalArgumentException("Last dimension of array 1 must match the first dimension of array 2.");
                }
                maxtype = Math.max(matrix.getType(), vector.getType());
                int dotrank = rank1 - 1;
                if (dotrank <= 0) break block27;
                int[] dotdims = new int[dotrank];
                System.arraycopy(shape1.copyDimensions(), 0, dotdims, 0, rank1 - 1);
                Shape dotshape = new Shape(dotdims);
                dotres = ArrayFactory.create(maxtype, dotshape);
                switch (rank1) {
                    case 2: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            ((Array1D)dotres).slice(k, 0).assign(ArrayUtils.dot(((Array2D)matrix).slice(k, 0), vector));
                        }
                        break block28;
                    }
                    case 3: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            ((Array2D)dotres).slice(k, 0).assign(ArrayUtils.dot(((Array3D)matrix).slice(k, 0), vector));
                        }
                        break block28;
                    }
                    case 4: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            ((Array3D)dotres).slice(k, 0).assign(ArrayUtils.dot(((Array4D)matrix).slice(k, 0), vector));
                        }
                        break block28;
                    }
                    case 5: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            ((Array4D)dotres).slice(k, 0).assign(ArrayUtils.dot(((Array5D)matrix).slice(k, 0), vector));
                        }
                        break block28;
                    }
                    case 6: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            ((Array5D)dotres).slice(k, 0).assign(ArrayUtils.dot(((Array6D)matrix).slice(k, 0), vector));
                        }
                        break block28;
                    }
                    case 7: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            ((Array6D)dotres).slice(k, 0).assign(ArrayUtils.dot(((Array7D)matrix).slice(k, 0), vector));
                        }
                        break block28;
                    }
                    case 8: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            ((Array7D)dotres).slice(k, 0).assign(ArrayUtils.dot(((Array8D)matrix).slice(k, 0), vector));
                        }
                        break block28;
                    }
                    case 9: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            ((Array8D)dotres).slice(k, 0).assign(ArrayUtils.dot(((Array9D)matrix).slice(k, 0), vector));
                        }
                        break block28;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported rank");
                    }
                }
            }
            switch (maxtype) {
                case 0: {
                    byte[] res = new byte[]{ArrayOps.dot(matrix.toByte().flatten(), vector.toByte().flatten())};
                    dotres = ArrayFactory.wrap(res);
                    break;
                }
                case 1: {
                    short[] res = new short[]{ArrayOps.dot(matrix.toShort().flatten(), vector.toShort().flatten())};
                    dotres = ArrayFactory.wrap(res);
                    break;
                }
                case 2: {
                    int[] res = new int[]{ArrayOps.dot(matrix.toInt().flatten(), vector.toInt().flatten())};
                    dotres = ArrayFactory.wrap(res);
                    break;
                }
                case 3: {
                    long[] res = new long[]{ArrayOps.dot(matrix.toLong().flatten(), vector.toLong().flatten())};
                    dotres = ArrayFactory.wrap(res);
                    break;
                }
                case 4: {
                    float[] res = new float[]{ArrayOps.dot(matrix.toFloat().flatten(), vector.toFloat().flatten())};
                    dotres = ArrayFactory.wrap(res);
                    break;
                }
                case 5: {
                    double[] res = new double[]{ArrayOps.dot(matrix.toDouble().flatten(), vector.toDouble().flatten())};
                    dotres = ArrayFactory.wrap(res);
                }
            }
        }
        return dotres;
    }

    public static ShapedArray outer(ShapedArray matrix, Array1D vector) {
        Shape shape1 = matrix.getShape();
        ShapedArray outres = null;
        int rank1 = shape1.rank();
        int maxtype = Math.max(matrix.getType(), vector.getType());
        int outrank = rank1 + 1;
        int[] dotdims = new int[outrank];
        System.arraycopy(shape1.copyDimensions(), 0, dotdims, 0, rank1);
        dotdims[rank1] = vector.getDimension(0);
        Shape dotshape = new Shape(dotdims);
        outres = ArrayFactory.create(maxtype, dotshape);
        block0 : switch (rank1) {
            case 1: {
                switch (maxtype) {
                    case 0: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            for (int l = 0; l < vector.getDimension(0); ++l) {
                                ((Byte2D)outres).set(k, l, (byte)(((Byte1D)matrix.toByte()).get(k) * ((Byte1D)vector.toByte()).get(l)));
                            }
                        }
                        break block0;
                    }
                    case 1: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            for (int l = 0; l < vector.getDimension(0); ++l) {
                                ((Short2D)outres).set(k, l, (short)(((Short1D)matrix.toShort()).get(k) * ((Short1D)vector.toShort()).get(l)));
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            for (int l = 0; l < vector.getDimension(0); ++l) {
                                ((Int2D)outres).set(k, l, ((Int1D)matrix.toInt()).get(k) * ((Int1D)vector.toInt()).get(l));
                            }
                        }
                        break block0;
                    }
                    case 3: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            for (int l = 0; l < vector.getDimension(0); ++l) {
                                ((Long2D)outres).set(k, l, ((Long1D)matrix.toLong()).get(k) * ((Long1D)vector.toLong()).get(l));
                            }
                        }
                        break block0;
                    }
                    case 4: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            for (int l = 0; l < vector.getDimension(0); ++l) {
                                ((Float2D)outres).set(k, l, ((Float1D)matrix.toFloat()).get(k) * ((Float1D)vector.toFloat()).get(l));
                            }
                        }
                        break block0;
                    }
                    case 5: {
                        for (int k = 0; k < matrix.getDimension(0); ++k) {
                            for (int l = 0; l < vector.getDimension(0); ++l) {
                                ((Double2D)outres).set(k, l, ((Double1D)matrix.toDouble()).get(k) * ((Double1D)vector.toDouble()).get(l));
                            }
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int k = 0; k < matrix.getDimension(0); ++k) {
                    ((Array3D)outres).slice(k, 0).assign(ArrayUtils.outer(((Array2D)matrix).slice(k, 0), vector));
                }
                break;
            }
            case 3: {
                for (int k = 0; k < matrix.getDimension(0); ++k) {
                    ((Array4D)outres).slice(k, 0).assign(ArrayUtils.outer(((Array3D)matrix).slice(k, 0), vector));
                }
                break;
            }
            case 4: {
                for (int k = 0; k < matrix.getDimension(0); ++k) {
                    ((Array5D)outres).slice(k, 0).assign(ArrayUtils.outer(((Array4D)matrix).slice(k, 0), vector));
                }
                break;
            }
            case 5: {
                for (int k = 0; k < matrix.getDimension(0); ++k) {
                    ((Array6D)outres).slice(k, 0).assign(ArrayUtils.outer(((Array5D)matrix).slice(k, 0), vector));
                }
                break;
            }
            case 6: {
                for (int k = 0; k < matrix.getDimension(0); ++k) {
                    ((Array7D)outres).slice(k, 0).assign(ArrayUtils.outer(((Array6D)matrix).slice(k, 0), vector));
                }
                break;
            }
            case 7: {
                for (int k = 0; k < matrix.getDimension(0); ++k) {
                    ((Array8D)outres).slice(k, 0).assign(ArrayUtils.outer(((Array7D)matrix).slice(k, 0), vector));
                }
                break;
            }
            case 8: {
                for (int k = 0; k < matrix.getDimension(0); ++k) {
                    ((Array9D)outres).slice(k, 0).assign(ArrayUtils.outer(((Array8D)matrix).slice(k, 0), vector));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported rank");
            }
        }
        return outres;
    }
}

