/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.variants;

import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import plugins.ylemontag.mathoperations.SubSequence;
import plugins.ylemontag.mathoperations.Variant;
import plugins.ylemontag.mathoperations.variants.DimensionSequence;
import plugins.ylemontag.mathoperations.variants.SequenceIterators;

public class VariantSubSequence
extends Variant {
    private SubSequence _value;

    public VariantSubSequence(SubSequence value) {
        super(Variant.Type.SUBSEQUENCE);
        if (value == null) {
            throw new IllegalArgumentException("Cannot wrap a null sub-sequence in a Variant object.");
        }
        this._value = value;
    }

    @Override
    public SubSequence getAsSubSequence() {
        return this._value;
    }

    @Override
    public String getRepresentation(boolean addParenthesisIfFragile) {
        String name = this._value.getSequence().getName();
        if (addParenthesisIfFragile && VariantSubSequence.isFragileString(name)) {
            return "(" + name + ")" + this._value.getSubRangeAsString();
        }
        return this._value.toString();
    }

    @Override
    public Variant.Dimension getDimension() {
        return new DimensionSequence(this._value.getSizeX(), this._value.getSizeY(), this._value.getSizeZ(), this._value.getSizeT(), this._value.getSizeC());
    }

    @Override
    public boolean isReadable() {
        return this._value.isValid();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    protected Variant.ReadIterator implGetReadIterator() {
        if (this._value.getSequence().getDataType_() == DataType.DOUBLE) {
            return new DoubleValuedSubSequenceIterator(this._value);
        }
        return new ConvertOnFlySubSequenceIterator(this._value);
    }

    @Override
    protected Variant.WriteIterator implGetWriteIterator() {
        throw new RuntimeException("Unreachable code point");
    }

    @Override
    protected void implBeginUpdate() {
        throw new RuntimeException("Unreachable code point");
    }

    @Override
    protected void implEndUpdate() {
        throw new RuntimeException("Unreachable code point");
    }

    private static class ConvertOnFlySubSequenceIterator
    extends ReadSubSequenceIterator {
        private boolean _isSigned;

        public ConvertOnFlySubSequenceIterator(SubSequence source) {
            super(source);
            this._isSigned = this._rawSource.getDataType_().isSigned();
            this._buffer = new double[this._sizeXY];
        }

        @Override
        protected void refreshBuffer() {
            this.refreshActualCoordinates();
            Array1DUtil.arrayToDoubleArray((Object)this._rawSource.getDataXY(this._actualT, this._actualZ, this._actualC), (double[])this._buffer, (boolean)this._isSigned);
        }
    }

    private static class DoubleValuedSubSequenceIterator
    extends ReadSubSequenceIterator {
        public DoubleValuedSubSequenceIterator(SubSequence source) {
            super(source);
        }

        @Override
        protected void refreshBuffer() {
            this.refreshActualCoordinates();
            this._buffer = this._rawSource.getDataXYAsDouble(this._actualT, this._actualZ, this._actualC);
        }
    }

    private static abstract class ReadSubSequenceIterator
    extends SequenceIterators.Read {
        private final int[] _indexT;
        private final int[] _indexZ;
        private final int[] _indexC;
        protected Sequence _rawSource;
        protected int _actualT;
        protected int _actualZ;
        protected int _actualC;

        public ReadSubSequenceIterator(SubSequence source) {
            super(source.getSizeX(), source.getSizeY(), source.getSizeZ(), source.getSizeT(), source.getSizeC());
            this._indexT = source.getT();
            this._indexZ = source.getZ();
            this._indexC = source.getC();
            this._rawSource = source.getSequence();
        }

        protected void refreshActualCoordinates() {
            this._actualT = this._indexT == null ? this._t : this._indexT[this._t];
            this._actualZ = this._indexZ == null ? this._z : this._indexZ[this._z];
            this._actualC = this._indexC == null ? this._c : this._indexC[this._c];
        }
    }
}

